--
-- PostgreSQL database dump
--

\restrict BZZkikYSZaDkfQ9LGpwf53hyS0hZaZfem6mremqogbqcArOHYWsUwcQrgD4bDbE

-- Dumped from database version 17.7 (Ubuntu 17.7-0ubuntu0.25.04.1)
-- Dumped by pg_dump version 18.1 (Ubuntu 18.1-1.pgdg22.04+2)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: queue_job_notify(); Type: FUNCTION; Schema: public; Owner: runbot
--

CREATE FUNCTION public.queue_job_notify() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
            BEGIN
                IF TG_OP = 'DELETE' THEN
                    IF OLD.state != 'done' THEN
                        PERFORM pg_notify('queue_job', OLD.uuid);
                    END IF;
                ELSE
                    PERFORM pg_notify('queue_job', NEW.uuid);
                END IF;
                RETURN NULL;
            END;
            $$;


ALTER FUNCTION public.queue_job_notify() OWNER TO runbot;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: account_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account (
    id integer NOT NULL,
    message_main_attachment_id integer,
    name character varying NOT NULL,
    currency_id integer,
    code character varying(64) NOT NULL,
    deprecated boolean,
    user_type_id integer NOT NULL,
    internal_type character varying,
    internal_group character varying,
    reconcile boolean,
    note text,
    company_id integer NOT NULL,
    group_id integer,
    root_id integer,
    is_off_balance boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    centralized boolean
);


ALTER TABLE public.account_account OWNER TO runbot;

--
-- Name: TABLE account_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account IS 'Account';


--
-- Name: COLUMN account_account.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.name IS 'Account Name';


--
-- Name: COLUMN account_account.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.currency_id IS 'Account Currency';


--
-- Name: COLUMN account_account.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.code IS 'Code';


--
-- Name: COLUMN account_account.deprecated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.deprecated IS 'Deprecated';


--
-- Name: COLUMN account_account.user_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.user_type_id IS 'Type';


--
-- Name: COLUMN account_account.internal_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.internal_type IS 'Internal Type';


--
-- Name: COLUMN account_account.internal_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.internal_group IS 'Internal Group';


--
-- Name: COLUMN account_account.reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.reconcile IS 'Allow Reconciliation';


--
-- Name: COLUMN account_account.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.note IS 'Internal Notes';


--
-- Name: COLUMN account_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.company_id IS 'Company';


--
-- Name: COLUMN account_account.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.group_id IS 'Group';


--
-- Name: COLUMN account_account.root_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.root_id IS 'Root';


--
-- Name: COLUMN account_account.is_off_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.is_off_balance IS 'Is Off Balance';


--
-- Name: COLUMN account_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_date IS 'Created on';


--
-- Name: COLUMN account_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_account.centralized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.centralized IS 'Centralized';


--
-- Name: account_account_account_fr_fec_oca_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_fr_fec_oca_rel (
    account_fr_fec_oca_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_fr_fec_oca_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_fr_fec_oca_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_fr_fec_oca_rel IS 'RELATION BETWEEN account_fr_fec_oca AND account_account';


--
-- Name: account_account_account_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_group_rel (
    account_group_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_group_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_group_rel IS 'RELATION BETWEEN account_group AND account_account';


--
-- Name: account_account_account_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_journal_rel (
    account_account_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_account_account_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_journal_rel IS 'RELATION BETWEEN account_account AND account_journal';


--
-- Name: account_account_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_tag (
    account_account_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_account_tag OWNER TO runbot;

--
-- Name: TABLE account_account_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_tag IS 'RELATION BETWEEN account_account AND account_account_tag';


--
-- Name: account_account_aged_partner_balance_report_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_aged_partner_balance_report_wizard_rel (
    aged_partner_balance_report_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_aged_partner_balance_report_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_account_aged_partner_balance_report_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_aged_partner_balance_report_wizard_rel IS 'RELATION BETWEEN aged_partner_balance_report_wizard AND account_account';


--
-- Name: account_account_general_ledger_report_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_general_ledger_report_wizard_rel (
    general_ledger_report_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_general_ledger_report_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_account_general_ledger_report_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_general_ledger_report_wizard_rel IS 'RELATION BETWEEN general_ledger_report_wizard AND account_account';


--
-- Name: account_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_id_seq OWNER TO runbot;

--
-- Name: account_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_id_seq OWNED BY public.account_account.id;


--
-- Name: account_account_open_items_report_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_open_items_report_wizard_rel (
    open_items_report_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_open_items_report_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_account_open_items_report_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_open_items_report_wizard_rel IS 'RELATION BETWEEN open_items_report_wizard AND account_account';


--
-- Name: account_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag (
    id integer NOT NULL,
    name character varying NOT NULL,
    applicability character varying NOT NULL,
    color integer,
    active boolean,
    tax_negate boolean,
    country_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_account_tag OWNER TO runbot;

--
-- Name: TABLE account_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag IS 'Account Tag';


--
-- Name: COLUMN account_account_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.name IS 'Tag Name';


--
-- Name: COLUMN account_account_tag.applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.applicability IS 'Applicability';


--
-- Name: COLUMN account_account_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.color IS 'Color Index';


--
-- Name: COLUMN account_account_tag.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.active IS 'Active';


--
-- Name: COLUMN account_account_tag.tax_negate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.tax_negate IS 'Negate Tax Balance';


--
-- Name: COLUMN account_account_tag.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.country_id IS 'Country';


--
-- Name: COLUMN account_account_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.create_date IS 'Created on';


--
-- Name: COLUMN account_account_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.write_date IS 'Last Updated on';


--
-- Name: account_account_tag_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_account_move_line_rel (
    account_move_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_account_move_line_rel IS 'RELATION BETWEEN account_move_line AND account_account_tag';


--
-- Name: account_account_tag_account_tax_repartition_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_account_tax_repartition_line_rel (
    account_tax_repartition_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_account_tax_repartition_line_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_account_tax_repartition_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_account_tax_repartition_line_rel IS 'RELATION BETWEEN account_tax_repartition_line AND account_account_tag';


--
-- Name: account_account_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_tag_id_seq OWNER TO runbot;

--
-- Name: account_account_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_tag_id_seq OWNED BY public.account_account_tag.id;


--
-- Name: account_account_tag_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_product_template_rel (
    product_template_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_product_template_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_product_template_rel IS 'RELATION BETWEEN product_template AND account_account_tag';


--
-- Name: account_account_tax_default_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tax_default_rel (
    account_id integer NOT NULL,
    tax_id integer NOT NULL
);


ALTER TABLE public.account_account_tax_default_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tax_default_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tax_default_rel IS 'RELATION BETWEEN account_account AND account_tax';


--
-- Name: account_account_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_template (
    id integer NOT NULL,
    message_main_attachment_id integer,
    name character varying NOT NULL,
    currency_id integer,
    code character varying(64) NOT NULL,
    user_type_id integer NOT NULL,
    reconcile boolean,
    note text,
    nocreate boolean,
    chart_template_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_account_template OWNER TO runbot;

--
-- Name: TABLE account_account_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_template IS 'Templates for Accounts';


--
-- Name: COLUMN account_account_template.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_account_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.name IS 'Name';


--
-- Name: COLUMN account_account_template.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.currency_id IS 'Account Currency';


--
-- Name: COLUMN account_account_template.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.code IS 'Code';


--
-- Name: COLUMN account_account_template.user_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.user_type_id IS 'Type';


--
-- Name: COLUMN account_account_template.reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.reconcile IS 'Allow Invoices & payments Matching';


--
-- Name: COLUMN account_account_template.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.note IS 'Note';


--
-- Name: COLUMN account_account_template.nocreate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.nocreate IS 'Optional Create';


--
-- Name: COLUMN account_account_template.chart_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_account_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.create_date IS 'Created on';


--
-- Name: COLUMN account_account_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.write_date IS 'Last Updated on';


--
-- Name: account_account_template_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_template_account_tag (
    account_account_template_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_template_account_tag OWNER TO runbot;

--
-- Name: TABLE account_account_template_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_template_account_tag IS 'RELATION BETWEEN account_account_template AND account_account_tag';


--
-- Name: account_account_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_template_id_seq OWNER TO runbot;

--
-- Name: account_account_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_template_id_seq OWNED BY public.account_account_template.id;


--
-- Name: account_account_template_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_template_tax_rel (
    account_id integer NOT NULL,
    tax_id integer NOT NULL
);


ALTER TABLE public.account_account_template_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_account_template_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_template_tax_rel IS 'RELATION BETWEEN account_account_template AND account_tax_template';


--
-- Name: account_account_trial_balance_report_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_trial_balance_report_wizard_rel (
    trial_balance_report_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_trial_balance_report_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_account_trial_balance_report_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_trial_balance_report_wizard_rel IS 'RELATION BETWEEN trial_balance_report_wizard AND account_account';


--
-- Name: account_account_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_type (
    id integer NOT NULL,
    name character varying NOT NULL,
    include_initial_balance boolean,
    type character varying NOT NULL,
    internal_group character varying NOT NULL,
    note text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_account_type OWNER TO runbot;

--
-- Name: TABLE account_account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_type IS 'Account Type';


--
-- Name: COLUMN account_account_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_type.name IS 'Account Type';


--
-- Name: COLUMN account_account_type.include_initial_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_type.include_initial_balance IS 'Bring Accounts Balance Forward';


--
-- Name: COLUMN account_account_type.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_type.type IS 'Type';


--
-- Name: COLUMN account_account_type.internal_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_type.internal_group IS 'Internal Group';


--
-- Name: COLUMN account_account_type.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_type.note IS 'Description';


--
-- Name: COLUMN account_account_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_type.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_type.create_date IS 'Created on';


--
-- Name: COLUMN account_account_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_type.write_date IS 'Last Updated on';


--
-- Name: account_account_type_account_fr_fec_oca_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_type_account_fr_fec_oca_rel (
    account_fr_fec_oca_id integer NOT NULL,
    account_account_type_id integer NOT NULL
);


ALTER TABLE public.account_account_type_account_fr_fec_oca_rel OWNER TO runbot;

--
-- Name: TABLE account_account_type_account_fr_fec_oca_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_type_account_fr_fec_oca_rel IS 'RELATION BETWEEN account_fr_fec_oca AND account_account_type';


--
-- Name: account_account_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_type_id_seq OWNER TO runbot;

--
-- Name: account_account_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_type_id_seq OWNED BY public.account_account_type.id;


--
-- Name: account_accrued_orders_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_accrued_orders_wizard (
    id integer NOT NULL,
    company_id integer,
    date date NOT NULL,
    amount numeric,
    currency_id integer,
    account_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_accrued_orders_wizard OWNER TO runbot;

--
-- Name: TABLE account_accrued_orders_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_accrued_orders_wizard IS 'Accrued Orders Wizard';


--
-- Name: COLUMN account_accrued_orders_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_accrued_orders_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.date IS 'Date';


--
-- Name: COLUMN account_accrued_orders_wizard.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.amount IS 'Amount';


--
-- Name: COLUMN account_accrued_orders_wizard.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.currency_id IS 'Company Currency';


--
-- Name: COLUMN account_accrued_orders_wizard.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.account_id IS 'Accrual Account';


--
-- Name: COLUMN account_accrued_orders_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_accrued_orders_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_accrued_orders_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_accrued_orders_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_date IS 'Last Updated on';


--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_accrued_orders_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNER TO runbot;

--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNED BY public.account_accrued_orders_wizard.id;


--
-- Name: account_analytic_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account (
    id integer NOT NULL,
    message_main_attachment_id integer,
    name character varying NOT NULL,
    code character varying,
    active boolean,
    group_id integer,
    company_id integer,
    partner_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_account OWNER TO runbot;

--
-- Name: TABLE account_analytic_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_analytic_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.name IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.code IS 'Reference';


--
-- Name: COLUMN account_analytic_account.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.active IS 'Active';


--
-- Name: COLUMN account_analytic_account.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.group_id IS 'Group';


--
-- Name: COLUMN account_analytic_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_account.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.partner_id IS 'Customer';


--
-- Name: COLUMN account_analytic_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_date IS 'Last Updated on';


--
-- Name: account_analytic_account_general_ledger_report_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account_general_ledger_report_wizard_rel (
    general_ledger_report_wizard_id integer NOT NULL,
    account_analytic_account_id integer NOT NULL
);


ALTER TABLE public.account_analytic_account_general_ledger_report_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_account_general_ledger_report_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account_general_ledger_report_wizard_rel IS 'RELATION BETWEEN general_ledger_report_wizard AND account_analytic_account';


--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_account_id_seq OWNER TO runbot;

--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_account_id_seq OWNED BY public.account_analytic_account.id;


--
-- Name: account_analytic_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_default (
    id integer NOT NULL,
    sequence integer,
    analytic_id integer,
    product_id integer,
    partner_id integer,
    account_id integer,
    user_id integer,
    company_id integer,
    date_start date,
    date_stop date,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_default OWNER TO runbot;

--
-- Name: TABLE account_analytic_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_default IS 'Analytic Distribution';


--
-- Name: COLUMN account_analytic_default.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_default.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_default.analytic_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_default.analytic_id IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_default.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_default.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_default.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_default.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_default.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_default.account_id IS 'Account';


--
-- Name: COLUMN account_analytic_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_default.user_id IS 'User';


--
-- Name: COLUMN account_analytic_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_default.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_default.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_default.date_start IS 'Start Date';


--
-- Name: COLUMN account_analytic_default.date_stop; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_default.date_stop IS 'End Date';


--
-- Name: COLUMN account_analytic_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_default.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_default.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_default.write_date IS 'Last Updated on';


--
-- Name: account_analytic_default_account_analytic_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_default_account_analytic_tag_rel (
    account_analytic_default_id integer NOT NULL,
    account_analytic_tag_id integer NOT NULL
);


ALTER TABLE public.account_analytic_default_account_analytic_tag_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_default_account_analytic_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_default_account_analytic_tag_rel IS 'RELATION BETWEEN account_analytic_default AND account_analytic_tag';


--
-- Name: account_analytic_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_default_id_seq OWNER TO runbot;

--
-- Name: account_analytic_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_default_id_seq OWNED BY public.account_analytic_default.id;


--
-- Name: account_analytic_distribution; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_distribution (
    id integer NOT NULL,
    account_id integer NOT NULL,
    percentage double precision NOT NULL,
    tag_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT account_analytic_distribution_check_percentage CHECK (((percentage >= (0)::double precision) AND (percentage <= (100)::double precision)))
);


ALTER TABLE public.account_analytic_distribution OWNER TO runbot;

--
-- Name: TABLE account_analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_distribution IS 'Analytic Account Distribution';


--
-- Name: COLUMN account_analytic_distribution.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution.account_id IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_distribution.percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution.percentage IS 'Percentage';


--
-- Name: COLUMN account_analytic_distribution.tag_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution.tag_id IS 'Parent tag';


--
-- Name: COLUMN account_analytic_distribution.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_distribution.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_distribution.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_distribution.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_analytic_distribution_check_percentage ON account_analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_analytic_distribution_check_percentage ON public.account_analytic_distribution IS 'CHECK(percentage >= 0 AND percentage <= 100)';


--
-- Name: account_analytic_distribution_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_distribution_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_distribution_id_seq OWNER TO runbot;

--
-- Name: account_analytic_distribution_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_distribution_id_seq OWNED BY public.account_analytic_distribution.id;


--
-- Name: account_analytic_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_group (
    id integer NOT NULL,
    name character varying NOT NULL,
    description text,
    parent_id integer,
    parent_path character varying,
    complete_name character varying,
    company_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_group OWNER TO runbot;

--
-- Name: TABLE account_analytic_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_group IS 'Analytic Categories';


--
-- Name: COLUMN account_analytic_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_group.name IS 'Name';


--
-- Name: COLUMN account_analytic_group.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_group.description IS 'Description';


--
-- Name: COLUMN account_analytic_group.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_group.parent_id IS 'Parent';


--
-- Name: COLUMN account_analytic_group.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_group.parent_path IS 'Parent Path';


--
-- Name: COLUMN account_analytic_group.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_group.complete_name IS 'Complete Name';


--
-- Name: COLUMN account_analytic_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_group.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_group.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_group.write_date IS 'Last Updated on';


--
-- Name: account_analytic_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_group_id_seq OWNER TO runbot;

--
-- Name: account_analytic_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_group_id_seq OWNED BY public.account_analytic_group.id;


--
-- Name: account_analytic_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line (
    id integer NOT NULL,
    name character varying NOT NULL,
    date date NOT NULL,
    amount numeric NOT NULL,
    unit_amount double precision,
    product_uom_id integer,
    account_id integer NOT NULL,
    partner_id integer,
    user_id integer,
    company_id integer NOT NULL,
    currency_id integer,
    group_id integer,
    category character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    product_id integer,
    general_account_id integer,
    move_id integer,
    code character varying(8),
    ref character varying,
    so_line integer
);


ALTER TABLE public.account_analytic_line OWNER TO runbot;

--
-- Name: TABLE account_analytic_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line IS 'Analytic Line';


--
-- Name: COLUMN account_analytic_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.name IS 'Description';


--
-- Name: COLUMN account_analytic_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.date IS 'Date';


--
-- Name: COLUMN account_analytic_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.amount IS 'Amount';


--
-- Name: COLUMN account_analytic_line.unit_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.unit_amount IS 'Quantity';


--
-- Name: COLUMN account_analytic_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_analytic_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.account_id IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_line.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.user_id IS 'User';


--
-- Name: COLUMN account_analytic_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_analytic_line.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.group_id IS 'Group';


--
-- Name: COLUMN account_analytic_line.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.category IS 'Category';


--
-- Name: COLUMN account_analytic_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_line.general_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.general_account_id IS 'Financial Account';


--
-- Name: COLUMN account_analytic_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.move_id IS 'Journal Item';


--
-- Name: COLUMN account_analytic_line.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.code IS 'Code';


--
-- Name: COLUMN account_analytic_line.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.ref IS 'Ref.';


--
-- Name: COLUMN account_analytic_line.so_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.so_line IS 'Sales Order Item';


--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_line_id_seq OWNER TO runbot;

--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_line_id_seq OWNED BY public.account_analytic_line.id;


--
-- Name: account_analytic_line_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line_tag_rel (
    line_id integer NOT NULL,
    tag_id integer NOT NULL
);


ALTER TABLE public.account_analytic_line_tag_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_line_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line_tag_rel IS 'RELATION BETWEEN account_analytic_line AND account_analytic_tag';


--
-- Name: account_analytic_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_tag (
    id integer NOT NULL,
    name character varying NOT NULL,
    color integer,
    active boolean,
    active_analytic_distribution boolean,
    company_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_tag OWNER TO runbot;

--
-- Name: TABLE account_analytic_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_tag IS 'Analytic Tags';


--
-- Name: COLUMN account_analytic_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_tag.name IS 'Analytic Tag';


--
-- Name: COLUMN account_analytic_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_tag.color IS 'Color Index';


--
-- Name: COLUMN account_analytic_tag.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_tag.active IS 'Active';


--
-- Name: COLUMN account_analytic_tag.active_analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_tag.active_analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_analytic_tag.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_tag.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_tag.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_tag.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_tag.write_date IS 'Last Updated on';


--
-- Name: account_analytic_tag_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_tag_account_move_line_rel (
    account_move_line_id integer NOT NULL,
    account_analytic_tag_id integer NOT NULL
);


ALTER TABLE public.account_analytic_tag_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_tag_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_tag_account_move_line_rel IS 'RELATION BETWEEN account_move_line AND account_analytic_tag';


--
-- Name: account_analytic_tag_general_ledger_report_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_tag_general_ledger_report_wizard_rel (
    general_ledger_report_wizard_id integer NOT NULL,
    account_analytic_tag_id integer NOT NULL
);


ALTER TABLE public.account_analytic_tag_general_ledger_report_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_tag_general_ledger_report_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_tag_general_ledger_report_wizard_rel IS 'RELATION BETWEEN general_ledger_report_wizard AND account_analytic_tag';


--
-- Name: account_analytic_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_tag_id_seq OWNER TO runbot;

--
-- Name: account_analytic_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_tag_id_seq OWNED BY public.account_analytic_tag.id;


--
-- Name: account_analytic_tag_mis_report_instance_period_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_tag_mis_report_instance_period_rel (
    mis_report_instance_period_id integer NOT NULL,
    account_analytic_tag_id integer NOT NULL
);


ALTER TABLE public.account_analytic_tag_mis_report_instance_period_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_tag_mis_report_instance_period_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_tag_mis_report_instance_period_rel IS 'RELATION BETWEEN mis_report_instance_period AND account_analytic_tag';


--
-- Name: account_analytic_tag_mis_report_instance_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_tag_mis_report_instance_rel (
    mis_report_instance_id integer NOT NULL,
    account_analytic_tag_id integer NOT NULL
);


ALTER TABLE public.account_analytic_tag_mis_report_instance_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_tag_mis_report_instance_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_tag_mis_report_instance_rel IS 'RELATION BETWEEN mis_report_instance AND account_analytic_tag';


--
-- Name: account_analytic_tag_purchase_order_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_tag_purchase_order_line_rel (
    purchase_order_line_id integer NOT NULL,
    account_analytic_tag_id integer NOT NULL
);


ALTER TABLE public.account_analytic_tag_purchase_order_line_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_tag_purchase_order_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_tag_purchase_order_line_rel IS 'RELATION BETWEEN purchase_order_line AND account_analytic_tag';


--
-- Name: account_analytic_tag_sale_order_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_tag_sale_order_line_rel (
    sale_order_line_id integer NOT NULL,
    account_analytic_tag_id integer NOT NULL
);


ALTER TABLE public.account_analytic_tag_sale_order_line_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_tag_sale_order_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_tag_sale_order_line_rel IS 'RELATION BETWEEN sale_order_line AND account_analytic_tag';


--
-- Name: account_analytic_tag_stock_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_tag_stock_move_rel (
    stock_move_id integer NOT NULL,
    account_analytic_tag_id integer NOT NULL
);


ALTER TABLE public.account_analytic_tag_stock_move_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_tag_stock_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_tag_stock_move_rel IS 'RELATION BETWEEN stock_move AND account_analytic_tag';


--
-- Name: account_analytic_tag_stock_scrap_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_tag_stock_scrap_rel (
    stock_scrap_id integer NOT NULL,
    account_analytic_tag_id integer NOT NULL
);


ALTER TABLE public.account_analytic_tag_stock_scrap_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_tag_stock_scrap_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_tag_stock_scrap_rel IS 'RELATION BETWEEN stock_scrap AND account_analytic_tag';


--
-- Name: account_automatic_entry_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_automatic_entry_wizard (
    id integer NOT NULL,
    action character varying NOT NULL,
    date date NOT NULL,
    company_id integer NOT NULL,
    percentage double precision,
    total_amount numeric,
    account_type character varying,
    destination_account_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_automatic_entry_wizard OWNER TO runbot;

--
-- Name: TABLE account_automatic_entry_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_automatic_entry_wizard IS 'Create Automatic Entries';


--
-- Name: COLUMN account_automatic_entry_wizard.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.action IS 'Action';


--
-- Name: COLUMN account_automatic_entry_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.date IS 'Date';


--
-- Name: COLUMN account_automatic_entry_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_automatic_entry_wizard.percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.percentage IS 'Percentage';


--
-- Name: COLUMN account_automatic_entry_wizard.total_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.total_amount IS 'Total Amount';


--
-- Name: COLUMN account_automatic_entry_wizard.account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.account_type IS 'Account Type';


--
-- Name: COLUMN account_automatic_entry_wizard.destination_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.destination_account_id IS 'To';


--
-- Name: COLUMN account_automatic_entry_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_automatic_entry_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_automatic_entry_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_automatic_entry_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_date IS 'Last Updated on';


--
-- Name: account_automatic_entry_wizard_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_automatic_entry_wizard_account_move_line_rel (
    account_automatic_entry_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_automatic_entry_wizard_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_automatic_entry_wizard_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_automatic_entry_wizard_account_move_line_rel IS 'RELATION BETWEEN account_automatic_entry_wizard AND account_move_line';


--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_automatic_entry_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNER TO runbot;

--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNED BY public.account_automatic_entry_wizard.id;


--
-- Name: account_bank_statement; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement (
    id integer NOT NULL,
    sequence_prefix character varying,
    sequence_number integer,
    message_main_attachment_id integer,
    name character varying,
    reference character varying,
    date date NOT NULL,
    date_done timestamp without time zone,
    balance_start numeric,
    balance_end_real numeric,
    state character varying NOT NULL,
    journal_id integer NOT NULL,
    company_id integer,
    total_entry_encoding numeric,
    balance_end numeric,
    difference numeric,
    user_id integer,
    cashbox_start_id integer,
    cashbox_end_id integer,
    previous_statement_id integer,
    is_valid_balance_start boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    accounting_date date
);


ALTER TABLE public.account_bank_statement OWNER TO runbot;

--
-- Name: TABLE account_bank_statement; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement IS 'Bank Statement';


--
-- Name: COLUMN account_bank_statement.sequence_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.sequence_prefix IS 'Sequence Prefix';


--
-- Name: COLUMN account_bank_statement.sequence_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.sequence_number IS 'Sequence Number';


--
-- Name: COLUMN account_bank_statement.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_bank_statement.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.name IS 'Reference';


--
-- Name: COLUMN account_bank_statement.reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.reference IS 'External Reference';


--
-- Name: COLUMN account_bank_statement.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.date IS 'Date';


--
-- Name: COLUMN account_bank_statement.date_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.date_done IS 'Closed On';


--
-- Name: COLUMN account_bank_statement.balance_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_start IS 'Starting Balance';


--
-- Name: COLUMN account_bank_statement.balance_end_real; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_end_real IS 'Ending Balance';


--
-- Name: COLUMN account_bank_statement.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.state IS 'Status';


--
-- Name: COLUMN account_bank_statement.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement.total_entry_encoding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.total_entry_encoding IS 'Transactions Subtotal';


--
-- Name: COLUMN account_bank_statement.balance_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_end IS 'Computed Balance';


--
-- Name: COLUMN account_bank_statement.difference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.difference IS 'Difference';


--
-- Name: COLUMN account_bank_statement.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.user_id IS 'Responsible';


--
-- Name: COLUMN account_bank_statement.cashbox_start_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.cashbox_start_id IS 'Starting Cashbox';


--
-- Name: COLUMN account_bank_statement.cashbox_end_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.cashbox_end_id IS 'Ending Cashbox';


--
-- Name: COLUMN account_bank_statement.previous_statement_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.previous_statement_id IS 'Previous Statement';


--
-- Name: COLUMN account_bank_statement.is_valid_balance_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.is_valid_balance_start IS 'Is Valid Balance Start';


--
-- Name: COLUMN account_bank_statement.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement.accounting_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.accounting_date IS 'Financial Date';


--
-- Name: account_bank_statement_cashbox; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_cashbox (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_bank_statement_cashbox OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_cashbox; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_cashbox IS 'Bank Statement Cashbox';


--
-- Name: COLUMN account_bank_statement_cashbox.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_cashbox.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_cashbox.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_cashbox.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_cashbox.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_cashbox.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_cashbox.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_cashbox.write_date IS 'Last Updated on';


--
-- Name: account_bank_statement_cashbox_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_cashbox_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_cashbox_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_cashbox_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_cashbox_id_seq OWNED BY public.account_bank_statement_cashbox.id;


--
-- Name: account_bank_statement_closebalance; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_closebalance (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_bank_statement_closebalance OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_closebalance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_closebalance IS 'Bank Statement Closing Balance';


--
-- Name: COLUMN account_bank_statement_closebalance.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_closebalance.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_closebalance.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_closebalance.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_closebalance.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_closebalance.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_closebalance.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_closebalance.write_date IS 'Last Updated on';


--
-- Name: account_bank_statement_closebalance_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_closebalance_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_closebalance_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_closebalance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_closebalance_id_seq OWNED BY public.account_bank_statement_closebalance.id;


--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_id_seq OWNED BY public.account_bank_statement.id;


--
-- Name: account_bank_statement_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    statement_id integer NOT NULL,
    sequence integer,
    account_number character varying,
    partner_name character varying,
    transaction_type character varying,
    payment_ref character varying NOT NULL,
    amount numeric,
    amount_currency numeric,
    foreign_currency_id integer,
    amount_residual double precision,
    currency_id integer,
    partner_id integer,
    is_reconciled boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    move_name character varying,
    unique_import_id character varying,
    raw_data text
);


ALTER TABLE public.account_bank_statement_line OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_line IS 'Bank Statement Line';


--
-- Name: COLUMN account_bank_statement_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_bank_statement_line.statement_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_bank_statement_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.account_number IS 'Bank Account Number';


--
-- Name: COLUMN account_bank_statement_line.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line.transaction_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_bank_statement_line.payment_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.payment_ref IS 'Label';


--
-- Name: COLUMN account_bank_statement_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_currency IS 'Amount Currency';


--
-- Name: COLUMN account_bank_statement_line.foreign_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.foreign_currency_id IS 'Foreign Currency';


--
-- Name: COLUMN account_bank_statement_line.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_bank_statement_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.currency_id IS 'Journal Currency';


--
-- Name: COLUMN account_bank_statement_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_bank_statement_line.is_reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_bank_statement_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement_line.move_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.move_name IS 'Journal Entry Name';


--
-- Name: COLUMN account_bank_statement_line.unique_import_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.unique_import_id IS 'Import ID';


--
-- Name: COLUMN account_bank_statement_line.raw_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.raw_data IS 'Raw Data';


--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNED BY public.account_bank_statement_line.id;


--
-- Name: account_cash_rounding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cash_rounding (
    id integer NOT NULL,
    name character varying NOT NULL,
    rounding double precision NOT NULL,
    strategy character varying NOT NULL,
    rounding_method character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_cash_rounding OWNER TO runbot;

--
-- Name: TABLE account_cash_rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cash_rounding IS 'Account Cash Rounding';


--
-- Name: COLUMN account_cash_rounding.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.name IS 'Name';


--
-- Name: COLUMN account_cash_rounding.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.rounding IS 'Rounding Precision';


--
-- Name: COLUMN account_cash_rounding.strategy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.strategy IS 'Rounding Strategy';


--
-- Name: COLUMN account_cash_rounding.rounding_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.rounding_method IS 'Rounding Method';


--
-- Name: COLUMN account_cash_rounding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.create_uid IS 'Created by';


--
-- Name: COLUMN account_cash_rounding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.create_date IS 'Created on';


--
-- Name: COLUMN account_cash_rounding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cash_rounding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.write_date IS 'Last Updated on';


--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cash_rounding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cash_rounding_id_seq OWNER TO runbot;

--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cash_rounding_id_seq OWNED BY public.account_cash_rounding.id;


--
-- Name: account_cashbox_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox_line (
    id integer NOT NULL,
    coin_value numeric NOT NULL,
    number integer,
    cashbox_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_cashbox_line OWNER TO runbot;

--
-- Name: TABLE account_cashbox_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox_line IS 'CashBox Line';


--
-- Name: COLUMN account_cashbox_line.coin_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_line.coin_value IS 'Coin/Bill Value';


--
-- Name: COLUMN account_cashbox_line.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_line.number IS '#Coins/Bills';


--
-- Name: COLUMN account_cashbox_line.cashbox_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_line.cashbox_id IS 'Cashbox';


--
-- Name: COLUMN account_cashbox_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_cashbox_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_line.create_date IS 'Created on';


--
-- Name: COLUMN account_cashbox_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cashbox_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_line.write_date IS 'Last Updated on';


--
-- Name: account_cashbox_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cashbox_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cashbox_line_id_seq OWNER TO runbot;

--
-- Name: account_cashbox_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cashbox_line_id_seq OWNED BY public.account_cashbox_line.id;


--
-- Name: account_chart_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_chart_template (
    id integer NOT NULL,
    name character varying NOT NULL,
    parent_id integer,
    code_digits integer NOT NULL,
    visible boolean,
    currency_id integer NOT NULL,
    use_anglo_saxon boolean,
    complete_tax_set boolean,
    bank_account_code_prefix character varying NOT NULL,
    cash_account_code_prefix character varying NOT NULL,
    transfer_account_code_prefix character varying NOT NULL,
    income_currency_exchange_account_id integer,
    expense_currency_exchange_account_id integer,
    country_id integer,
    account_journal_suspense_account_id integer,
    account_journal_payment_debit_account_id integer,
    account_journal_payment_credit_account_id integer,
    default_cash_difference_income_account_id integer,
    default_cash_difference_expense_account_id integer,
    default_pos_receivable_account_id integer,
    property_account_receivable_id integer,
    property_account_payable_id integer,
    property_account_expense_categ_id integer,
    property_account_income_categ_id integer,
    property_account_expense_id integer,
    property_account_income_id integer,
    property_stock_account_input_categ_id integer,
    property_stock_account_output_categ_id integer,
    property_stock_valuation_account_id integer,
    property_tax_payable_account_id integer,
    property_tax_receivable_account_id integer,
    property_advance_tax_payment_account_id integer,
    property_cash_basis_base_account_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_chart_template OWNER TO runbot;

--
-- Name: TABLE account_chart_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_chart_template IS 'Account Chart Template';


--
-- Name: COLUMN account_chart_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.name IS 'Name';


--
-- Name: COLUMN account_chart_template.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.parent_id IS 'Parent Chart Template';


--
-- Name: COLUMN account_chart_template.code_digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.code_digits IS '# of Digits';


--
-- Name: COLUMN account_chart_template.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.visible IS 'Can be Visible?';


--
-- Name: COLUMN account_chart_template.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.currency_id IS 'Currency';


--
-- Name: COLUMN account_chart_template.use_anglo_saxon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.use_anglo_saxon IS 'Use Anglo-Saxon accounting';


--
-- Name: COLUMN account_chart_template.complete_tax_set; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.complete_tax_set IS 'Complete Set of Taxes';


--
-- Name: COLUMN account_chart_template.bank_account_code_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.bank_account_code_prefix IS 'Prefix of the bank accounts';


--
-- Name: COLUMN account_chart_template.cash_account_code_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.cash_account_code_prefix IS 'Prefix of the main cash accounts';


--
-- Name: COLUMN account_chart_template.transfer_account_code_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.transfer_account_code_prefix IS 'Prefix of the main transfer accounts';


--
-- Name: COLUMN account_chart_template.income_currency_exchange_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.income_currency_exchange_account_id IS 'Gain Exchange Rate Account';


--
-- Name: COLUMN account_chart_template.expense_currency_exchange_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.expense_currency_exchange_account_id IS 'Loss Exchange Rate Account';


--
-- Name: COLUMN account_chart_template.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.country_id IS 'Country';


--
-- Name: COLUMN account_chart_template.account_journal_suspense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.account_journal_suspense_account_id IS 'Journal Suspense Account';


--
-- Name: COLUMN account_chart_template.account_journal_payment_debit_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.account_journal_payment_debit_account_id IS 'Journal Outstanding Receipts Account';


--
-- Name: COLUMN account_chart_template.account_journal_payment_credit_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.account_journal_payment_credit_account_id IS 'Journal Outstanding Payments Account';


--
-- Name: COLUMN account_chart_template.default_cash_difference_income_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.default_cash_difference_income_account_id IS 'Cash Difference Income Account';


--
-- Name: COLUMN account_chart_template.default_cash_difference_expense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.default_cash_difference_expense_account_id IS 'Cash Difference Expense Account';


--
-- Name: COLUMN account_chart_template.default_pos_receivable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.default_pos_receivable_account_id IS 'PoS receivable account';


--
-- Name: COLUMN account_chart_template.property_account_receivable_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_account_receivable_id IS 'Receivable Account';


--
-- Name: COLUMN account_chart_template.property_account_payable_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_account_payable_id IS 'Payable Account';


--
-- Name: COLUMN account_chart_template.property_account_expense_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_account_expense_categ_id IS 'Category of Expense Account';


--
-- Name: COLUMN account_chart_template.property_account_income_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_account_income_categ_id IS 'Category of Income Account';


--
-- Name: COLUMN account_chart_template.property_account_expense_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_account_expense_id IS 'Expense Account on Product Template';


--
-- Name: COLUMN account_chart_template.property_account_income_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_account_income_id IS 'Income Account on Product Template';


--
-- Name: COLUMN account_chart_template.property_stock_account_input_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_stock_account_input_categ_id IS 'Input Account for Stock Valuation';


--
-- Name: COLUMN account_chart_template.property_stock_account_output_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_stock_account_output_categ_id IS 'Output Account for Stock Valuation';


--
-- Name: COLUMN account_chart_template.property_stock_valuation_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_stock_valuation_account_id IS 'Account Template for Stock Valuation';


--
-- Name: COLUMN account_chart_template.property_tax_payable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_tax_payable_account_id IS 'Tax current account (payable)';


--
-- Name: COLUMN account_chart_template.property_tax_receivable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_tax_receivable_account_id IS 'Tax current account (receivable)';


--
-- Name: COLUMN account_chart_template.property_advance_tax_payment_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_advance_tax_payment_account_id IS 'Advance tax payment account';


--
-- Name: COLUMN account_chart_template.property_cash_basis_base_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_cash_basis_base_account_id IS 'Base Tax Received Account';


--
-- Name: COLUMN account_chart_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_chart_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.create_date IS 'Created on';


--
-- Name: COLUMN account_chart_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_chart_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.write_date IS 'Last Updated on';


--
-- Name: account_chart_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_chart_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_chart_template_id_seq OWNER TO runbot;

--
-- Name: account_chart_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_chart_template_id_seq OWNED BY public.account_chart_template.id;


--
-- Name: account_common_journal_report; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_common_journal_report (
    id integer NOT NULL,
    company_id integer NOT NULL,
    date_from date,
    date_to date,
    target_move character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    amount_currency boolean
);


ALTER TABLE public.account_common_journal_report OWNER TO runbot;

--
-- Name: TABLE account_common_journal_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_common_journal_report IS 'Common Journal Report';


--
-- Name: COLUMN account_common_journal_report.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_journal_report.company_id IS 'Company';


--
-- Name: COLUMN account_common_journal_report.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_journal_report.date_from IS 'Start Date';


--
-- Name: COLUMN account_common_journal_report.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_journal_report.date_to IS 'End Date';


--
-- Name: COLUMN account_common_journal_report.target_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_journal_report.target_move IS 'Target Moves';


--
-- Name: COLUMN account_common_journal_report.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_journal_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_common_journal_report.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_journal_report.create_date IS 'Created on';


--
-- Name: COLUMN account_common_journal_report.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_journal_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_common_journal_report.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_journal_report.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_common_journal_report.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_journal_report.amount_currency IS 'With Currency';


--
-- Name: account_common_journal_report_account_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_common_journal_report_account_journal_rel (
    account_common_journal_report_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_common_journal_report_account_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_common_journal_report_account_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_common_journal_report_account_journal_rel IS 'RELATION BETWEEN account_common_journal_report AND account_journal';


--
-- Name: account_common_journal_report_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_common_journal_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_common_journal_report_id_seq OWNER TO runbot;

--
-- Name: account_common_journal_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_common_journal_report_id_seq OWNED BY public.account_common_journal_report.id;


--
-- Name: account_common_report; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_common_report (
    id integer NOT NULL,
    company_id integer NOT NULL,
    date_from date,
    date_to date,
    target_move character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_common_report OWNER TO runbot;

--
-- Name: TABLE account_common_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_common_report IS 'Account Common Report';


--
-- Name: COLUMN account_common_report.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_report.company_id IS 'Company';


--
-- Name: COLUMN account_common_report.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_report.date_from IS 'Start Date';


--
-- Name: COLUMN account_common_report.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_report.date_to IS 'End Date';


--
-- Name: COLUMN account_common_report.target_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_report.target_move IS 'Target Moves';


--
-- Name: COLUMN account_common_report.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_common_report.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_report.create_date IS 'Created on';


--
-- Name: COLUMN account_common_report.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_common_report.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_common_report.write_date IS 'Last Updated on';


--
-- Name: account_common_report_account_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_common_report_account_journal_rel (
    account_common_report_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_common_report_account_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_common_report_account_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_common_report_account_journal_rel IS 'RELATION BETWEEN account_common_report AND account_journal';


--
-- Name: account_common_report_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_common_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_common_report_id_seq OWNER TO runbot;

--
-- Name: account_common_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_common_report_id_seq OWNED BY public.account_common_report.id;


--
-- Name: account_edi_document; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_edi_document (
    id integer NOT NULL,
    move_id integer NOT NULL,
    edi_format_id integer NOT NULL,
    attachment_id integer,
    state character varying,
    error text,
    blocking_level character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_edi_document OWNER TO runbot;

--
-- Name: TABLE account_edi_document; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_edi_document IS 'Electronic Document for an account.move';


--
-- Name: COLUMN account_edi_document.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.move_id IS 'Move';


--
-- Name: COLUMN account_edi_document.edi_format_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.edi_format_id IS 'Edi Format';


--
-- Name: COLUMN account_edi_document.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.attachment_id IS 'Attachment';


--
-- Name: COLUMN account_edi_document.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.state IS 'State';


--
-- Name: COLUMN account_edi_document.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.error IS 'Error';


--
-- Name: COLUMN account_edi_document.blocking_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.blocking_level IS 'Blocking Level';


--
-- Name: COLUMN account_edi_document.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.create_uid IS 'Created by';


--
-- Name: COLUMN account_edi_document.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.create_date IS 'Created on';


--
-- Name: COLUMN account_edi_document.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_edi_document.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.write_date IS 'Last Updated on';


--
-- Name: account_edi_document_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_edi_document_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_edi_document_id_seq OWNER TO runbot;

--
-- Name: account_edi_document_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_edi_document_id_seq OWNED BY public.account_edi_document.id;


--
-- Name: account_edi_format; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_edi_format (
    id integer NOT NULL,
    name character varying,
    code character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_edi_format OWNER TO runbot;

--
-- Name: TABLE account_edi_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_edi_format IS 'EDI format';


--
-- Name: COLUMN account_edi_format.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.name IS 'Name';


--
-- Name: COLUMN account_edi_format.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.code IS 'Code';


--
-- Name: COLUMN account_edi_format.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.create_uid IS 'Created by';


--
-- Name: COLUMN account_edi_format.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.create_date IS 'Created on';


--
-- Name: COLUMN account_edi_format.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_edi_format.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.write_date IS 'Last Updated on';


--
-- Name: account_edi_format_account_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_edi_format_account_journal_rel (
    account_journal_id integer NOT NULL,
    account_edi_format_id integer NOT NULL
);


ALTER TABLE public.account_edi_format_account_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_edi_format_account_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_edi_format_account_journal_rel IS 'RELATION BETWEEN account_journal AND account_edi_format';


--
-- Name: account_edi_format_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_edi_format_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_edi_format_id_seq OWNER TO runbot;

--
-- Name: account_edi_format_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_edi_format_id_seq OWNED BY public.account_edi_format.id;


--
-- Name: account_financial_year_op; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_financial_year_op (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_financial_year_op OWNER TO runbot;

--
-- Name: TABLE account_financial_year_op; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_financial_year_op IS 'Opening Balance of Financial Year';


--
-- Name: COLUMN account_financial_year_op.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.company_id IS 'Company';


--
-- Name: COLUMN account_financial_year_op.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.create_uid IS 'Created by';


--
-- Name: COLUMN account_financial_year_op.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.create_date IS 'Created on';


--
-- Name: COLUMN account_financial_year_op.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_financial_year_op.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.write_date IS 'Last Updated on';


--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_financial_year_op_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_financial_year_op_id_seq OWNER TO runbot;

--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_financial_year_op_id_seq OWNED BY public.account_financial_year_op.id;


--
-- Name: account_fiscal_position; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position (
    id integer NOT NULL,
    sequence integer,
    name character varying NOT NULL,
    active boolean,
    company_id integer NOT NULL,
    note text,
    auto_apply boolean,
    vat_required boolean,
    country_id integer,
    country_group_id integer,
    zip_from character varying,
    zip_to character varying,
    foreign_vat character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    intrastat boolean
);


ALTER TABLE public.account_fiscal_position OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.sequence IS 'Sequence';


--
-- Name: COLUMN account_fiscal_position.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.name IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.active IS 'Active';


--
-- Name: COLUMN account_fiscal_position.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.note IS 'Notes';


--
-- Name: COLUMN account_fiscal_position.auto_apply; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.auto_apply IS 'Detect Automatically';


--
-- Name: COLUMN account_fiscal_position.vat_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.vat_required IS 'VAT required';


--
-- Name: COLUMN account_fiscal_position.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.country_id IS 'Country';


--
-- Name: COLUMN account_fiscal_position.country_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.country_group_id IS 'Country Group';


--
-- Name: COLUMN account_fiscal_position.zip_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.zip_from IS 'Zip Range From';


--
-- Name: COLUMN account_fiscal_position.zip_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.zip_to IS 'Zip Range To';


--
-- Name: COLUMN account_fiscal_position.foreign_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.foreign_vat IS 'Foreign Tax ID';


--
-- Name: COLUMN account_fiscal_position.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_fiscal_position.intrastat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.intrastat IS 'Intrastat';


--
-- Name: account_fiscal_position_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_account (
    id integer NOT NULL,
    position_id integer NOT NULL,
    company_id integer,
    account_src_id integer NOT NULL,
    account_dest_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_account OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_account IS 'Accounts Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position_account.account_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_src_id IS 'Account on Product';


--
-- Name: COLUMN account_fiscal_position_account.account_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_dest_id IS 'Account to Use Instead';


--
-- Name: COLUMN account_fiscal_position_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNED BY public.account_fiscal_position_account.id;


--
-- Name: account_fiscal_position_account_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_account_template (
    id integer NOT NULL,
    position_id integer NOT NULL,
    account_src_id integer NOT NULL,
    account_dest_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_account_template OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_account_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_account_template IS 'Accounts Mapping Template of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account_template.position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.position_id IS 'Fiscal Mapping';


--
-- Name: COLUMN account_fiscal_position_account_template.account_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.account_src_id IS 'Account Source';


--
-- Name: COLUMN account_fiscal_position_account_template.account_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.account_dest_id IS 'Account Destination';


--
-- Name: COLUMN account_fiscal_position_account_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_account_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_account_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_account_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_account_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_account_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_account_template_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_account_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_account_template_id_seq OWNED BY public.account_fiscal_position_account_template.id;


--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_id_seq OWNED BY public.account_fiscal_position.id;


--
-- Name: account_fiscal_position_res_country_state_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_res_country_state_rel (
    account_fiscal_position_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_res_country_state_rel OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_res_country_state_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_res_country_state_rel IS 'RELATION BETWEEN account_fiscal_position AND res_country_state';


--
-- Name: account_fiscal_position_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_tax (
    id integer NOT NULL,
    position_id integer NOT NULL,
    company_id integer,
    tax_src_id integer NOT NULL,
    tax_dest_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_tax OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_tax IS 'Tax Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position_tax.tax_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.tax_src_id IS 'Tax on Product';


--
-- Name: COLUMN account_fiscal_position_tax.tax_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.tax_dest_id IS 'Tax to Apply';


--
-- Name: COLUMN account_fiscal_position_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_tax_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_tax_id_seq OWNED BY public.account_fiscal_position_tax.id;


--
-- Name: account_fiscal_position_tax_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_tax_template (
    id integer NOT NULL,
    position_id integer NOT NULL,
    tax_src_id integer NOT NULL,
    tax_dest_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_tax_template OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_tax_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_tax_template IS 'Tax Mapping Template of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax_template.position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax_template.tax_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.tax_src_id IS 'Tax Source';


--
-- Name: COLUMN account_fiscal_position_tax_template.tax_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.tax_dest_id IS 'Replacement Tax';


--
-- Name: COLUMN account_fiscal_position_tax_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_tax_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_tax_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_tax_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_tax_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_tax_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_tax_template_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_tax_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_tax_template_id_seq OWNED BY public.account_fiscal_position_tax_template.id;


--
-- Name: account_fiscal_position_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_template (
    id integer NOT NULL,
    sequence integer,
    name character varying NOT NULL,
    chart_template_id integer NOT NULL,
    note text,
    auto_apply boolean,
    vat_required boolean,
    country_id integer,
    country_group_id integer,
    zip_from character varying,
    zip_to character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    intrastat boolean
);


ALTER TABLE public.account_fiscal_position_template OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_template IS 'Template for Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.sequence IS 'Sequence';


--
-- Name: COLUMN account_fiscal_position_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.name IS 'Fiscal Position Template';


--
-- Name: COLUMN account_fiscal_position_template.chart_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_fiscal_position_template.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.note IS 'Notes';


--
-- Name: COLUMN account_fiscal_position_template.auto_apply; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.auto_apply IS 'Detect Automatically';


--
-- Name: COLUMN account_fiscal_position_template.vat_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.vat_required IS 'VAT required';


--
-- Name: COLUMN account_fiscal_position_template.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.country_id IS 'Country';


--
-- Name: COLUMN account_fiscal_position_template.country_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.country_group_id IS 'Country Group';


--
-- Name: COLUMN account_fiscal_position_template.zip_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.zip_from IS 'Zip Range From';


--
-- Name: COLUMN account_fiscal_position_template.zip_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.zip_to IS 'Zip Range To';


--
-- Name: COLUMN account_fiscal_position_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_fiscal_position_template.intrastat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.intrastat IS 'Intrastat';


--
-- Name: account_fiscal_position_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_template_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_template_id_seq OWNED BY public.account_fiscal_position_template.id;


--
-- Name: account_fiscal_position_template_res_country_state_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_template_res_country_state_rel (
    account_fiscal_position_template_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_template_res_country_state_rel OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_template_res_country_state_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_template_res_country_state_rel IS 'RELATION BETWEEN account_fiscal_position_template AND res_country_state';


--
-- Name: account_fr_fec; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fr_fec (
    id integer NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    filename character varying(256),
    test_file boolean,
    export_type character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fr_fec OWNER TO runbot;

--
-- Name: TABLE account_fr_fec; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fr_fec IS 'Ficher Echange Informatise';


--
-- Name: COLUMN account_fr_fec.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec.date_from IS 'Start Date';


--
-- Name: COLUMN account_fr_fec.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec.date_to IS 'End Date';


--
-- Name: COLUMN account_fr_fec.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec.filename IS 'Filename';


--
-- Name: COLUMN account_fr_fec.test_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec.test_file IS 'Test File';


--
-- Name: COLUMN account_fr_fec.export_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec.export_type IS 'Export Type';


--
-- Name: COLUMN account_fr_fec.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec.create_uid IS 'Created by';


--
-- Name: COLUMN account_fr_fec.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec.create_date IS 'Created on';


--
-- Name: COLUMN account_fr_fec.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fr_fec.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec.write_date IS 'Last Updated on';


--
-- Name: account_fr_fec_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fr_fec_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fr_fec_id_seq OWNER TO runbot;

--
-- Name: account_fr_fec_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fr_fec_id_seq OWNED BY public.account_fr_fec.id;


--
-- Name: account_fr_fec_oca; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fr_fec_oca (
    id integer NOT NULL,
    company_id integer NOT NULL,
    date_range_id integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    encoding character varying NOT NULL,
    delimiter character varying NOT NULL,
    partner_option character varying NOT NULL,
    partner_identifier character varying NOT NULL,
    filename character varying(256),
    export_type character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fr_fec_oca OWNER TO runbot;

--
-- Name: TABLE account_fr_fec_oca; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fr_fec_oca IS 'Ficher Echange Informatise';


--
-- Name: COLUMN account_fr_fec_oca.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec_oca.company_id IS 'Company';


--
-- Name: COLUMN account_fr_fec_oca.date_range_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec_oca.date_range_id IS 'Date Range';


--
-- Name: COLUMN account_fr_fec_oca.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec_oca.date_from IS 'Start Date';


--
-- Name: COLUMN account_fr_fec_oca.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec_oca.date_to IS 'End Date';


--
-- Name: COLUMN account_fr_fec_oca.encoding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec_oca.encoding IS 'Encoding';


--
-- Name: COLUMN account_fr_fec_oca.delimiter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec_oca.delimiter IS 'Field Delimiter';


--
-- Name: COLUMN account_fr_fec_oca.partner_option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec_oca.partner_option IS 'Partner Export Option';


--
-- Name: COLUMN account_fr_fec_oca.partner_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec_oca.partner_identifier IS 'Partner Identifier';


--
-- Name: COLUMN account_fr_fec_oca.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec_oca.filename IS 'Filename';


--
-- Name: COLUMN account_fr_fec_oca.export_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec_oca.export_type IS 'Export Type';


--
-- Name: COLUMN account_fr_fec_oca.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec_oca.create_uid IS 'Created by';


--
-- Name: COLUMN account_fr_fec_oca.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec_oca.create_date IS 'Created on';


--
-- Name: COLUMN account_fr_fec_oca.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec_oca.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fr_fec_oca.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fr_fec_oca.write_date IS 'Last Updated on';


--
-- Name: account_fr_fec_oca_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fr_fec_oca_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fr_fec_oca_id_seq OWNER TO runbot;

--
-- Name: account_fr_fec_oca_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fr_fec_oca_id_seq OWNED BY public.account_fr_fec_oca.id;


--
-- Name: account_full_reconcile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_full_reconcile (
    id integer NOT NULL,
    name character varying NOT NULL,
    exchange_move_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_full_reconcile OWNER TO runbot;

--
-- Name: TABLE account_full_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_full_reconcile IS 'Full Reconcile';


--
-- Name: COLUMN account_full_reconcile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.name IS 'Number';


--
-- Name: COLUMN account_full_reconcile.exchange_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.exchange_move_id IS 'Exchange Move';


--
-- Name: COLUMN account_full_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_full_reconcile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_full_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_full_reconcile.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_full_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_full_reconcile_id_seq OWNER TO runbot;

--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_full_reconcile_id_seq OWNED BY public.account_full_reconcile.id;


--
-- Name: account_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_group (
    id integer NOT NULL,
    parent_id integer,
    parent_path character varying,
    name character varying NOT NULL,
    code_prefix_start character varying,
    code_prefix_end character varying,
    company_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT account_group_check_length_prefix CHECK ((char_length((COALESCE(code_prefix_start, ''::character varying))::text) = char_length((COALESCE(code_prefix_end, ''::character varying))::text)))
);


ALTER TABLE public.account_group OWNER TO runbot;

--
-- Name: TABLE account_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_group IS 'Account Group';


--
-- Name: COLUMN account_group.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.parent_id IS 'Parent';


--
-- Name: COLUMN account_group.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.parent_path IS 'Parent Path';


--
-- Name: COLUMN account_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.name IS 'Name';


--
-- Name: COLUMN account_group.code_prefix_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.code_prefix_start IS 'Code Prefix Start';


--
-- Name: COLUMN account_group.code_prefix_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.code_prefix_end IS 'Code Prefix End';


--
-- Name: COLUMN account_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.company_id IS 'Company';


--
-- Name: COLUMN account_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.create_date IS 'Created on';


--
-- Name: COLUMN account_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_group_check_length_prefix ON account_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_group_check_length_prefix ON public.account_group IS 'CHECK(char_length(COALESCE(code_prefix_start, '''')) = char_length(COALESCE(code_prefix_end, '''')))';


--
-- Name: account_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_group_id_seq OWNER TO runbot;

--
-- Name: account_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_group_id_seq OWNED BY public.account_group.id;


--
-- Name: account_group_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_group_template (
    id integer NOT NULL,
    parent_id integer,
    name character varying NOT NULL,
    code_prefix_start character varying,
    code_prefix_end character varying,
    chart_template_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_group_template OWNER TO runbot;

--
-- Name: TABLE account_group_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_group_template IS 'Template for Account Groups';


--
-- Name: COLUMN account_group_template.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.parent_id IS 'Parent';


--
-- Name: COLUMN account_group_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.name IS 'Name';


--
-- Name: COLUMN account_group_template.code_prefix_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.code_prefix_start IS 'Code Prefix Start';


--
-- Name: COLUMN account_group_template.code_prefix_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.code_prefix_end IS 'Code Prefix End';


--
-- Name: COLUMN account_group_template.chart_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_group_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_group_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.create_date IS 'Created on';


--
-- Name: COLUMN account_group_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_group_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.write_date IS 'Last Updated on';


--
-- Name: account_group_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_group_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_group_template_id_seq OWNER TO runbot;

--
-- Name: account_group_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_group_template_id_seq OWNED BY public.account_group_template.id;


--
-- Name: account_incoterms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_incoterms (
    id integer NOT NULL,
    name character varying NOT NULL,
    code character varying(3) NOT NULL,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_incoterms OWNER TO runbot;

--
-- Name: TABLE account_incoterms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_incoterms IS 'Incoterms';


--
-- Name: COLUMN account_incoterms.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.name IS 'Name';


--
-- Name: COLUMN account_incoterms.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.code IS 'Code';


--
-- Name: COLUMN account_incoterms.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.active IS 'Active';


--
-- Name: COLUMN account_incoterms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.create_uid IS 'Created by';


--
-- Name: COLUMN account_incoterms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.create_date IS 'Created on';


--
-- Name: COLUMN account_incoterms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_incoterms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.write_date IS 'Last Updated on';


--
-- Name: account_incoterms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_incoterms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_incoterms_id_seq OWNER TO runbot;

--
-- Name: account_incoterms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_incoterms_id_seq OWNED BY public.account_incoterms.id;


--
-- Name: account_invoice_send; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_send (
    id integer NOT NULL,
    is_email boolean,
    is_print boolean,
    printed boolean,
    composer_id integer NOT NULL,
    template_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    snailmail_is_letter boolean
);


ALTER TABLE public.account_invoice_send OWNER TO runbot;

--
-- Name: TABLE account_invoice_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_send IS 'Account Invoice Send';


--
-- Name: COLUMN account_invoice_send.is_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.is_email IS 'Email';


--
-- Name: COLUMN account_invoice_send.is_print; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.is_print IS 'Print';


--
-- Name: COLUMN account_invoice_send.printed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.printed IS 'Is Printed';


--
-- Name: COLUMN account_invoice_send.composer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.composer_id IS 'Composer';


--
-- Name: COLUMN account_invoice_send.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.template_id IS 'Use template';


--
-- Name: COLUMN account_invoice_send.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_send.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_send.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_send.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice_send.snailmail_is_letter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.snailmail_is_letter IS 'Send by Post';


--
-- Name: account_invoice_send_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_invoice_send_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_invoice_send_id_seq OWNER TO runbot;

--
-- Name: account_invoice_send_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_invoice_send_id_seq OWNED BY public.account_invoice_send.id;


--
-- Name: account_invoice_transaction_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_transaction_rel (
    invoice_id integer NOT NULL,
    transaction_id integer NOT NULL
);


ALTER TABLE public.account_invoice_transaction_rel OWNER TO runbot;

--
-- Name: TABLE account_invoice_transaction_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_transaction_rel IS 'RELATION BETWEEN account_move AND payment_transaction';


--
-- Name: account_journal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal (
    id integer NOT NULL,
    message_main_attachment_id integer,
    name character varying NOT NULL,
    code character varying(5) NOT NULL,
    active boolean,
    type character varying NOT NULL,
    default_account_id integer,
    suspense_account_id integer,
    restrict_mode_hash_table boolean,
    sequence integer,
    invoice_reference_type character varying NOT NULL,
    invoice_reference_model character varying NOT NULL,
    currency_id integer,
    company_id integer NOT NULL,
    refund_sequence boolean,
    sequence_override_regex text,
    profit_account_id integer,
    loss_account_id integer,
    bank_account_id integer,
    bank_statements_source character varying,
    sale_activity_type_id integer,
    sale_activity_user_id integer,
    sale_activity_note text,
    alias_id integer,
    secure_sequence_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    show_on_dashboard boolean,
    color integer,
    fiscalyear_lock_date date,
    period_lock_date date,
    sequence_id integer,
    refund_sequence_id integer,
    online_bank_statement_provider character varying,
    online_bank_statement_provider_id integer,
    check_manual_sequencing boolean,
    check_sequence_id integer
);


ALTER TABLE public.account_journal OWNER TO runbot;

--
-- Name: TABLE account_journal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal IS 'Journal';


--
-- Name: COLUMN account_journal.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_journal.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.name IS 'Journal Name';


--
-- Name: COLUMN account_journal.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.code IS 'Short Code';


--
-- Name: COLUMN account_journal.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.active IS 'Active';


--
-- Name: COLUMN account_journal.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.type IS 'Type';


--
-- Name: COLUMN account_journal.default_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.default_account_id IS 'Default Account';


--
-- Name: COLUMN account_journal.suspense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.suspense_account_id IS 'Suspense Account';


--
-- Name: COLUMN account_journal.restrict_mode_hash_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.restrict_mode_hash_table IS 'Lock Posted Entries with Hash';


--
-- Name: COLUMN account_journal.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal.invoice_reference_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.invoice_reference_type IS 'Communication Type';


--
-- Name: COLUMN account_journal.invoice_reference_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.invoice_reference_model IS 'Communication Standard';


--
-- Name: COLUMN account_journal.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.currency_id IS 'Currency';


--
-- Name: COLUMN account_journal.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.company_id IS 'Company';


--
-- Name: COLUMN account_journal.refund_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.refund_sequence IS 'Dedicated Credit Note Sequence';


--
-- Name: COLUMN account_journal.sequence_override_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sequence_override_regex IS 'Sequence Override Regex';


--
-- Name: COLUMN account_journal.profit_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_journal.loss_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_journal.bank_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN account_journal.bank_statements_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.bank_statements_source IS 'Bank Feeds';


--
-- Name: COLUMN account_journal.sale_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sale_activity_type_id IS 'Schedule Activity';


--
-- Name: COLUMN account_journal.sale_activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sale_activity_user_id IS 'Activity User';


--
-- Name: COLUMN account_journal.sale_activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sale_activity_note IS 'Activity Summary';


--
-- Name: COLUMN account_journal.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.alias_id IS 'Email Alias';


--
-- Name: COLUMN account_journal.secure_sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.secure_sequence_id IS 'Secure Sequence';


--
-- Name: COLUMN account_journal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_journal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_journal.show_on_dashboard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.show_on_dashboard IS 'Show journal on dashboard';


--
-- Name: COLUMN account_journal.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.color IS 'Color Index';


--
-- Name: COLUMN account_journal.fiscalyear_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.fiscalyear_lock_date IS 'Lock Date';


--
-- Name: COLUMN account_journal.period_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.period_lock_date IS 'Lock Date for Non-Advisers';


--
-- Name: COLUMN account_journal.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sequence_id IS 'Entry Sequence';


--
-- Name: COLUMN account_journal.refund_sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.refund_sequence_id IS 'Credit Note Entry Sequence';


--
-- Name: COLUMN account_journal.online_bank_statement_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.online_bank_statement_provider IS 'Online Bank Statement Provider';


--
-- Name: COLUMN account_journal.online_bank_statement_provider_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.online_bank_statement_provider_id IS 'Statement Provider';


--
-- Name: COLUMN account_journal.check_manual_sequencing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.check_manual_sequencing IS 'Manual Numbering';


--
-- Name: COLUMN account_journal.check_sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.check_sequence_id IS 'Check Sequence';


--
-- Name: account_journal_account_journal_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_journal_group_rel (
    account_journal_group_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_journal_group_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_journal_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_journal_group_rel IS 'RELATION BETWEEN account_journal_group AND account_journal';


--
-- Name: account_journal_account_print_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_print_journal_rel (
    account_print_journal_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_print_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_print_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_print_journal_rel IS 'RELATION BETWEEN account_print_journal AND account_journal';


--
-- Name: account_journal_account_reconcile_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_reconcile_model_rel (
    account_reconcile_model_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_reconcile_model_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_reconcile_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_reconcile_model_rel IS 'RELATION BETWEEN account_reconcile_model AND account_journal';


--
-- Name: account_journal_account_reconcile_model_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_reconcile_model_template_rel (
    account_reconcile_model_template_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_reconcile_model_template_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_reconcile_model_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_reconcile_model_template_rel IS 'RELATION BETWEEN account_reconcile_model_template AND account_journal';


--
-- Name: account_journal_general_ledger_report_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_general_ledger_report_wizard_rel (
    general_ledger_report_wizard_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_general_ledger_report_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_general_ledger_report_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_general_ledger_report_wizard_rel IS 'RELATION BETWEEN general_ledger_report_wizard AND account_journal';


--
-- Name: account_journal_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_group (
    id integer NOT NULL,
    name character varying NOT NULL,
    company_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_journal_group OWNER TO runbot;

--
-- Name: TABLE account_journal_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_group IS 'Account Journal Group';


--
-- Name: COLUMN account_journal_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.name IS 'Journal Group';


--
-- Name: COLUMN account_journal_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.company_id IS 'Company';


--
-- Name: COLUMN account_journal_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.write_date IS 'Last Updated on';


--
-- Name: account_journal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_group_id_seq OWNER TO runbot;

--
-- Name: account_journal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_group_id_seq OWNED BY public.account_journal_group.id;


--
-- Name: account_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_id_seq OWNER TO runbot;

--
-- Name: account_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_id_seq OWNED BY public.account_journal.id;


--
-- Name: account_journal_journal_ledger_report_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_journal_ledger_report_wizard_rel (
    journal_ledger_report_wizard_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_journal_ledger_report_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_journal_ledger_report_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_journal_ledger_report_wizard_rel IS 'RELATION BETWEEN journal_ledger_report_wizard AND account_journal';


--
-- Name: account_journal_trial_balance_report_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_trial_balance_report_wizard_rel (
    trial_balance_report_wizard_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_trial_balance_report_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_trial_balance_report_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_trial_balance_report_wizard_rel IS 'RELATION BETWEEN trial_balance_report_wizard AND account_journal';


--
-- Name: account_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move (
    id integer NOT NULL,
    sequence_prefix character varying,
    sequence_number integer,
    message_main_attachment_id integer,
    access_token character varying,
    name character varying,
    date date NOT NULL,
    ref character varying,
    narration text,
    state character varying NOT NULL,
    posted_before boolean,
    move_type character varying NOT NULL,
    to_check boolean,
    journal_id integer NOT NULL,
    company_id integer,
    currency_id integer NOT NULL,
    partner_id integer,
    commercial_partner_id integer,
    is_move_sent boolean,
    partner_bank_id integer,
    payment_reference character varying,
    payment_id integer,
    statement_line_id integer,
    amount_untaxed numeric,
    amount_tax numeric,
    amount_total numeric,
    amount_residual numeric,
    amount_untaxed_signed numeric,
    amount_tax_signed numeric,
    amount_total_signed numeric,
    amount_total_in_currency_signed numeric,
    amount_residual_signed numeric,
    payment_state character varying,
    tax_cash_basis_rec_id integer,
    tax_cash_basis_origin_move_id integer,
    always_tax_exigible boolean,
    auto_post boolean,
    reversed_entry_id integer,
    fiscal_position_id integer,
    invoice_user_id integer,
    invoice_date date,
    invoice_date_due date,
    invoice_origin character varying,
    invoice_payment_term_id integer,
    invoice_incoterm_id integer,
    qr_code_method character varying,
    invoice_source_email character varying,
    invoice_partner_display_name character varying,
    invoice_cash_rounding_id integer,
    secure_sequence_number integer,
    inalterable_hash character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    edi_state character varying,
    highest_name character varying,
    financial_type character varying,
    stock_move_id integer,
    intrastat_fiscal_position boolean,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    team_id integer,
    partner_shipping_id integer,
    printnode_printed boolean,
    preferred_payment_method_id integer,
    CONSTRAINT account_move_name_state_diagonal CHECK ((((COALESCE(name, ''::character varying))::text <> ALL ((ARRAY['/'::character varying, ''::character varying])::text[])) OR ((state)::text <> 'posted'::text)))
);


ALTER TABLE public.account_move OWNER TO runbot;

--
-- Name: TABLE account_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move IS 'Journal Entry';


--
-- Name: COLUMN account_move.sequence_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sequence_prefix IS 'Sequence Prefix';


--
-- Name: COLUMN account_move.sequence_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sequence_number IS 'Sequence Number';


--
-- Name: COLUMN account_move.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_move.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.access_token IS 'Security Token';


--
-- Name: COLUMN account_move.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.name IS 'Number';


--
-- Name: COLUMN account_move.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.date IS 'Date';


--
-- Name: COLUMN account_move.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.ref IS 'Reference';


--
-- Name: COLUMN account_move.narration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.narration IS 'Terms and Conditions';


--
-- Name: COLUMN account_move.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.state IS 'Status';


--
-- Name: COLUMN account_move.posted_before; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.posted_before IS 'Posted Before';


--
-- Name: COLUMN account_move.move_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.move_type IS 'Type';


--
-- Name: COLUMN account_move.to_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.to_check IS 'To Check';


--
-- Name: COLUMN account_move.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.journal_id IS 'Journal';


--
-- Name: COLUMN account_move.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.company_id IS 'Company';


--
-- Name: COLUMN account_move.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.currency_id IS 'Currency';


--
-- Name: COLUMN account_move.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_id IS 'Partner';


--
-- Name: COLUMN account_move.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN account_move.is_move_sent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_move_sent IS 'Is Move Sent';


--
-- Name: COLUMN account_move.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_bank_id IS 'Recipient Bank';


--
-- Name: COLUMN account_move.payment_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_move.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_id IS 'Payment';


--
-- Name: COLUMN account_move.statement_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.statement_line_id IS 'Statement Line';


--
-- Name: COLUMN account_move.amount_untaxed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed IS 'Untaxed Amount';


--
-- Name: COLUMN account_move.amount_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_tax IS 'Tax';


--
-- Name: COLUMN account_move.amount_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total IS 'Total';


--
-- Name: COLUMN account_move.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_residual IS 'Amount Due';


--
-- Name: COLUMN account_move.amount_untaxed_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed_signed IS 'Untaxed Amount Signed';


--
-- Name: COLUMN account_move.amount_tax_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_tax_signed IS 'Tax Signed';


--
-- Name: COLUMN account_move.amount_total_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total_signed IS 'Total Signed';


--
-- Name: COLUMN account_move.amount_total_in_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total_in_currency_signed IS 'Total in Currency Signed';


--
-- Name: COLUMN account_move.amount_residual_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_residual_signed IS 'Amount Due Signed';


--
-- Name: COLUMN account_move.payment_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_state IS 'Payment Status';


--
-- Name: COLUMN account_move.tax_cash_basis_rec_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_rec_id IS 'Tax Cash Basis Entry of';


--
-- Name: COLUMN account_move.tax_cash_basis_origin_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_origin_move_id IS 'Cash Basis Origin';


--
-- Name: COLUMN account_move.always_tax_exigible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.always_tax_exigible IS 'Always Tax Exigible';


--
-- Name: COLUMN account_move.auto_post; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post IS 'Post Automatically';


--
-- Name: COLUMN account_move.reversed_entry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.reversed_entry_id IS 'Reversal of';


--
-- Name: COLUMN account_move.fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_move.invoice_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_user_id IS 'Salesperson';


--
-- Name: COLUMN account_move.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move.invoice_date_due; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_date_due IS 'Due Date';


--
-- Name: COLUMN account_move.invoice_origin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_origin IS 'Origin';


--
-- Name: COLUMN account_move.invoice_payment_term_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_payment_term_id IS 'Payment Terms';


--
-- Name: COLUMN account_move.invoice_incoterm_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_incoterm_id IS 'Incoterm';


--
-- Name: COLUMN account_move.qr_code_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.qr_code_method IS 'Payment QR-code';


--
-- Name: COLUMN account_move.invoice_source_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_source_email IS 'Source Email';


--
-- Name: COLUMN account_move.invoice_partner_display_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_partner_display_name IS 'Invoice Partner Display Name';


--
-- Name: COLUMN account_move.invoice_cash_rounding_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_cash_rounding_id IS 'Cash Rounding Method';


--
-- Name: COLUMN account_move.secure_sequence_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.secure_sequence_number IS 'Inalteralbility No Gap Sequence #';


--
-- Name: COLUMN account_move.inalterable_hash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.inalterable_hash IS 'Inalterability Hash';


--
-- Name: COLUMN account_move.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.create_uid IS 'Created by';


--
-- Name: COLUMN account_move.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.create_date IS 'Created on';


--
-- Name: COLUMN account_move.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move.edi_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.edi_state IS 'Electronic invoicing';


--
-- Name: COLUMN account_move.highest_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.highest_name IS 'Highest Name';


--
-- Name: COLUMN account_move.stock_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.stock_move_id IS 'Stock Move';


--
-- Name: COLUMN account_move.intrastat_fiscal_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.intrastat_fiscal_position IS 'Intrastat Fiscal Position';


--
-- Name: COLUMN account_move.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.campaign_id IS 'Campaign';


--
-- Name: COLUMN account_move.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.source_id IS 'Source';


--
-- Name: COLUMN account_move.medium_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.medium_id IS 'Medium';


--
-- Name: COLUMN account_move.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.team_id IS 'Sales Team';


--
-- Name: COLUMN account_move.partner_shipping_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_shipping_id IS 'Delivery Address';


--
-- Name: COLUMN account_move.printnode_printed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.printnode_printed IS 'Printnode Printed';


--
-- Name: CONSTRAINT account_move_name_state_diagonal ON account_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_name_state_diagonal ON public.account_move IS 'CHECK(COALESCE(name, '''') NOT IN (''/'', '''') OR state!=''posted'')';


--
-- Name: account_move_account_invoice_send_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_account_invoice_send_rel (
    account_invoice_send_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_account_invoice_send_rel OWNER TO runbot;

--
-- Name: TABLE account_move_account_invoice_send_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_account_invoice_send_rel IS 'RELATION BETWEEN account_invoice_send AND account_move';


--
-- Name: account_move_account_resequence_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_account_resequence_wizard_rel (
    account_resequence_wizard_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_account_resequence_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_account_resequence_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_account_resequence_wizard_rel IS 'RELATION BETWEEN account_resequence_wizard AND account_move';


--
-- Name: account_move_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_id_seq OWNER TO runbot;

--
-- Name: account_move_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_id_seq OWNED BY public.account_move.id;


--
-- Name: account_move_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    move_name character varying,
    date date,
    ref character varying,
    parent_state character varying,
    journal_id integer,
    company_id integer,
    company_currency_id integer,
    account_id integer,
    account_root_id integer,
    sequence integer,
    name character varying,
    quantity numeric,
    price_unit numeric,
    discount numeric,
    debit numeric,
    credit numeric,
    balance numeric,
    amount_currency numeric,
    price_subtotal numeric,
    price_total numeric,
    reconciled boolean,
    blocked boolean,
    date_maturity date,
    currency_id integer NOT NULL,
    partner_id integer,
    product_uom_id integer,
    product_id integer,
    reconcile_model_id integer,
    payment_id integer,
    statement_line_id integer,
    statement_id integer,
    group_tax_id integer,
    tax_line_id integer,
    tax_group_id integer,
    tax_base_amount numeric,
    tax_repartition_line_id integer,
    tax_audit character varying,
    tax_tag_invert boolean,
    amount_residual numeric,
    amount_residual_currency numeric,
    full_reconcile_id integer,
    matching_number character varying,
    analytic_account_id integer,
    display_type character varying,
    is_rounding_line boolean,
    exclude_from_invoice_tab boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    purchase_line_id integer,
    is_anglo_saxon_line boolean,
    CONSTRAINT account_move_line_check_accountable_required_fields CHECK ((COALESCE(((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])), false) OR (account_id IS NOT NULL))),
    CONSTRAINT account_move_line_check_amount_currency_balance_sign CHECK ((((currency_id <> company_currency_id) AND ((((debit - credit) <= (0)::numeric) AND (amount_currency <= (0)::numeric)) OR (((debit - credit) >= (0)::numeric) AND (amount_currency >= (0)::numeric)))) OR ((currency_id = company_currency_id) AND (round(((debit - credit) - amount_currency), 2) = (0)::numeric)))),
    CONSTRAINT account_move_line_check_credit_debit CHECK ((((credit + debit) >= (0)::numeric) AND ((credit * debit) = (0)::numeric))),
    CONSTRAINT account_move_line_check_non_accountable_fields_null CHECK ((((display_type)::text <> ALL ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR ((amount_currency = (0)::numeric) AND (debit = (0)::numeric) AND (credit = (0)::numeric) AND (account_id IS NULL))))
);


ALTER TABLE public.account_move_line OWNER TO runbot;

--
-- Name: TABLE account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line IS 'Journal Item';


--
-- Name: COLUMN account_move_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_move_line.move_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.move_name IS 'Number';


--
-- Name: COLUMN account_move_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.date IS 'Date';


--
-- Name: COLUMN account_move_line.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.ref IS 'Reference';


--
-- Name: COLUMN account_move_line.parent_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.parent_state IS 'Status';


--
-- Name: COLUMN account_move_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.company_id IS 'Company';


--
-- Name: COLUMN account_move_line.company_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN account_move_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.account_id IS 'Account';


--
-- Name: COLUMN account_move_line.account_root_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.account_root_id IS 'Account Root';


--
-- Name: COLUMN account_move_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_move_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.name IS 'Label';


--
-- Name: COLUMN account_move_line.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.quantity IS 'Quantity';


--
-- Name: COLUMN account_move_line.price_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_unit IS 'Unit Price';


--
-- Name: COLUMN account_move_line.discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount IS 'Discount (%)';


--
-- Name: COLUMN account_move_line.debit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.debit IS 'Debit';


--
-- Name: COLUMN account_move_line.credit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.credit IS 'Credit';


--
-- Name: COLUMN account_move_line.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.balance IS 'Balance';


--
-- Name: COLUMN account_move_line.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_move_line.price_subtotal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_subtotal IS 'Subtotal';


--
-- Name: COLUMN account_move_line.price_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_total IS 'Total';


--
-- Name: COLUMN account_move_line.reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.reconciled IS 'Reconciled';


--
-- Name: COLUMN account_move_line.blocked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.blocked IS 'No Follow-up';


--
-- Name: COLUMN account_move_line.date_maturity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.date_maturity IS 'Due Date';


--
-- Name: COLUMN account_move_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_move_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_move_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_move_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.product_id IS 'Product';


--
-- Name: COLUMN account_move_line.reconcile_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.reconcile_model_id IS 'Reconciliation Model';


--
-- Name: COLUMN account_move_line.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.payment_id IS 'Originator Payment';


--
-- Name: COLUMN account_move_line.statement_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.statement_line_id IS 'Originator Statement Line';


--
-- Name: COLUMN account_move_line.statement_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_move_line.group_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.group_tax_id IS 'Originator Group of Taxes';


--
-- Name: COLUMN account_move_line.tax_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_line_id IS 'Originator Tax';


--
-- Name: COLUMN account_move_line.tax_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_group_id IS 'Originator tax group';


--
-- Name: COLUMN account_move_line.tax_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_base_amount IS 'Base Amount';


--
-- Name: COLUMN account_move_line.tax_repartition_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_repartition_line_id IS 'Originator Tax Distribution Line';


--
-- Name: COLUMN account_move_line.tax_audit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_audit IS 'Tax Audit String';


--
-- Name: COLUMN account_move_line.tax_tag_invert; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_tag_invert IS 'Invert Tags';


--
-- Name: COLUMN account_move_line.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_move_line.amount_residual_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_residual_currency IS 'Residual Amount in Currency';


--
-- Name: COLUMN account_move_line.full_reconcile_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.full_reconcile_id IS 'Matching';


--
-- Name: COLUMN account_move_line.matching_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.matching_number IS 'Matching #';


--
-- Name: COLUMN account_move_line.analytic_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.analytic_account_id IS 'Analytic Account';


--
-- Name: COLUMN account_move_line.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_move_line.is_rounding_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_rounding_line IS 'Is Rounding Line';


--
-- Name: COLUMN account_move_line.exclude_from_invoice_tab; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.exclude_from_invoice_tab IS 'Exclude From Invoice Tab';


--
-- Name: COLUMN account_move_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.create_date IS 'Created on';


--
-- Name: COLUMN account_move_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_line.purchase_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.purchase_line_id IS 'Purchase Order Line';


--
-- Name: COLUMN account_move_line.is_anglo_saxon_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_anglo_saxon_line IS 'Is Anglo Saxon Line';


--
-- Name: CONSTRAINT account_move_line_check_accountable_required_fields ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_accountable_required_fields ON public.account_move_line IS 'CHECK(COALESCE(display_type IN (''line_section'', ''line_note''), ''f'') OR account_id IS NOT NULL)';


--
-- Name: CONSTRAINT account_move_line_check_amount_currency_balance_sign ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_amount_currency_balance_sign ON public.account_move_line IS 'CHECK(
                (
                    (currency_id != company_currency_id)
                    AND
                    (
                        (debit - credit <= 0 AND amount_currency <= 0)
                        OR
                        (debit - credit >= 0 AND amount_currency >= 0)
                    )
                )
                OR
                (
                    currency_id = company_currency_id
                    AND
                    ROUND(debit - credit - amount_currency, 2) = 0
                )
            )';


--
-- Name: CONSTRAINT account_move_line_check_credit_debit ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_credit_debit ON public.account_move_line IS 'CHECK(credit + debit>=0 AND credit * debit=0)';


--
-- Name: CONSTRAINT account_move_line_check_non_accountable_fields_null ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_non_accountable_fields_null ON public.account_move_line IS 'CHECK(display_type NOT IN (''line_section'', ''line_note'') OR (amount_currency = 0 AND debit = 0 AND credit = 0 AND account_id IS NULL))';


--
-- Name: account_move_line_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_account_tax_rel (
    account_move_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_account_tax_rel IS 'RELATION BETWEEN account_move_line AND account_tax';


--
-- Name: account_move_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_line_id_seq OWNER TO runbot;

--
-- Name: account_move_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_line_id_seq OWNED BY public.account_move_line.id;


--
-- Name: account_move_purchase_order_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_purchase_order_rel (
    purchase_order_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_purchase_order_rel OWNER TO runbot;

--
-- Name: TABLE account_move_purchase_order_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_purchase_order_rel IS 'RELATION BETWEEN purchase_order AND account_move';


--
-- Name: account_move_reversal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal (
    id integer NOT NULL,
    date_mode character varying NOT NULL,
    date date,
    reason character varying,
    refund_method character varying NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_reversal OWNER TO runbot;

--
-- Name: TABLE account_move_reversal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal IS 'Account Move Reversal';


--
-- Name: COLUMN account_move_reversal.date_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.date_mode IS 'Date Mode';


--
-- Name: COLUMN account_move_reversal.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.date IS 'Reversal date';


--
-- Name: COLUMN account_move_reversal.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.reason IS 'Reason';


--
-- Name: COLUMN account_move_reversal.refund_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.refund_method IS 'Credit Method';


--
-- Name: COLUMN account_move_reversal.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.journal_id IS 'Use Specific Journal';


--
-- Name: COLUMN account_move_reversal.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.company_id IS 'Company';


--
-- Name: COLUMN account_move_reversal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_reversal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.create_date IS 'Created on';


--
-- Name: COLUMN account_move_reversal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_reversal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.write_date IS 'Last Updated on';


--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_reversal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_reversal_id_seq OWNER TO runbot;

--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_reversal_id_seq OWNED BY public.account_move_reversal.id;


--
-- Name: account_move_reversal_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal_move (
    reversal_id integer NOT NULL,
    move_id integer NOT NULL
);


ALTER TABLE public.account_move_reversal_move OWNER TO runbot;

--
-- Name: TABLE account_move_reversal_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_reversal_new_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal_new_move (
    reversal_id integer NOT NULL,
    new_move_id integer NOT NULL
);


ALTER TABLE public.account_move_reversal_new_move OWNER TO runbot;

--
-- Name: TABLE account_move_reversal_new_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal_new_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_partial_reconcile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_partial_reconcile (
    id integer NOT NULL,
    debit_move_id integer NOT NULL,
    credit_move_id integer NOT NULL,
    full_reconcile_id integer,
    debit_currency_id integer,
    credit_currency_id integer,
    amount numeric,
    debit_amount_currency numeric,
    credit_amount_currency numeric,
    company_id integer,
    max_date date,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_partial_reconcile OWNER TO runbot;

--
-- Name: TABLE account_partial_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_partial_reconcile IS 'Partial Reconcile';


--
-- Name: COLUMN account_partial_reconcile.debit_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_move_id IS 'Debit Move';


--
-- Name: COLUMN account_partial_reconcile.credit_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_move_id IS 'Credit Move';


--
-- Name: COLUMN account_partial_reconcile.full_reconcile_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.full_reconcile_id IS 'Full Reconcile';


--
-- Name: COLUMN account_partial_reconcile.debit_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_currency_id IS 'Currency of the debit journal item.';


--
-- Name: COLUMN account_partial_reconcile.credit_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_currency_id IS 'Currency of the credit journal item.';


--
-- Name: COLUMN account_partial_reconcile.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.amount IS 'Amount';


--
-- Name: COLUMN account_partial_reconcile.debit_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_amount_currency IS 'Debit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.credit_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_amount_currency IS 'Credit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.company_id IS 'Company';


--
-- Name: COLUMN account_partial_reconcile.max_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.max_date IS 'Max Date of Matched Lines';


--
-- Name: COLUMN account_partial_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_partial_reconcile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_partial_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_partial_reconcile.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_partial_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNER TO runbot;

--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNED BY public.account_partial_reconcile.id;


--
-- Name: account_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment (
    id integer NOT NULL,
    message_main_attachment_id integer,
    move_id integer NOT NULL,
    is_reconciled boolean,
    is_matched boolean,
    partner_bank_id integer,
    is_internal_transfer boolean,
    paired_internal_transfer_payment_id integer,
    payment_method_line_id integer,
    payment_method_id integer,
    amount numeric,
    payment_type character varying NOT NULL,
    partner_type character varying NOT NULL,
    payment_reference character varying,
    currency_id integer,
    partner_id integer,
    outstanding_account_id integer,
    destination_account_id integer,
    destination_journal_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    payment_transaction_id integer,
    payment_token_id integer,
    source_payment_id integer,
    check_number character varying,
    check_amount_in_words character varying,
    CONSTRAINT account_payment_check_amount_not_negative CHECK ((amount >= 0.0))
);


ALTER TABLE public.account_payment OWNER TO runbot;

--
-- Name: TABLE account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment IS 'Payments';


--
-- Name: COLUMN account_payment.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_payment.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_payment.is_reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_payment.is_matched; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_matched IS 'Is Matched With a Bank Statement';


--
-- Name: COLUMN account_payment.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment.is_internal_transfer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_internal_transfer IS 'Internal Transfer';


--
-- Name: COLUMN account_payment.paired_internal_transfer_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.paired_internal_transfer_payment_id IS 'Paired Internal Transfer Payment';


--
-- Name: COLUMN account_payment.payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_method_id IS 'Method';


--
-- Name: COLUMN account_payment.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.amount IS 'Amount';


--
-- Name: COLUMN account_payment.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment.payment_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_payment.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment.outstanding_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.outstanding_account_id IS 'Outstanding Account';


--
-- Name: COLUMN account_payment.destination_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.destination_account_id IS 'Destination Account';


--
-- Name: COLUMN account_payment.destination_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.destination_journal_id IS 'Destination Journal';


--
-- Name: COLUMN account_payment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.create_date IS 'Created on';


--
-- Name: COLUMN account_payment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment.payment_transaction_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_transaction_id IS 'Payment Transaction';


--
-- Name: COLUMN account_payment.payment_token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_token_id IS 'Saved Payment Token';


--
-- Name: COLUMN account_payment.source_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.source_payment_id IS 'Source Payment';


--
-- Name: COLUMN account_payment.check_amount_in_words; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.check_amount_in_words IS 'Amount in Words';


--
-- Name: CONSTRAINT account_payment_check_amount_not_negative ON account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_payment_check_amount_not_negative ON public.account_payment IS 'CHECK(amount >= 0.0)';


--
-- Name: account_payment_account_bank_statement_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_account_bank_statement_line_rel (
    account_bank_statement_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_payment_account_bank_statement_line_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_account_bank_statement_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_account_bank_statement_line_rel IS 'RELATION BETWEEN account_bank_statement_line AND account_payment';


--
-- Name: account_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_id_seq OWNER TO runbot;

--
-- Name: account_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_id_seq OWNED BY public.account_payment.id;


--
-- Name: account_payment_method; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_method (
    id integer NOT NULL,
    name character varying NOT NULL,
    code character varying NOT NULL,
    payment_type character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_method OWNER TO runbot;

--
-- Name: TABLE account_payment_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_method IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.name IS 'Name';


--
-- Name: COLUMN account_payment_method.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.code IS 'Code';


--
-- Name: COLUMN account_payment_method.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_method.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.write_date IS 'Last Updated on';


--
-- Name: account_payment_method_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_method_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_method_id_seq OWNER TO runbot;

--
-- Name: account_payment_method_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_method_id_seq OWNED BY public.account_payment_method.id;


--
-- Name: account_payment_method_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_method_line (
    id integer NOT NULL,
    name character varying,
    sequence integer,
    payment_method_id integer NOT NULL,
    payment_account_id integer,
    journal_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    payment_acquirer_id integer
);


ALTER TABLE public.account_payment_method_line OWNER TO runbot;

--
-- Name: TABLE account_payment_method_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_method_line IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.name IS 'Name';


--
-- Name: COLUMN account_payment_method_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_method_line.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_method_line.payment_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_account_id IS 'Payment Account';


--
-- Name: COLUMN account_payment_method_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_method_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_method_line.payment_acquirer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_acquirer_id IS 'Payment Acquirer';


--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_method_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_method_line_id_seq OWNER TO runbot;

--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_method_line_id_seq OWNED BY public.account_payment_method_line.id;


--
-- Name: account_payment_register; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register (
    id integer NOT NULL,
    payment_date date NOT NULL,
    amount numeric,
    communication character varying,
    group_payment boolean,
    currency_id integer,
    journal_id integer,
    partner_bank_id integer,
    payment_type character varying,
    partner_type character varying,
    source_amount numeric,
    source_amount_currency numeric,
    source_currency_id integer,
    can_edit_wizard boolean,
    can_group_payments boolean,
    company_id integer,
    partner_id integer,
    payment_method_line_id integer,
    payment_difference_handling character varying,
    writeoff_account_id integer,
    writeoff_label character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    payment_token_id integer
);


ALTER TABLE public.account_payment_register OWNER TO runbot;

--
-- Name: TABLE account_payment_register; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register IS 'Register Payment';


--
-- Name: COLUMN account_payment_register.payment_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_date IS 'Payment Date';


--
-- Name: COLUMN account_payment_register.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.amount IS 'Amount';


--
-- Name: COLUMN account_payment_register.communication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.communication IS 'Memo';


--
-- Name: COLUMN account_payment_register.group_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.group_payment IS 'Group Payments';


--
-- Name: COLUMN account_payment_register.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment_register.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_register.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment_register.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_register.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment_register.source_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_amount IS 'Amount to Pay (company currency)';


--
-- Name: COLUMN account_payment_register.source_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_amount_currency IS 'Amount to Pay (foreign currency)';


--
-- Name: COLUMN account_payment_register.source_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_currency_id IS 'Source Currency';


--
-- Name: COLUMN account_payment_register.can_edit_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.can_edit_wizard IS 'Can Edit Wizard';


--
-- Name: COLUMN account_payment_register.can_group_payments; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.can_group_payments IS 'Can Group Payments';


--
-- Name: COLUMN account_payment_register.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.company_id IS 'Company';


--
-- Name: COLUMN account_payment_register.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment_register.payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_register.payment_difference_handling; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_difference_handling IS 'Payment Difference Handling';


--
-- Name: COLUMN account_payment_register.writeoff_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.writeoff_account_id IS 'Difference Account';


--
-- Name: COLUMN account_payment_register.writeoff_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.writeoff_label IS 'Journal Item Label';


--
-- Name: COLUMN account_payment_register.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_register.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_register.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_register.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_register.payment_token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_token_id IS 'Saved payment token';


--
-- Name: account_payment_register_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_register_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_register_id_seq OWNER TO runbot;

--
-- Name: account_payment_register_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_register_id_seq OWNED BY public.account_payment_register.id;


--
-- Name: account_payment_register_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register_move_line_rel (
    wizard_id integer NOT NULL,
    line_id integer NOT NULL
);


ALTER TABLE public.account_payment_register_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_register_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register_move_line_rel IS 'RELATION BETWEEN account_payment_register AND account_move_line';


--
-- Name: account_payment_term; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term (
    id integer NOT NULL,
    name character varying NOT NULL,
    active boolean,
    note text,
    company_id integer,
    sequence integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_term OWNER TO runbot;

--
-- Name: TABLE account_payment_term; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.name IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.active IS 'Active';


--
-- Name: COLUMN account_payment_term.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.note IS 'Description on the Invoice';


--
-- Name: COLUMN account_payment_term.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.company_id IS 'Company';


--
-- Name: COLUMN account_payment_term.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_term.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.write_date IS 'Last Updated on';


--
-- Name: account_payment_term_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_term_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_id_seq OWNER TO runbot;

--
-- Name: account_payment_term_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_term_id_seq OWNED BY public.account_payment_term.id;


--
-- Name: account_payment_term_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term_line (
    id integer NOT NULL,
    value character varying NOT NULL,
    value_amount numeric,
    days integer NOT NULL,
    day_of_the_month integer,
    option character varying NOT NULL,
    payment_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_term_line OWNER TO runbot;

--
-- Name: TABLE account_payment_term_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term_line IS 'Payment Terms Line';


--
-- Name: COLUMN account_payment_term_line.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.value IS 'Type';


--
-- Name: COLUMN account_payment_term_line.value_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.value_amount IS 'Value';


--
-- Name: COLUMN account_payment_term_line.days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.days IS 'Number of Days';


--
-- Name: COLUMN account_payment_term_line.day_of_the_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.day_of_the_month IS 'Day of the month';


--
-- Name: COLUMN account_payment_term_line.option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.option IS 'Options';


--
-- Name: COLUMN account_payment_term_line.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.payment_id IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_term_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.write_date IS 'Last Updated on';


--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_term_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_line_id_seq OWNER TO runbot;

--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_term_line_id_seq OWNED BY public.account_payment_term_line.id;


--
-- Name: account_print_journal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_print_journal (
    id integer NOT NULL,
    company_id integer NOT NULL,
    date_from date,
    date_to date,
    target_move character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    amount_currency boolean,
    sort_selection character varying NOT NULL
);


ALTER TABLE public.account_print_journal OWNER TO runbot;

--
-- Name: TABLE account_print_journal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_print_journal IS 'Account Print Journal';


--
-- Name: COLUMN account_print_journal.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_print_journal.company_id IS 'Company';


--
-- Name: COLUMN account_print_journal.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_print_journal.date_from IS 'Start Date';


--
-- Name: COLUMN account_print_journal.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_print_journal.date_to IS 'End Date';


--
-- Name: COLUMN account_print_journal.target_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_print_journal.target_move IS 'Target Moves';


--
-- Name: COLUMN account_print_journal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_print_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_print_journal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_print_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_print_journal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_print_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_print_journal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_print_journal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_print_journal.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_print_journal.amount_currency IS 'With Currency';


--
-- Name: COLUMN account_print_journal.sort_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_print_journal.sort_selection IS 'Entries Sorted by';


--
-- Name: account_print_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_print_journal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_print_journal_id_seq OWNER TO runbot;

--
-- Name: account_print_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_print_journal_id_seq OWNED BY public.account_print_journal.id;


--
-- Name: account_reconcile_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model (
    id integer NOT NULL,
    message_main_attachment_id integer,
    active boolean,
    name character varying NOT NULL,
    sequence integer NOT NULL,
    company_id integer NOT NULL,
    rule_type character varying NOT NULL,
    auto_reconcile boolean,
    to_check boolean,
    matching_order character varying NOT NULL,
    match_text_location_label boolean,
    match_text_location_note boolean,
    match_text_location_reference boolean,
    match_nature character varying NOT NULL,
    match_amount character varying,
    match_amount_min double precision,
    match_amount_max double precision,
    match_label character varying,
    match_label_param character varying,
    match_note character varying,
    match_note_param character varying,
    match_transaction_type character varying,
    match_transaction_type_param character varying,
    match_same_currency boolean,
    allow_payment_tolerance boolean,
    payment_tolerance_param double precision,
    payment_tolerance_type character varying NOT NULL,
    match_partner boolean,
    past_months_limit integer,
    decimal_separator character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reconcile_model OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model IS 'Preset to create journal entries during a invoices and payments matching';


--
-- Name: COLUMN account_reconcile_model.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_reconcile_model.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.active IS 'Active';


--
-- Name: COLUMN account_reconcile_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.name IS 'Name';


--
-- Name: COLUMN account_reconcile_model.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model.rule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.rule_type IS 'Type';


--
-- Name: COLUMN account_reconcile_model.auto_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.auto_reconcile IS 'Auto-validate';


--
-- Name: COLUMN account_reconcile_model.to_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_model.matching_order; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.matching_order IS 'Matching Order';


--
-- Name: COLUMN account_reconcile_model.match_text_location_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_label IS 'Match Text Location Label';


--
-- Name: COLUMN account_reconcile_model.match_text_location_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_note IS 'Match Text Location Note';


--
-- Name: COLUMN account_reconcile_model.match_text_location_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_reference IS 'Match Text Location Reference';


--
-- Name: COLUMN account_reconcile_model.match_nature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_nature IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model.match_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount IS 'Amount Condition';


--
-- Name: COLUMN account_reconcile_model.match_amount_min; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_min IS 'Amount Min Parameter';


--
-- Name: COLUMN account_reconcile_model.match_amount_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_max IS 'Amount Max Parameter';


--
-- Name: COLUMN account_reconcile_model.match_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_label IS 'Label';


--
-- Name: COLUMN account_reconcile_model.match_label_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_label_param IS 'Label Parameter';


--
-- Name: COLUMN account_reconcile_model.match_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_note IS 'Note';


--
-- Name: COLUMN account_reconcile_model.match_note_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_note_param IS 'Note Parameter';


--
-- Name: COLUMN account_reconcile_model.match_transaction_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_reconcile_model.match_transaction_type_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_transaction_type_param IS 'Transaction Type Parameter';


--
-- Name: COLUMN account_reconcile_model.match_same_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_same_currency IS 'Same Currency';


--
-- Name: COLUMN account_reconcile_model.allow_payment_tolerance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.allow_payment_tolerance IS 'Payment Tolerance';


--
-- Name: COLUMN account_reconcile_model.payment_tolerance_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.payment_tolerance_param IS 'Gap';


--
-- Name: COLUMN account_reconcile_model.payment_tolerance_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.payment_tolerance_type IS 'Payment Tolerance Type';


--
-- Name: COLUMN account_reconcile_model.match_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_partner IS 'Partner should be set';


--
-- Name: COLUMN account_reconcile_model.past_months_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.past_months_limit IS 'Search Months Limit';


--
-- Name: COLUMN account_reconcile_model.decimal_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.decimal_separator IS 'Decimal Separator';


--
-- Name: COLUMN account_reconcile_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_model_analytic_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_analytic_tag_rel (
    account_reconcile_model_line_id integer NOT NULL,
    account_analytic_tag_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_analytic_tag_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_analytic_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_analytic_tag_rel IS 'RELATION BETWEEN account_reconcile_model_line AND account_analytic_tag';


--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_id_seq OWNED BY public.account_reconcile_model.id;


--
-- Name: account_reconcile_model_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line (
    id integer NOT NULL,
    model_id integer,
    company_id integer,
    sequence integer NOT NULL,
    account_id integer NOT NULL,
    journal_id integer,
    label character varying,
    amount_type character varying NOT NULL,
    force_tax_included boolean,
    amount double precision,
    amount_string character varying NOT NULL,
    analytic_account_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reconcile_model_line OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line IS 'Rules for the reconciliation model';


--
-- Name: COLUMN account_reconcile_model_line.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_model_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_reconcile_model_line.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.label IS 'Journal Item Label';


--
-- Name: COLUMN account_reconcile_model_line.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_type IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model_line.force_tax_included; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.force_tax_included IS 'Tax Included in Price';


--
-- Name: COLUMN account_reconcile_model_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount IS 'Float Amount';


--
-- Name: COLUMN account_reconcile_model_line.amount_string; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_string IS 'Amount';


--
-- Name: COLUMN account_reconcile_model_line.analytic_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.analytic_account_id IS 'Analytic Account';


--
-- Name: COLUMN account_reconcile_model_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_model_line_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line_account_tax_rel (
    account_reconcile_model_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_line_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line_account_tax_rel IS 'RELATION BETWEEN account_reconcile_model_line AND account_tax';


--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNED BY public.account_reconcile_model_line.id;


--
-- Name: account_reconcile_model_line_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line_template (
    id integer NOT NULL,
    model_id integer,
    sequence integer NOT NULL,
    account_id integer,
    label character varying,
    amount_type character varying NOT NULL,
    amount_string character varying,
    force_tax_included boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reconcile_model_line_template OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line_template IS 'Reconcile Model Line Template';


--
-- Name: COLUMN account_reconcile_model_line_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_line_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model_line_template.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_model_line_template.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.label IS 'Journal Item Label';


--
-- Name: COLUMN account_reconcile_model_line_template.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.amount_type IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model_line_template.amount_string; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.amount_string IS 'Amount';


--
-- Name: COLUMN account_reconcile_model_line_template.force_tax_included; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.force_tax_included IS 'Tax Included in Price';


--
-- Name: COLUMN account_reconcile_model_line_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_line_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_line_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_line_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_model_line_template_account_tax_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line_template_account_tax_template_rel (
    account_reconcile_model_line_template_id integer NOT NULL,
    account_tax_template_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_line_template_account_tax_template_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line_template_account_tax_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line_template_account_tax_template_rel IS 'RELATION BETWEEN account_reconcile_model_line_template AND account_tax_template';


--
-- Name: account_reconcile_model_line_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_line_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_line_template_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_line_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_line_template_id_seq OWNED BY public.account_reconcile_model_line_template.id;


--
-- Name: account_reconcile_model_partner_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_partner_mapping (
    id integer NOT NULL,
    model_id integer NOT NULL,
    partner_id integer NOT NULL,
    payment_ref_regex character varying,
    narration_regex character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reconcile_model_partner_mapping OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_partner_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_partner_mapping IS 'Partner mapping for reconciliation models';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.partner_id IS 'Partner';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.payment_ref_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.payment_ref_regex IS 'Find Text in Label';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.narration_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.narration_regex IS 'Find Text in Notes';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_model_partner_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_partner_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_partner_mapping_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_partner_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_partner_mapping_id_seq OWNED BY public.account_reconcile_model_partner_mapping.id;


--
-- Name: account_reconcile_model_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_res_partner_category_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_category_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_category_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner_category';


--
-- Name: account_reconcile_model_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_res_partner_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner';


--
-- Name: account_reconcile_model_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_template (
    id integer NOT NULL,
    chart_template_id integer NOT NULL,
    name character varying NOT NULL,
    sequence integer NOT NULL,
    rule_type character varying NOT NULL,
    auto_reconcile boolean,
    to_check boolean,
    matching_order character varying,
    match_text_location_label boolean,
    match_text_location_note boolean,
    match_text_location_reference boolean,
    match_nature character varying NOT NULL,
    match_amount character varying,
    match_amount_min double precision,
    match_amount_max double precision,
    match_label character varying,
    match_label_param character varying,
    match_note character varying,
    match_note_param character varying,
    match_transaction_type character varying,
    match_transaction_type_param character varying,
    match_same_currency boolean,
    allow_payment_tolerance boolean,
    payment_tolerance_param double precision,
    payment_tolerance_type character varying NOT NULL,
    match_partner boolean,
    decimal_separator character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reconcile_model_template OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_template IS 'Reconcile Model Template';


--
-- Name: COLUMN account_reconcile_model_template.chart_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_reconcile_model_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.name IS 'Button Label';


--
-- Name: COLUMN account_reconcile_model_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model_template.rule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.rule_type IS 'Type';


--
-- Name: COLUMN account_reconcile_model_template.auto_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.auto_reconcile IS 'Auto-validate';


--
-- Name: COLUMN account_reconcile_model_template.to_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_model_template.matching_order; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.matching_order IS 'Matching Order';


--
-- Name: COLUMN account_reconcile_model_template.match_text_location_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_text_location_label IS 'Match Text Location Label';


--
-- Name: COLUMN account_reconcile_model_template.match_text_location_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_text_location_note IS 'Match Text Location Note';


--
-- Name: COLUMN account_reconcile_model_template.match_text_location_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_text_location_reference IS 'Match Text Location Reference';


--
-- Name: COLUMN account_reconcile_model_template.match_nature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_nature IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model_template.match_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_amount IS 'Amount Condition';


--
-- Name: COLUMN account_reconcile_model_template.match_amount_min; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_amount_min IS 'Amount Min Parameter';


--
-- Name: COLUMN account_reconcile_model_template.match_amount_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_amount_max IS 'Amount Max Parameter';


--
-- Name: COLUMN account_reconcile_model_template.match_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_label IS 'Label';


--
-- Name: COLUMN account_reconcile_model_template.match_label_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_label_param IS 'Label Parameter';


--
-- Name: COLUMN account_reconcile_model_template.match_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_note IS 'Note';


--
-- Name: COLUMN account_reconcile_model_template.match_note_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_note_param IS 'Note Parameter';


--
-- Name: COLUMN account_reconcile_model_template.match_transaction_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_reconcile_model_template.match_transaction_type_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_transaction_type_param IS 'Transaction Type Parameter';


--
-- Name: COLUMN account_reconcile_model_template.match_same_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_same_currency IS 'Same Currency';


--
-- Name: COLUMN account_reconcile_model_template.allow_payment_tolerance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.allow_payment_tolerance IS 'Allow Payment Gap';


--
-- Name: COLUMN account_reconcile_model_template.payment_tolerance_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.payment_tolerance_param IS 'Gap';


--
-- Name: COLUMN account_reconcile_model_template.payment_tolerance_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.payment_tolerance_type IS 'Payment Tolerance Type';


--
-- Name: COLUMN account_reconcile_model_template.match_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_partner IS 'Partner Is Set';


--
-- Name: COLUMN account_reconcile_model_template.decimal_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.decimal_separator IS 'Decimal Separator';


--
-- Name: COLUMN account_reconcile_model_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_model_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_template_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_template_id_seq OWNED BY public.account_reconcile_model_template.id;


--
-- Name: account_reconcile_model_template_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_template_res_partner_category_rel (
    account_reconcile_model_template_id integer NOT NULL,
    res_partner_category_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_template_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_template_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_template_res_partner_category_rel IS 'RELATION BETWEEN account_reconcile_model_template AND res_partner_category';


--
-- Name: account_reconcile_model_template_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_template_res_partner_rel (
    account_reconcile_model_template_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_template_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_template_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_template_res_partner_rel IS 'RELATION BETWEEN account_reconcile_model_template AND res_partner';


--
-- Name: account_resequence_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_resequence_wizard (
    id integer NOT NULL,
    first_date date,
    end_date date,
    first_name character varying NOT NULL,
    ordering character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_resequence_wizard OWNER TO runbot;

--
-- Name: TABLE account_resequence_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_resequence_wizard IS 'Remake the sequence of Journal Entries.';


--
-- Name: COLUMN account_resequence_wizard.first_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.first_date IS 'First Date';


--
-- Name: COLUMN account_resequence_wizard.end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.end_date IS 'End Date';


--
-- Name: COLUMN account_resequence_wizard.first_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.first_name IS 'First New Sequence';


--
-- Name: COLUMN account_resequence_wizard.ordering; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.ordering IS 'Ordering';


--
-- Name: COLUMN account_resequence_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_resequence_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_resequence_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_resequence_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.write_date IS 'Last Updated on';


--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_resequence_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNER TO runbot;

--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNED BY public.account_resequence_wizard.id;


--
-- Name: account_root; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.account_root AS
 SELECT DISTINCT ((ascii((account_account.code)::text) * 1000) + ascii("substring"((account_account.code)::text, 2, 1))) AS id,
    "left"((account_account.code)::text, 2) AS name,
    ascii((account_account.code)::text) AS parent_id,
    account_account.company_id
   FROM public.account_account
  WHERE (account_account.code IS NOT NULL)
UNION ALL
 SELECT DISTINCT ascii((account_account.code)::text) AS id,
    "left"((account_account.code)::text, 1) AS name,
    NULL::integer AS parent_id,
    account_account.company_id
   FROM public.account_account
  WHERE (account_account.code IS NOT NULL);


ALTER VIEW public.account_root OWNER TO runbot;

--
-- Name: account_setup_bank_manual_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_setup_bank_manual_config (
    id integer NOT NULL,
    res_partner_bank_id integer NOT NULL,
    new_journal_name character varying NOT NULL,
    num_journals_without_account integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_setup_bank_manual_config OWNER TO runbot;

--
-- Name: TABLE account_setup_bank_manual_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_setup_bank_manual_config IS 'Bank setup manual config';


--
-- Name: COLUMN account_setup_bank_manual_config.res_partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.res_partner_bank_id IS 'Res Partner Bank';


--
-- Name: COLUMN account_setup_bank_manual_config.new_journal_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.new_journal_name IS 'New Journal Name';


--
-- Name: COLUMN account_setup_bank_manual_config.num_journals_without_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.num_journals_without_account IS 'Num Journals Without Account';


--
-- Name: COLUMN account_setup_bank_manual_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_uid IS 'Created by';


--
-- Name: COLUMN account_setup_bank_manual_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_date IS 'Created on';


--
-- Name: COLUMN account_setup_bank_manual_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_setup_bank_manual_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_date IS 'Last Updated on';


--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_setup_bank_manual_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNER TO runbot;

--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNED BY public.account_setup_bank_manual_config.id;


--
-- Name: account_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax (
    id integer NOT NULL,
    name character varying NOT NULL,
    type_tax_use character varying NOT NULL,
    tax_scope character varying,
    amount_type character varying NOT NULL,
    active boolean,
    company_id integer NOT NULL,
    sequence integer NOT NULL,
    amount numeric NOT NULL,
    description character varying,
    price_include boolean,
    include_base_amount boolean,
    is_base_affected boolean,
    analytic boolean,
    tax_group_id integer NOT NULL,
    tax_exigibility character varying,
    cash_basis_transition_account_id integer,
    country_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax OWNER TO runbot;

--
-- Name: TABLE account_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax IS 'Tax';


--
-- Name: COLUMN account_tax.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.name IS 'Tax Name';


--
-- Name: COLUMN account_tax.type_tax_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.type_tax_use IS 'Tax Type';


--
-- Name: COLUMN account_tax.tax_scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_scope IS 'Tax Scope';


--
-- Name: COLUMN account_tax.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.amount_type IS 'Tax Computation';


--
-- Name: COLUMN account_tax.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.active IS 'Active';


--
-- Name: COLUMN account_tax.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.company_id IS 'Company';


--
-- Name: COLUMN account_tax.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.amount IS 'Amount';


--
-- Name: COLUMN account_tax.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.description IS 'Label on Invoices';


--
-- Name: COLUMN account_tax.price_include; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.price_include IS 'Included in Price';


--
-- Name: COLUMN account_tax.include_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.include_base_amount IS 'Affect Base of Subsequent Taxes';


--
-- Name: COLUMN account_tax.is_base_affected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.is_base_affected IS 'Base Affected by Previous Taxes';


--
-- Name: COLUMN account_tax.analytic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.analytic IS 'Include in Analytic Cost';


--
-- Name: COLUMN account_tax.tax_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_group_id IS 'Tax Group';


--
-- Name: COLUMN account_tax.tax_exigibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_exigibility IS 'Tax Exigibility';


--
-- Name: COLUMN account_tax.cash_basis_transition_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.cash_basis_transition_account_id IS 'Cash Basis Transition Account';


--
-- Name: COLUMN account_tax.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.country_id IS 'Country';


--
-- Name: COLUMN account_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.write_date IS 'Last Updated on';


--
-- Name: account_tax_carryover_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_carryover_line (
    id integer NOT NULL,
    name character varying NOT NULL,
    amount double precision NOT NULL,
    date date NOT NULL,
    tax_report_line_id integer,
    company_id integer NOT NULL,
    foreign_vat_fiscal_position_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_carryover_line OWNER TO runbot;

--
-- Name: TABLE account_tax_carryover_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_carryover_line IS 'Tax carryover line';


--
-- Name: COLUMN account_tax_carryover_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_carryover_line.name IS 'Name';


--
-- Name: COLUMN account_tax_carryover_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_carryover_line.amount IS 'Amount';


--
-- Name: COLUMN account_tax_carryover_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_carryover_line.date IS 'Date';


--
-- Name: COLUMN account_tax_carryover_line.tax_report_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_carryover_line.tax_report_line_id IS 'Tax report line';


--
-- Name: COLUMN account_tax_carryover_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_carryover_line.company_id IS 'Company';


--
-- Name: COLUMN account_tax_carryover_line.foreign_vat_fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_carryover_line.foreign_vat_fiscal_position_id IS 'Fiscal position';


--
-- Name: COLUMN account_tax_carryover_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_carryover_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_carryover_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_carryover_line.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_carryover_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_carryover_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_carryover_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_carryover_line.write_date IS 'Last Updated on';


--
-- Name: account_tax_carryover_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_carryover_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_carryover_line_id_seq OWNER TO runbot;

--
-- Name: account_tax_carryover_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_carryover_line_id_seq OWNED BY public.account_tax_carryover_line.id;


--
-- Name: account_tax_filiation_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_filiation_rel (
    parent_tax integer NOT NULL,
    child_tax integer NOT NULL
);


ALTER TABLE public.account_tax_filiation_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_filiation_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_filiation_rel IS 'RELATION BETWEEN account_tax AND account_tax';


--
-- Name: account_tax_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_group (
    id integer NOT NULL,
    name character varying NOT NULL,
    sequence integer,
    country_id integer,
    preceding_subtotal character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_group OWNER TO runbot;

--
-- Name: TABLE account_tax_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_group IS 'Tax Group';


--
-- Name: COLUMN account_tax_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.name IS 'Name';


--
-- Name: COLUMN account_tax_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_group.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.country_id IS 'Country';


--
-- Name: COLUMN account_tax_group.preceding_subtotal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.preceding_subtotal IS 'Preceding Subtotal';


--
-- Name: COLUMN account_tax_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.write_date IS 'Last Updated on';


--
-- Name: account_tax_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_group_id_seq OWNER TO runbot;

--
-- Name: account_tax_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_group_id_seq OWNED BY public.account_tax_group.id;


--
-- Name: account_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_id_seq OWNER TO runbot;

--
-- Name: account_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_id_seq OWNED BY public.account_tax.id;


--
-- Name: account_tax_purchase_order_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_purchase_order_line_rel (
    purchase_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_purchase_order_line_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_purchase_order_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_purchase_order_line_rel IS 'RELATION BETWEEN purchase_order_line AND account_tax';


--
-- Name: account_tax_repartition_financial_tags; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_repartition_financial_tags (
    account_tax_repartition_line_template_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_tax_repartition_financial_tags OWNER TO runbot;

--
-- Name: TABLE account_tax_repartition_financial_tags; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_repartition_financial_tags IS 'RELATION BETWEEN account_tax_repartition_line_template AND account_account_tag';


--
-- Name: account_tax_repartition_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_repartition_line (
    id integer NOT NULL,
    factor_percent double precision NOT NULL,
    repartition_type character varying NOT NULL,
    account_id integer,
    invoice_tax_id integer,
    refund_tax_id integer,
    company_id integer,
    sequence integer,
    use_in_tax_closing boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_repartition_line OWNER TO runbot;

--
-- Name: TABLE account_tax_repartition_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_repartition_line IS 'Tax Repartition Line';


--
-- Name: COLUMN account_tax_repartition_line.factor_percent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.factor_percent IS '%';


--
-- Name: COLUMN account_tax_repartition_line.repartition_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.repartition_type IS 'Based On';


--
-- Name: COLUMN account_tax_repartition_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.account_id IS 'Account';


--
-- Name: COLUMN account_tax_repartition_line.invoice_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.invoice_tax_id IS 'Invoice Tax';


--
-- Name: COLUMN account_tax_repartition_line.refund_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.refund_tax_id IS 'Refund Tax';


--
-- Name: COLUMN account_tax_repartition_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.company_id IS 'Company';


--
-- Name: COLUMN account_tax_repartition_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_repartition_line.use_in_tax_closing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.use_in_tax_closing IS 'Tax Closing Entry';


--
-- Name: COLUMN account_tax_repartition_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_repartition_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_repartition_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_repartition_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_date IS 'Last Updated on';


--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_repartition_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNER TO runbot;

--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNED BY public.account_tax_repartition_line.id;


--
-- Name: account_tax_repartition_line_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_repartition_line_template (
    id integer NOT NULL,
    factor_percent double precision NOT NULL,
    repartition_type character varying NOT NULL,
    account_id integer,
    invoice_tax_id integer,
    refund_tax_id integer,
    use_in_tax_closing boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_repartition_line_template OWNER TO runbot;

--
-- Name: TABLE account_tax_repartition_line_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_repartition_line_template IS 'Tax Repartition Line Template';


--
-- Name: COLUMN account_tax_repartition_line_template.factor_percent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.factor_percent IS '%';


--
-- Name: COLUMN account_tax_repartition_line_template.repartition_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.repartition_type IS 'Based On';


--
-- Name: COLUMN account_tax_repartition_line_template.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.account_id IS 'Account';


--
-- Name: COLUMN account_tax_repartition_line_template.invoice_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.invoice_tax_id IS 'Invoice Tax';


--
-- Name: COLUMN account_tax_repartition_line_template.refund_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.refund_tax_id IS 'Refund Tax';


--
-- Name: COLUMN account_tax_repartition_line_template.use_in_tax_closing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.use_in_tax_closing IS 'Tax Closing Entry';


--
-- Name: COLUMN account_tax_repartition_line_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_repartition_line_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_repartition_line_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_repartition_line_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.write_date IS 'Last Updated on';


--
-- Name: account_tax_repartition_line_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_repartition_line_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_repartition_line_template_id_seq OWNER TO runbot;

--
-- Name: account_tax_repartition_line_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_repartition_line_template_id_seq OWNED BY public.account_tax_repartition_line_template.id;


--
-- Name: account_tax_repartition_minus_report_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_repartition_minus_report_line (
    account_tax_repartition_line_template_id integer NOT NULL,
    account_tax_report_line_id integer NOT NULL
);


ALTER TABLE public.account_tax_repartition_minus_report_line OWNER TO runbot;

--
-- Name: TABLE account_tax_repartition_minus_report_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_repartition_minus_report_line IS 'RELATION BETWEEN account_tax_repartition_line_template AND account_tax_report_line';


--
-- Name: account_tax_repartition_plus_report_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_repartition_plus_report_line (
    account_tax_repartition_line_template_id integer NOT NULL,
    account_tax_report_line_id integer NOT NULL
);


ALTER TABLE public.account_tax_repartition_plus_report_line OWNER TO runbot;

--
-- Name: TABLE account_tax_repartition_plus_report_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_repartition_plus_report_line IS 'RELATION BETWEEN account_tax_repartition_line_template AND account_tax_report_line';


--
-- Name: account_tax_report; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_report (
    id integer NOT NULL,
    name character varying NOT NULL,
    country_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_report OWNER TO runbot;

--
-- Name: TABLE account_tax_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_report IS 'Account Tax Report';


--
-- Name: COLUMN account_tax_report.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report.name IS 'Name';


--
-- Name: COLUMN account_tax_report.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report.country_id IS 'Country';


--
-- Name: COLUMN account_tax_report.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_report.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_report.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_report.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report.write_date IS 'Last Updated on';


--
-- Name: account_tax_report_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_report_id_seq OWNER TO runbot;

--
-- Name: account_tax_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_report_id_seq OWNED BY public.account_tax_report.id;


--
-- Name: account_tax_report_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_report_line (
    id integer NOT NULL,
    name character varying NOT NULL,
    report_action_id integer,
    parent_id integer,
    sequence integer NOT NULL,
    parent_path character varying,
    report_id integer NOT NULL,
    tag_name character varying,
    code character varying,
    formula character varying,
    carry_over_condition_method character varying,
    carry_over_destination_line_id integer,
    is_carryover_persistent boolean,
    is_carryover_used_in_balance boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_report_line OWNER TO runbot;

--
-- Name: TABLE account_tax_report_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_report_line IS 'Account Tax Report Line';


--
-- Name: COLUMN account_tax_report_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.name IS 'Name';


--
-- Name: COLUMN account_tax_report_line.report_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.report_action_id IS 'Report Action';


--
-- Name: COLUMN account_tax_report_line.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.parent_id IS 'Parent Line';


--
-- Name: COLUMN account_tax_report_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_report_line.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.parent_path IS 'Parent Path';


--
-- Name: COLUMN account_tax_report_line.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.report_id IS 'Tax Report';


--
-- Name: COLUMN account_tax_report_line.tag_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.tag_name IS 'Tag Name';


--
-- Name: COLUMN account_tax_report_line.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.code IS 'Code';


--
-- Name: COLUMN account_tax_report_line.formula; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.formula IS 'Formula';


--
-- Name: COLUMN account_tax_report_line.carry_over_condition_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.carry_over_condition_method IS 'Method';


--
-- Name: COLUMN account_tax_report_line.carry_over_destination_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.carry_over_destination_line_id IS 'Destination';


--
-- Name: COLUMN account_tax_report_line.is_carryover_persistent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.is_carryover_persistent IS 'Persistent';


--
-- Name: COLUMN account_tax_report_line.is_carryover_used_in_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.is_carryover_used_in_balance IS 'Used in line balance';


--
-- Name: COLUMN account_tax_report_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_report_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_report_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_report_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_report_line.write_date IS 'Last Updated on';


--
-- Name: account_tax_report_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_report_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_report_line_id_seq OWNER TO runbot;

--
-- Name: account_tax_report_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_report_line_id_seq OWNED BY public.account_tax_report_line.id;


--
-- Name: account_tax_report_line_tags_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_report_line_tags_rel (
    account_account_tag_id integer NOT NULL,
    account_tax_report_line_id integer NOT NULL
);


ALTER TABLE public.account_tax_report_line_tags_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_report_line_tags_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_report_line_tags_rel IS 'RELATION BETWEEN account_account_tag AND account_tax_report_line';


--
-- Name: account_tax_sale_advance_payment_inv_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_sale_advance_payment_inv_rel (
    sale_advance_payment_inv_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_sale_advance_payment_inv_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_sale_advance_payment_inv_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_sale_advance_payment_inv_rel IS 'RELATION BETWEEN sale_advance_payment_inv AND account_tax';


--
-- Name: account_tax_sale_order_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_sale_order_line_rel (
    sale_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_sale_order_line_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_sale_order_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_sale_order_line_rel IS 'RELATION BETWEEN sale_order_line AND account_tax';


--
-- Name: account_tax_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_template (
    id integer NOT NULL,
    chart_template_id integer NOT NULL,
    name character varying NOT NULL,
    type_tax_use character varying NOT NULL,
    tax_scope character varying,
    amount_type character varying NOT NULL,
    active boolean,
    sequence integer NOT NULL,
    amount numeric NOT NULL,
    description character varying,
    price_include boolean,
    include_base_amount boolean,
    is_base_affected boolean,
    analytic boolean,
    tax_group_id integer,
    tax_exigibility character varying,
    cash_basis_transition_account_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_template OWNER TO runbot;

--
-- Name: TABLE account_tax_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_template IS 'Templates for Taxes';


--
-- Name: COLUMN account_tax_template.chart_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_tax_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.name IS 'Tax Name';


--
-- Name: COLUMN account_tax_template.type_tax_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.type_tax_use IS 'Tax Type';


--
-- Name: COLUMN account_tax_template.tax_scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.tax_scope IS 'Tax Scope';


--
-- Name: COLUMN account_tax_template.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.amount_type IS 'Tax Computation';


--
-- Name: COLUMN account_tax_template.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.active IS 'Active';


--
-- Name: COLUMN account_tax_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_template.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.amount IS 'Amount';


--
-- Name: COLUMN account_tax_template.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.description IS 'Display on Invoices';


--
-- Name: COLUMN account_tax_template.price_include; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.price_include IS 'Included in Price';


--
-- Name: COLUMN account_tax_template.include_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.include_base_amount IS 'Affect Subsequent Taxes';


--
-- Name: COLUMN account_tax_template.is_base_affected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.is_base_affected IS 'Base Affected by Previous Taxes';


--
-- Name: COLUMN account_tax_template.analytic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.analytic IS 'Analytic Cost';


--
-- Name: COLUMN account_tax_template.tax_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.tax_group_id IS 'Tax Group';


--
-- Name: COLUMN account_tax_template.tax_exigibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.tax_exigibility IS 'Tax Due';


--
-- Name: COLUMN account_tax_template.cash_basis_transition_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.cash_basis_transition_account_id IS 'Cash Basis Transition Account';


--
-- Name: COLUMN account_tax_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.write_date IS 'Last Updated on';


--
-- Name: account_tax_template_filiation_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_template_filiation_rel (
    parent_tax integer NOT NULL,
    child_tax integer NOT NULL
);


ALTER TABLE public.account_tax_template_filiation_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_template_filiation_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_template_filiation_rel IS 'RELATION BETWEEN account_tax_template AND account_tax_template';


--
-- Name: account_tax_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_template_id_seq OWNER TO runbot;

--
-- Name: account_tax_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_template_id_seq OWNED BY public.account_tax_template.id;


--
-- Name: account_tour_upload_bill; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tour_upload_bill (
    id integer NOT NULL,
    selection character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tour_upload_bill OWNER TO runbot;

--
-- Name: TABLE account_tour_upload_bill; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tour_upload_bill IS 'Account tour upload bill';


--
-- Name: COLUMN account_tour_upload_bill.selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill.selection IS 'Selection';


--
-- Name: COLUMN account_tour_upload_bill.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill.create_uid IS 'Created by';


--
-- Name: COLUMN account_tour_upload_bill.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill.create_date IS 'Created on';


--
-- Name: COLUMN account_tour_upload_bill.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tour_upload_bill.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill.write_date IS 'Last Updated on';


--
-- Name: account_tour_upload_bill_email_confirm; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tour_upload_bill_email_confirm (
    id integer NOT NULL,
    email_alias character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tour_upload_bill_email_confirm OWNER TO runbot;

--
-- Name: TABLE account_tour_upload_bill_email_confirm; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tour_upload_bill_email_confirm IS 'Account tour upload bill email confirm';


--
-- Name: COLUMN account_tour_upload_bill_email_confirm.email_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill_email_confirm.email_alias IS 'Email Alias';


--
-- Name: COLUMN account_tour_upload_bill_email_confirm.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill_email_confirm.create_uid IS 'Created by';


--
-- Name: COLUMN account_tour_upload_bill_email_confirm.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill_email_confirm.create_date IS 'Created on';


--
-- Name: COLUMN account_tour_upload_bill_email_confirm.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill_email_confirm.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tour_upload_bill_email_confirm.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill_email_confirm.write_date IS 'Last Updated on';


--
-- Name: account_tour_upload_bill_email_confirm_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tour_upload_bill_email_confirm_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tour_upload_bill_email_confirm_id_seq OWNER TO runbot;

--
-- Name: account_tour_upload_bill_email_confirm_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tour_upload_bill_email_confirm_id_seq OWNED BY public.account_tour_upload_bill_email_confirm.id;


--
-- Name: account_tour_upload_bill_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tour_upload_bill_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tour_upload_bill_id_seq OWNER TO runbot;

--
-- Name: account_tour_upload_bill_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tour_upload_bill_id_seq OWNED BY public.account_tour_upload_bill.id;


--
-- Name: account_tour_upload_bill_ir_attachments_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tour_upload_bill_ir_attachments_rel (
    account_tour_upload_bill_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_tour_upload_bill_ir_attachments_rel OWNER TO runbot;

--
-- Name: TABLE account_tour_upload_bill_ir_attachments_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tour_upload_bill_ir_attachments_rel IS 'RELATION BETWEEN account_tour_upload_bill AND ir_attachment';


--
-- Name: account_unreconcile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_unreconcile (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_unreconcile OWNER TO runbot;

--
-- Name: TABLE account_unreconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_unreconcile IS 'Account Unreconcile';


--
-- Name: COLUMN account_unreconcile.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_unreconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_unreconcile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_unreconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_unreconcile.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_unreconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_unreconcile.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_unreconcile.write_date IS 'Last Updated on';


--
-- Name: account_unreconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_unreconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_unreconcile_id_seq OWNER TO runbot;

--
-- Name: account_unreconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_unreconcile_id_seq OWNED BY public.account_unreconcile.id;


--
-- Name: account_update_lock_date; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_update_lock_date (
    id integer NOT NULL,
    company_id integer NOT NULL,
    period_lock_date date,
    fiscalyear_lock_date date,
    tax_lock_date date,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.account_update_lock_date OWNER TO runbot;

--
-- Name: TABLE account_update_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_update_lock_date IS 'Account Update Lock_date';


--
-- Name: COLUMN account_update_lock_date.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_update_lock_date.company_id IS 'Company';


--
-- Name: COLUMN account_update_lock_date.period_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_update_lock_date.period_lock_date IS 'Lock Date for Non-Advisers';


--
-- Name: COLUMN account_update_lock_date.fiscalyear_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_update_lock_date.fiscalyear_lock_date IS 'Lock Date for All Users';


--
-- Name: COLUMN account_update_lock_date.tax_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_update_lock_date.tax_lock_date IS 'Tax Lock Date';


--
-- Name: COLUMN account_update_lock_date.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_update_lock_date.create_uid IS 'Created by';


--
-- Name: COLUMN account_update_lock_date.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_update_lock_date.create_date IS 'Created on';


--
-- Name: COLUMN account_update_lock_date.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_update_lock_date.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_update_lock_date.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_update_lock_date.write_date IS 'Last Updated on';


--
-- Name: account_update_lock_date_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_update_lock_date_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_update_lock_date_id_seq OWNER TO runbot;

--
-- Name: account_update_lock_date_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_update_lock_date_id_seq OWNED BY public.account_update_lock_date.id;


--
-- Name: add_mis_report_instance_dashboard_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.add_mis_report_instance_dashboard_wizard (
    id integer NOT NULL,
    name character varying NOT NULL,
    dashboard_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.add_mis_report_instance_dashboard_wizard OWNER TO runbot;

--
-- Name: TABLE add_mis_report_instance_dashboard_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.add_mis_report_instance_dashboard_wizard IS 'MIS Report Add to Dashboard Wizard';


--
-- Name: COLUMN add_mis_report_instance_dashboard_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.add_mis_report_instance_dashboard_wizard.name IS 'Name';


--
-- Name: COLUMN add_mis_report_instance_dashboard_wizard.dashboard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.add_mis_report_instance_dashboard_wizard.dashboard_id IS 'Dashboard';


--
-- Name: COLUMN add_mis_report_instance_dashboard_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.add_mis_report_instance_dashboard_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN add_mis_report_instance_dashboard_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.add_mis_report_instance_dashboard_wizard.create_date IS 'Created on';


--
-- Name: COLUMN add_mis_report_instance_dashboard_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.add_mis_report_instance_dashboard_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN add_mis_report_instance_dashboard_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.add_mis_report_instance_dashboard_wizard.write_date IS 'Last Updated on';


--
-- Name: add_mis_report_instance_dashboard_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.add_mis_report_instance_dashboard_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.add_mis_report_instance_dashboard_wizard_id_seq OWNER TO runbot;

--
-- Name: add_mis_report_instance_dashboard_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.add_mis_report_instance_dashboard_wizard_id_seq OWNED BY public.add_mis_report_instance_dashboard_wizard.id;


--
-- Name: aged_partner_balance_report_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.aged_partner_balance_report_wizard (
    id integer NOT NULL,
    company_id integer,
    date_at date NOT NULL,
    date_from date,
    target_move character varying NOT NULL,
    receivable_accounts_only boolean,
    payable_accounts_only boolean,
    show_move_line_details boolean,
    account_code_from integer,
    account_code_to integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.aged_partner_balance_report_wizard OWNER TO runbot;

--
-- Name: TABLE aged_partner_balance_report_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.aged_partner_balance_report_wizard IS 'Aged Partner Balance Wizard';


--
-- Name: COLUMN aged_partner_balance_report_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.aged_partner_balance_report_wizard.company_id IS 'Company';


--
-- Name: COLUMN aged_partner_balance_report_wizard.date_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.aged_partner_balance_report_wizard.date_at IS 'Date At';


--
-- Name: COLUMN aged_partner_balance_report_wizard.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.aged_partner_balance_report_wizard.date_from IS 'Date From';


--
-- Name: COLUMN aged_partner_balance_report_wizard.target_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.aged_partner_balance_report_wizard.target_move IS 'Target Moves';


--
-- Name: COLUMN aged_partner_balance_report_wizard.receivable_accounts_only; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.aged_partner_balance_report_wizard.receivable_accounts_only IS 'Receivable Accounts Only';


--
-- Name: COLUMN aged_partner_balance_report_wizard.payable_accounts_only; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.aged_partner_balance_report_wizard.payable_accounts_only IS 'Payable Accounts Only';


--
-- Name: COLUMN aged_partner_balance_report_wizard.show_move_line_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.aged_partner_balance_report_wizard.show_move_line_details IS 'Show Move Line Details';


--
-- Name: COLUMN aged_partner_balance_report_wizard.account_code_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.aged_partner_balance_report_wizard.account_code_from IS 'Account Code From';


--
-- Name: COLUMN aged_partner_balance_report_wizard.account_code_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.aged_partner_balance_report_wizard.account_code_to IS 'Account Code To';


--
-- Name: COLUMN aged_partner_balance_report_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.aged_partner_balance_report_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN aged_partner_balance_report_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.aged_partner_balance_report_wizard.create_date IS 'Created on';


--
-- Name: COLUMN aged_partner_balance_report_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.aged_partner_balance_report_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN aged_partner_balance_report_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.aged_partner_balance_report_wizard.write_date IS 'Last Updated on';


--
-- Name: aged_partner_balance_report_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.aged_partner_balance_report_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.aged_partner_balance_report_wizard_id_seq OWNER TO runbot;

--
-- Name: aged_partner_balance_report_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.aged_partner_balance_report_wizard_id_seq OWNED BY public.aged_partner_balance_report_wizard.id;


--
-- Name: aged_partner_balance_report_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.aged_partner_balance_report_wizard_res_partner_rel (
    aged_partner_balance_report_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.aged_partner_balance_report_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE aged_partner_balance_report_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.aged_partner_balance_report_wizard_res_partner_rel IS 'RELATION BETWEEN aged_partner_balance_report_wizard AND res_partner';


--
-- Name: auth_saml_attribute_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_saml_attribute_mapping (
    id integer NOT NULL,
    provider_id integer NOT NULL,
    attribute_name character varying NOT NULL,
    field_name character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_saml_attribute_mapping OWNER TO runbot;

--
-- Name: TABLE auth_saml_attribute_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_saml_attribute_mapping IS 'SAML2 attribute mapping';


--
-- Name: COLUMN auth_saml_attribute_mapping.provider_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_attribute_mapping.provider_id IS 'Provider';


--
-- Name: COLUMN auth_saml_attribute_mapping.attribute_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_attribute_mapping.attribute_name IS 'IDP Response Attribute';


--
-- Name: COLUMN auth_saml_attribute_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_attribute_mapping.field_name IS 'Odoo Field';


--
-- Name: COLUMN auth_saml_attribute_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_attribute_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN auth_saml_attribute_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_attribute_mapping.create_date IS 'Created on';


--
-- Name: COLUMN auth_saml_attribute_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_attribute_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_saml_attribute_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_attribute_mapping.write_date IS 'Last Updated on';


--
-- Name: auth_saml_attribute_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_saml_attribute_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_saml_attribute_mapping_id_seq OWNER TO runbot;

--
-- Name: auth_saml_attribute_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_saml_attribute_mapping_id_seq OWNED BY public.auth_saml_attribute_mapping.id;


--
-- Name: auth_saml_provider; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_saml_provider (
    id integer NOT NULL,
    name character varying NOT NULL,
    entity_id character varying NOT NULL,
    idp_metadata text NOT NULL,
    sp_baseurl text,
    sp_pem_public_filename character varying,
    sp_pem_private_filename character varying,
    matching_attribute character varying NOT NULL,
    matching_attribute_to_lower boolean,
    active boolean,
    sequence integer,
    css_class character varying,
    body character varying,
    autoredirect boolean,
    sig_alg character varying NOT NULL,
    authn_requests_signed boolean,
    logout_requests_signed boolean,
    want_assertions_signed boolean,
    want_response_signed boolean,
    want_assertions_or_response_signed boolean,
    sign_authenticate_requests boolean,
    sign_metadata boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_saml_provider OWNER TO runbot;

--
-- Name: TABLE auth_saml_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_saml_provider IS 'SAML2 Provider';


--
-- Name: COLUMN auth_saml_provider.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.name IS 'Provider Name';


--
-- Name: COLUMN auth_saml_provider.entity_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.entity_id IS 'Entity ID';


--
-- Name: COLUMN auth_saml_provider.idp_metadata; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.idp_metadata IS 'Identity Provider Metadata';


--
-- Name: COLUMN auth_saml_provider.sp_baseurl; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.sp_baseurl IS 'Override Base URL';


--
-- Name: COLUMN auth_saml_provider.sp_pem_public_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.sp_pem_public_filename IS 'Odoo Public Certificate File Name';


--
-- Name: COLUMN auth_saml_provider.sp_pem_private_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.sp_pem_private_filename IS 'Odoo Private Key File Name';


--
-- Name: COLUMN auth_saml_provider.matching_attribute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.matching_attribute IS 'Identity Provider matching attribute';


--
-- Name: COLUMN auth_saml_provider.matching_attribute_to_lower; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.matching_attribute_to_lower IS 'Lowercase IDP Matching Attribute';


--
-- Name: COLUMN auth_saml_provider.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.active IS 'Active';


--
-- Name: COLUMN auth_saml_provider.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.sequence IS 'Sequence';


--
-- Name: COLUMN auth_saml_provider.css_class; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.css_class IS 'Button Icon CSS class';


--
-- Name: COLUMN auth_saml_provider.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.body IS 'Button Description';


--
-- Name: COLUMN auth_saml_provider.autoredirect; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.autoredirect IS 'Automatic Redirection';


--
-- Name: COLUMN auth_saml_provider.sig_alg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.sig_alg IS 'Signature Algorithm';


--
-- Name: COLUMN auth_saml_provider.authn_requests_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.authn_requests_signed IS 'Authn Requests Signed';


--
-- Name: COLUMN auth_saml_provider.logout_requests_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.logout_requests_signed IS 'Logout Requests Signed';


--
-- Name: COLUMN auth_saml_provider.want_assertions_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.want_assertions_signed IS 'Want Assertions Signed';


--
-- Name: COLUMN auth_saml_provider.want_response_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.want_response_signed IS 'Want Response Signed';


--
-- Name: COLUMN auth_saml_provider.want_assertions_or_response_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.want_assertions_or_response_signed IS 'Want Assertions Or Response Signed';


--
-- Name: COLUMN auth_saml_provider.sign_authenticate_requests; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.sign_authenticate_requests IS 'Sign Authenticate Requests';


--
-- Name: COLUMN auth_saml_provider.sign_metadata; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.sign_metadata IS 'Sign Metadata';


--
-- Name: COLUMN auth_saml_provider.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.create_uid IS 'Created by';


--
-- Name: COLUMN auth_saml_provider.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.create_date IS 'Created on';


--
-- Name: COLUMN auth_saml_provider.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_saml_provider.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_provider.write_date IS 'Last Updated on';


--
-- Name: auth_saml_provider_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_saml_provider_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_saml_provider_id_seq OWNER TO runbot;

--
-- Name: auth_saml_provider_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_saml_provider_id_seq OWNED BY public.auth_saml_provider.id;


--
-- Name: auth_saml_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_saml_request (
    id integer NOT NULL,
    saml_provider_id integer NOT NULL,
    saml_request_id character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_saml_request OWNER TO runbot;

--
-- Name: TABLE auth_saml_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_saml_request IS 'SAML Outstanding Requests';


--
-- Name: COLUMN auth_saml_request.saml_provider_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_request.saml_provider_id IS 'SAML Provider that issued the token';


--
-- Name: COLUMN auth_saml_request.saml_request_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_request.saml_request_id IS 'Current Request ID';


--
-- Name: COLUMN auth_saml_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_request.create_uid IS 'Created by';


--
-- Name: COLUMN auth_saml_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_request.create_date IS 'Created on';


--
-- Name: COLUMN auth_saml_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_saml_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_saml_request.write_date IS 'Last Updated on';


--
-- Name: auth_saml_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_saml_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_saml_request_id_seq OWNER TO runbot;

--
-- Name: auth_saml_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_saml_request_id_seq OWNED BY public.auth_saml_request.id;


--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    secret character varying NOT NULL,
    url character varying,
    qrcode bytea,
    code character varying(7),
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: COLUMN auth_totp_wizard.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.code IS 'Verification Code';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: barcode_nomenclature; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.barcode_nomenclature (
    id integer NOT NULL,
    name character varying(32) NOT NULL,
    upc_ean_conv character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.barcode_nomenclature OWNER TO runbot;

--
-- Name: TABLE barcode_nomenclature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.barcode_nomenclature IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_nomenclature.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.name IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_nomenclature.upc_ean_conv; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.upc_ean_conv IS 'UPC/EAN Conversion';


--
-- Name: COLUMN barcode_nomenclature.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.create_uid IS 'Created by';


--
-- Name: COLUMN barcode_nomenclature.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.create_date IS 'Created on';


--
-- Name: COLUMN barcode_nomenclature.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.write_uid IS 'Last Updated by';


--
-- Name: COLUMN barcode_nomenclature.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.write_date IS 'Last Updated on';


--
-- Name: barcode_nomenclature_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.barcode_nomenclature_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.barcode_nomenclature_id_seq OWNER TO runbot;

--
-- Name: barcode_nomenclature_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.barcode_nomenclature_id_seq OWNED BY public.barcode_nomenclature.id;


--
-- Name: barcode_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.barcode_rule (
    id integer NOT NULL,
    name character varying(32) NOT NULL,
    barcode_nomenclature_id integer,
    sequence integer,
    encoding character varying NOT NULL,
    type character varying NOT NULL,
    pattern character varying(32) NOT NULL,
    alias character varying(32) NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.barcode_rule OWNER TO runbot;

--
-- Name: TABLE barcode_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.barcode_rule IS 'Barcode Rule';


--
-- Name: COLUMN barcode_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.name IS 'Rule Name';


--
-- Name: COLUMN barcode_rule.barcode_nomenclature_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.barcode_nomenclature_id IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.sequence IS 'Sequence';


--
-- Name: COLUMN barcode_rule.encoding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.encoding IS 'Encoding';


--
-- Name: COLUMN barcode_rule.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.type IS 'Type';


--
-- Name: COLUMN barcode_rule.pattern; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.pattern IS 'Barcode Pattern';


--
-- Name: COLUMN barcode_rule.alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.alias IS 'Alias';


--
-- Name: COLUMN barcode_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.create_uid IS 'Created by';


--
-- Name: COLUMN barcode_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.create_date IS 'Created on';


--
-- Name: COLUMN barcode_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN barcode_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.write_date IS 'Last Updated on';


--
-- Name: barcode_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.barcode_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.barcode_rule_id_seq OWNER TO runbot;

--
-- Name: barcode_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.barcode_rule_id_seq OWNED BY public.barcode_rule.id;


--
-- Name: base_cache_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling OWNER TO runbot;

--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    duration character varying,
    expiration timestamp without time zone,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    res_model character varying,
    file bytea,
    file_name character varying,
    file_type character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_tests_models_char; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char (
    id integer NOT NULL,
    value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char IS 'Tests : Base Import Model, Character';


--
-- Name: COLUMN base_import_tests_models_char.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_id_seq OWNED BY public.base_import_tests_models_char.id;


--
-- Name: base_import_tests_models_char_noreadonly; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_noreadonly (
    id integer NOT NULL,
    value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_noreadonly OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_noreadonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_noreadonly IS 'Tests : Base Import Model, Character No readonly';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_noreadonly_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_noreadonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq OWNED BY public.base_import_tests_models_char_noreadonly.id;


--
-- Name: base_import_tests_models_char_readonly; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_readonly (
    id integer NOT NULL,
    value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_readonly OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_readonly IS 'Tests : Base Import Model, Character readonly';


--
-- Name: COLUMN base_import_tests_models_char_readonly.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_readonly.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_readonly.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_readonly.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_readonly.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_readonly_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_readonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_readonly_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_readonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_readonly_id_seq OWNED BY public.base_import_tests_models_char_readonly.id;


--
-- Name: base_import_tests_models_char_required; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_required (
    id integer NOT NULL,
    value character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_required OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_required IS 'Tests : Base Import Model, Character required';


--
-- Name: COLUMN base_import_tests_models_char_required.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_required.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_required.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_required.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_required.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_required_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_required_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_required_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_required_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_required_id_seq OWNED BY public.base_import_tests_models_char_required.id;


--
-- Name: base_import_tests_models_char_states; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_states (
    id integer NOT NULL,
    value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_states OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_states; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_states IS 'Tests : Base Import Model, Character states';


--
-- Name: COLUMN base_import_tests_models_char_states.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_states.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_states.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_states.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_states.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_states_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_states_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_states_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_states_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_states_id_seq OWNED BY public.base_import_tests_models_char_states.id;


--
-- Name: base_import_tests_models_char_stillreadonly; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_stillreadonly (
    id integer NOT NULL,
    value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_stillreadonly OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_stillreadonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_stillreadonly IS 'Tests : Base Import Model, Character still readonly';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_stillreadonly_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_stillreadonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq OWNED BY public.base_import_tests_models_char_stillreadonly.id;


--
-- Name: base_import_tests_models_complex; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_complex (
    id integer NOT NULL,
    f double precision,
    m numeric,
    c character varying,
    currency_id integer,
    d date,
    dt timestamp without time zone,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_complex OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_complex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_complex IS 'Tests: Base Import Model Complex';


--
-- Name: COLUMN base_import_tests_models_complex.f; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.f IS 'F';


--
-- Name: COLUMN base_import_tests_models_complex.m; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.m IS 'M';


--
-- Name: COLUMN base_import_tests_models_complex.c; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.c IS 'C';


--
-- Name: COLUMN base_import_tests_models_complex.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.currency_id IS 'Currency';


--
-- Name: COLUMN base_import_tests_models_complex.d; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.d IS 'D';


--
-- Name: COLUMN base_import_tests_models_complex.dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.dt IS 'Dt';


--
-- Name: COLUMN base_import_tests_models_complex.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_complex.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_complex.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_complex.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_complex_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_complex_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_complex_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_complex_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_complex_id_seq OWNED BY public.base_import_tests_models_complex.id;


--
-- Name: base_import_tests_models_float; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_float (
    id integer NOT NULL,
    value double precision,
    value2 numeric,
    currency_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_float OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_float IS 'Tests: Base Import Model Float';


--
-- Name: COLUMN base_import_tests_models_float.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_float.value2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.value2 IS 'Value2';


--
-- Name: COLUMN base_import_tests_models_float.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.currency_id IS 'Currency';


--
-- Name: COLUMN base_import_tests_models_float.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_float.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_float.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_float.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_float_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_float_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_float_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_float_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_float_id_seq OWNED BY public.base_import_tests_models_float.id;


--
-- Name: base_import_tests_models_m2o; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o IS 'Tests : Base Import Model, Many to One';


--
-- Name: COLUMN base_import_tests_models_m2o.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_id_seq OWNED BY public.base_import_tests_models_m2o.id;


--
-- Name: base_import_tests_models_m2o_related; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o_related (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o_related OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o_related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o_related IS 'Tests : Base Import Model, Many to One related';


--
-- Name: COLUMN base_import_tests_models_m2o_related.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_related.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_related.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_related.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_related.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_related_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_related_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_related_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_related_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_related_id_seq OWNED BY public.base_import_tests_models_m2o_related.id;


--
-- Name: base_import_tests_models_m2o_required; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o_required (
    id integer NOT NULL,
    value integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o_required OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o_required IS 'Tests : Base Import Model, Many to One required';


--
-- Name: COLUMN base_import_tests_models_m2o_required.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_required.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_required.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_required.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_required.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_required_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_required_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_required_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_required_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_required_id_seq OWNED BY public.base_import_tests_models_m2o_required.id;


--
-- Name: base_import_tests_models_m2o_required_related; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o_required_related (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o_required_related OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o_required_related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o_required_related IS 'Tests : Base Import Model, Many to One required related';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_required_related_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_required_related_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq OWNED BY public.base_import_tests_models_m2o_required_related.id;


--
-- Name: base_import_tests_models_o2m; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_o2m (
    id integer NOT NULL,
    name character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_o2m OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_o2m; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_o2m IS 'Tests : Base Import Model, One to Many';


--
-- Name: COLUMN base_import_tests_models_o2m.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.name IS 'Name';


--
-- Name: COLUMN base_import_tests_models_o2m.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_o2m.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_o2m.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_o2m.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_o2m_child; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_o2m_child (
    id integer NOT NULL,
    parent_id integer,
    value integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_o2m_child OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_o2m_child; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_o2m_child IS 'Tests : Base Import Model, One to Many child';


--
-- Name: COLUMN base_import_tests_models_o2m_child.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.parent_id IS 'Parent';


--
-- Name: COLUMN base_import_tests_models_o2m_child.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_o2m_child.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_o2m_child.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_o2m_child.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_o2m_child.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_o2m_child_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_o2m_child_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_o2m_child_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_o2m_child_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_o2m_child_id_seq OWNED BY public.base_import_tests_models_o2m_child.id;


--
-- Name: base_import_tests_models_o2m_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_o2m_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_o2m_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_o2m_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_o2m_id_seq OWNED BY public.base_import_tests_models_o2m.id;


--
-- Name: base_import_tests_models_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_preview (
    id integer NOT NULL,
    name character varying,
    somevalue integer NOT NULL,
    othervalue integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_preview OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_preview IS 'Tests : Base Import Model Preview';


--
-- Name: COLUMN base_import_tests_models_preview.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.name IS 'Name';


--
-- Name: COLUMN base_import_tests_models_preview.somevalue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.somevalue IS 'Some Value';


--
-- Name: COLUMN base_import_tests_models_preview.othervalue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.othervalue IS 'Other Variable';


--
-- Name: COLUMN base_import_tests_models_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_preview_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_preview_id_seq OWNED BY public.base_import_tests_models_preview.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    data bytea,
    state character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    name character varying NOT NULL,
    code character varying(6) NOT NULL,
    data bytea NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    lang character varying NOT NULL,
    overwrite boolean,
    state character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.lang IS 'Language';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.state IS 'Status';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    show_all boolean,
    module_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    state character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    module_info text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    state character varying NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    exclude_contact boolean,
    exclude_journal_item boolean,
    maximum_group integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    aggr_ids character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: base_registry_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_registry_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_registry_signaling OWNER TO runbot;

--
-- Name: base_update_translations; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_update_translations (
    id integer NOT NULL,
    lang character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_update_translations OWNER TO runbot;

--
-- Name: TABLE base_update_translations; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_update_translations IS 'Update Translations';


--
-- Name: COLUMN base_update_translations.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_update_translations.lang IS 'Language';


--
-- Name: COLUMN base_update_translations.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_update_translations.create_uid IS 'Created by';


--
-- Name: COLUMN base_update_translations.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_update_translations.create_date IS 'Created on';


--
-- Name: COLUMN base_update_translations.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_update_translations.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_update_translations.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_update_translations.write_date IS 'Last Updated on';


--
-- Name: base_update_translations_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_update_translations_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_update_translations_id_seq OWNER TO runbot;

--
-- Name: base_update_translations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_update_translations_id_seq OWNED BY public.base_update_translations.id;


--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    channel character varying,
    message character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: bus_presence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_presence (
    id integer NOT NULL,
    user_id integer,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone,
    status character varying,
    guest_id integer,
    CONSTRAINT bus_presence_partner_or_guest_exists CHECK ((((user_id IS NOT NULL) AND (guest_id IS NULL)) OR ((user_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.bus_presence OWNER TO runbot;

--
-- Name: TABLE bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_presence IS 'User Presence';


--
-- Name: COLUMN bus_presence.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.user_id IS 'Users';


--
-- Name: COLUMN bus_presence.last_poll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN bus_presence.last_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_presence IS 'Last Presence';


--
-- Name: COLUMN bus_presence.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.status IS 'IM Status';


--
-- Name: COLUMN bus_presence.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.guest_id IS 'Guest';


--
-- Name: CONSTRAINT bus_presence_partner_or_guest_exists ON bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT bus_presence_partner_or_guest_exists ON public.bus_presence IS 'CHECK((user_id IS NOT NULL AND guest_id IS NULL) OR (user_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: bus_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_presence_id_seq OWNER TO runbot;

--
-- Name: bus_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_presence_id_seq OWNED BY public.bus_presence.id;


--
-- Name: calendar_alarm; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_alarm (
    id integer NOT NULL,
    name character varying NOT NULL,
    alarm_type character varying NOT NULL,
    duration integer NOT NULL,
    "interval" character varying NOT NULL,
    duration_minutes integer,
    mail_template_id integer,
    body text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    sms_template_id integer
);


ALTER TABLE public.calendar_alarm OWNER TO runbot;

--
-- Name: TABLE calendar_alarm; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_alarm IS 'Event Alarm';


--
-- Name: COLUMN calendar_alarm.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.name IS 'Name';


--
-- Name: COLUMN calendar_alarm.alarm_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.alarm_type IS 'Type';


--
-- Name: COLUMN calendar_alarm.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.duration IS 'Remind Before';


--
-- Name: COLUMN calendar_alarm."interval"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm."interval" IS 'Unit';


--
-- Name: COLUMN calendar_alarm.duration_minutes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.duration_minutes IS 'Duration in minutes';


--
-- Name: COLUMN calendar_alarm.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.mail_template_id IS 'Email Template';


--
-- Name: COLUMN calendar_alarm.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.body IS 'Additional Message';


--
-- Name: COLUMN calendar_alarm.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_alarm.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.create_date IS 'Created on';


--
-- Name: COLUMN calendar_alarm.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_alarm.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_alarm.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.sms_template_id IS 'SMS Template';


--
-- Name: calendar_alarm_calendar_event_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_alarm_calendar_event_rel (
    calendar_event_id integer NOT NULL,
    calendar_alarm_id integer NOT NULL
);


ALTER TABLE public.calendar_alarm_calendar_event_rel OWNER TO runbot;

--
-- Name: TABLE calendar_alarm_calendar_event_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_alarm_calendar_event_rel IS 'RELATION BETWEEN calendar_event AND calendar_alarm';


--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_alarm_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_alarm_id_seq OWNER TO runbot;

--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_alarm_id_seq OWNED BY public.calendar_alarm.id;


--
-- Name: calendar_attendee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_attendee (
    id integer NOT NULL,
    event_id integer NOT NULL,
    partner_id integer NOT NULL,
    common_name character varying,
    access_token character varying,
    state character varying,
    availability character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_attendee OWNER TO runbot;

--
-- Name: TABLE calendar_attendee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_attendee IS 'Calendar Attendee Information';


--
-- Name: COLUMN calendar_attendee.event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.event_id IS 'Meeting linked';


--
-- Name: COLUMN calendar_attendee.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.partner_id IS 'Attendee';


--
-- Name: COLUMN calendar_attendee.common_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.common_name IS 'Common name';


--
-- Name: COLUMN calendar_attendee.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_attendee.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.state IS 'Status';


--
-- Name: COLUMN calendar_attendee.availability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.availability IS 'Available/Busy';


--
-- Name: COLUMN calendar_attendee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_attendee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.create_date IS 'Created on';


--
-- Name: COLUMN calendar_attendee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_attendee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.write_date IS 'Last Updated on';


--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_attendee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_attendee_id_seq OWNER TO runbot;

--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_attendee_id_seq OWNED BY public.calendar_attendee.id;


--
-- Name: calendar_event; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event (
    id integer NOT NULL,
    message_main_attachment_id integer,
    name character varying NOT NULL,
    description text,
    user_id integer,
    location character varying,
    videocall_location character varying,
    privacy character varying NOT NULL,
    show_as character varying NOT NULL,
    active boolean,
    start timestamp without time zone NOT NULL,
    stop timestamp without time zone NOT NULL,
    allday boolean,
    start_date date,
    stop_date date,
    duration double precision,
    res_id integer,
    res_model_id integer,
    res_model character varying,
    recurrency boolean,
    recurrence_id integer,
    follow_recurrence boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_event OWNER TO runbot;

--
-- Name: TABLE calendar_event; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event IS 'Calendar Event';


--
-- Name: COLUMN calendar_event.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN calendar_event.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.name IS 'Meeting Subject';


--
-- Name: COLUMN calendar_event.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.description IS 'Description';


--
-- Name: COLUMN calendar_event.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.user_id IS 'Organizer';


--
-- Name: COLUMN calendar_event.location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.location IS 'Location';


--
-- Name: COLUMN calendar_event.videocall_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.videocall_location IS 'Meeting URL';


--
-- Name: COLUMN calendar_event.privacy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.privacy IS 'Privacy';


--
-- Name: COLUMN calendar_event.show_as; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.show_as IS 'Show as';


--
-- Name: COLUMN calendar_event.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.active IS 'Active';


--
-- Name: COLUMN calendar_event.start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.start IS 'Start';


--
-- Name: COLUMN calendar_event.stop; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.stop IS 'Stop';


--
-- Name: COLUMN calendar_event.allday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.allday IS 'All Day';


--
-- Name: COLUMN calendar_event.start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.start_date IS 'Start Date';


--
-- Name: COLUMN calendar_event.stop_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.stop_date IS 'End Date';


--
-- Name: COLUMN calendar_event.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.duration IS 'Duration';


--
-- Name: COLUMN calendar_event.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_id IS 'Document ID';


--
-- Name: COLUMN calendar_event.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_model_id IS 'Document Model';


--
-- Name: COLUMN calendar_event.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_model IS 'Document Model Name';


--
-- Name: COLUMN calendar_event.recurrency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.recurrency IS 'Recurrent';


--
-- Name: COLUMN calendar_event.recurrence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.recurrence_id IS 'Recurrence Rule';


--
-- Name: COLUMN calendar_event.follow_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.follow_recurrence IS 'Follow Recurrence';


--
-- Name: COLUMN calendar_event.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.write_date IS 'Last Updated on';


--
-- Name: calendar_event_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_event_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_event_id_seq OWNER TO runbot;

--
-- Name: calendar_event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_event_id_seq OWNED BY public.calendar_event.id;


--
-- Name: calendar_event_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event_res_partner_rel (
    res_partner_id integer NOT NULL,
    calendar_event_id integer NOT NULL
);


ALTER TABLE public.calendar_event_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE calendar_event_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event_res_partner_rel IS 'RELATION BETWEEN res_partner AND calendar_event';


--
-- Name: calendar_event_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event_type (
    id integer NOT NULL,
    name character varying NOT NULL,
    color integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_event_type OWNER TO runbot;

--
-- Name: TABLE calendar_event_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event_type IS 'Event Meeting Type';


--
-- Name: COLUMN calendar_event_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.name IS 'Name';


--
-- Name: COLUMN calendar_event_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.color IS 'Color';


--
-- Name: COLUMN calendar_event_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.write_date IS 'Last Updated on';


--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_event_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_event_type_id_seq OWNER TO runbot;

--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_event_type_id_seq OWNED BY public.calendar_event_type.id;


--
-- Name: calendar_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_filters (
    id integer NOT NULL,
    user_id integer NOT NULL,
    partner_id integer NOT NULL,
    active boolean,
    partner_checked boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_filters OWNER TO runbot;

--
-- Name: TABLE calendar_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_filters IS 'Calendar Filters';


--
-- Name: COLUMN calendar_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.user_id IS 'Me';


--
-- Name: COLUMN calendar_filters.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.partner_id IS 'Employee';


--
-- Name: COLUMN calendar_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.active IS 'Active';


--
-- Name: COLUMN calendar_filters.partner_checked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.partner_checked IS 'Checked';


--
-- Name: COLUMN calendar_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.create_date IS 'Created on';


--
-- Name: COLUMN calendar_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.write_date IS 'Last Updated on';


--
-- Name: calendar_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_filters_id_seq OWNER TO runbot;

--
-- Name: calendar_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_filters_id_seq OWNED BY public.calendar_filters.id;


--
-- Name: calendar_recurrence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_recurrence (
    id integer NOT NULL,
    name character varying,
    base_event_id integer,
    event_tz character varying,
    rrule character varying,
    rrule_type character varying,
    end_type character varying,
    "interval" integer,
    count integer,
    mon boolean,
    tue boolean,
    wed boolean,
    thu boolean,
    fri boolean,
    sat boolean,
    sun boolean,
    month_by character varying,
    day integer,
    weekday character varying,
    byday character varying,
    until date,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT calendar_recurrence_month_day CHECK ((((rrule_type)::text <> 'monthly'::text) OR ((month_by)::text <> 'day'::text) OR ((day >= 1) AND (day <= 31)) OR (((weekday)::text = ANY ((ARRAY['MON'::character varying, 'TUE'::character varying, 'WED'::character varying, 'THU'::character varying, 'FRI'::character varying, 'SAT'::character varying, 'SUN'::character varying])::text[])) AND ((byday)::text = ANY ((ARRAY['1'::character varying, '2'::character varying, '3'::character varying, '4'::character varying, '-1'::character varying])::text[])))))
);


ALTER TABLE public.calendar_recurrence OWNER TO runbot;

--
-- Name: TABLE calendar_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_recurrence IS 'Event Recurrence Rule';


--
-- Name: COLUMN calendar_recurrence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.name IS 'Name';


--
-- Name: COLUMN calendar_recurrence.base_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.base_event_id IS 'Base Event';


--
-- Name: COLUMN calendar_recurrence.event_tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.event_tz IS 'Timezone';


--
-- Name: COLUMN calendar_recurrence.rrule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.rrule IS 'Rrule';


--
-- Name: COLUMN calendar_recurrence.rrule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.rrule_type IS 'Rrule Type';


--
-- Name: COLUMN calendar_recurrence.end_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.end_type IS 'End Type';


--
-- Name: COLUMN calendar_recurrence."interval"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence."interval" IS 'Interval';


--
-- Name: COLUMN calendar_recurrence.count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.count IS 'Count';


--
-- Name: COLUMN calendar_recurrence.mon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.mon IS 'Mon';


--
-- Name: COLUMN calendar_recurrence.tue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.tue IS 'Tue';


--
-- Name: COLUMN calendar_recurrence.wed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.wed IS 'Wed';


--
-- Name: COLUMN calendar_recurrence.thu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.thu IS 'Thu';


--
-- Name: COLUMN calendar_recurrence.fri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.fri IS 'Fri';


--
-- Name: COLUMN calendar_recurrence.sat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.sat IS 'Sat';


--
-- Name: COLUMN calendar_recurrence.sun; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.sun IS 'Sun';


--
-- Name: COLUMN calendar_recurrence.month_by; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.month_by IS 'Month By';


--
-- Name: COLUMN calendar_recurrence.day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.day IS 'Day';


--
-- Name: COLUMN calendar_recurrence.weekday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.weekday IS 'Weekday';


--
-- Name: COLUMN calendar_recurrence.byday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.byday IS 'By day';


--
-- Name: COLUMN calendar_recurrence.until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.until IS 'Repeat Until';


--
-- Name: COLUMN calendar_recurrence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_recurrence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.create_date IS 'Created on';


--
-- Name: COLUMN calendar_recurrence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_recurrence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT calendar_recurrence_month_day ON calendar_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT calendar_recurrence_month_day ON public.calendar_recurrence IS 'CHECK (rrule_type != ''monthly'' OR month_by != ''day'' OR day >= 1 AND day <= 31 OR weekday in (''MON'', ''TUE'', ''WED'', ''THU'', ''FRI'', ''SAT'', ''SUN'') AND byday in (''1'', ''2'', ''3'', ''4'', ''-1''))';


--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_recurrence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_recurrence_id_seq OWNER TO runbot;

--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_recurrence_id_seq OWNED BY public.calendar_recurrence.id;


--
-- Name: cash_box_out; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cash_box_out (
    id integer NOT NULL,
    name character varying NOT NULL,
    amount numeric NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.cash_box_out OWNER TO runbot;

--
-- Name: TABLE cash_box_out; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cash_box_out IS 'Cash Box Out';


--
-- Name: COLUMN cash_box_out.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cash_box_out.name IS 'Reason';


--
-- Name: COLUMN cash_box_out.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cash_box_out.amount IS 'Amount';


--
-- Name: COLUMN cash_box_out.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cash_box_out.create_uid IS 'Created by';


--
-- Name: COLUMN cash_box_out.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cash_box_out.create_date IS 'Created on';


--
-- Name: COLUMN cash_box_out.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cash_box_out.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cash_box_out.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cash_box_out.write_date IS 'Last Updated on';


--
-- Name: cash_box_out_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cash_box_out_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cash_box_out_id_seq OWNER TO runbot;

--
-- Name: cash_box_out_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cash_box_out_id_seq OWNED BY public.cash_box_out.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    user_login character varying,
    new_passwd character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: choose_delivery_carrier; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.choose_delivery_carrier (
    id integer NOT NULL,
    order_id integer NOT NULL,
    carrier_id integer NOT NULL,
    delivery_price double precision,
    display_price double precision,
    delivery_message text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.choose_delivery_carrier OWNER TO runbot;

--
-- Name: TABLE choose_delivery_carrier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.choose_delivery_carrier IS 'Delivery Carrier Selection Wizard';


--
-- Name: COLUMN choose_delivery_carrier.order_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.order_id IS 'Order';


--
-- Name: COLUMN choose_delivery_carrier.carrier_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.carrier_id IS 'Shipping Method';


--
-- Name: COLUMN choose_delivery_carrier.delivery_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.delivery_price IS 'Delivery Price';


--
-- Name: COLUMN choose_delivery_carrier.display_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.display_price IS 'Cost';


--
-- Name: COLUMN choose_delivery_carrier.delivery_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.delivery_message IS 'Delivery Message';


--
-- Name: COLUMN choose_delivery_carrier.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.create_uid IS 'Created by';


--
-- Name: COLUMN choose_delivery_carrier.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.create_date IS 'Created on';


--
-- Name: COLUMN choose_delivery_carrier.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.write_uid IS 'Last Updated by';


--
-- Name: COLUMN choose_delivery_carrier.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.write_date IS 'Last Updated on';


--
-- Name: choose_delivery_carrier_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.choose_delivery_carrier_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.choose_delivery_carrier_id_seq OWNER TO runbot;

--
-- Name: choose_delivery_carrier_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.choose_delivery_carrier_id_seq OWNED BY public.choose_delivery_carrier.id;


--
-- Name: choose_delivery_package; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.choose_delivery_package (
    id integer NOT NULL,
    picking_id integer,
    delivery_package_type_id integer,
    shipping_weight double precision,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.choose_delivery_package OWNER TO runbot;

--
-- Name: TABLE choose_delivery_package; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.choose_delivery_package IS 'Delivery Package Selection Wizard';


--
-- Name: COLUMN choose_delivery_package.picking_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_package.picking_id IS 'Picking';


--
-- Name: COLUMN choose_delivery_package.delivery_package_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_package.delivery_package_type_id IS 'Delivery Package Type';


--
-- Name: COLUMN choose_delivery_package.shipping_weight; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_package.shipping_weight IS 'Shipping Weight';


--
-- Name: COLUMN choose_delivery_package.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_package.create_uid IS 'Created by';


--
-- Name: COLUMN choose_delivery_package.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_package.create_date IS 'Created on';


--
-- Name: COLUMN choose_delivery_package.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_package.write_uid IS 'Last Updated by';


--
-- Name: COLUMN choose_delivery_package.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_package.write_date IS 'Last Updated on';


--
-- Name: choose_delivery_package_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.choose_delivery_package_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.choose_delivery_package_id_seq OWNER TO runbot;

--
-- Name: choose_delivery_package_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.choose_delivery_package_id_seq OWNED BY public.choose_delivery_package.id;


--
-- Name: company_intrastat_reminder_user_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.company_intrastat_reminder_user_rel (
    company_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.company_intrastat_reminder_user_rel OWNER TO runbot;

--
-- Name: TABLE company_intrastat_reminder_user_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.company_intrastat_reminder_user_rel IS 'RELATION BETWEEN res_company AND res_users';


--
-- Name: confirm_stock_sms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.confirm_stock_sms (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.confirm_stock_sms OWNER TO runbot;

--
-- Name: TABLE confirm_stock_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.confirm_stock_sms IS 'Confirm Stock SMS';


--
-- Name: COLUMN confirm_stock_sms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.create_uid IS 'Created by';


--
-- Name: COLUMN confirm_stock_sms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.create_date IS 'Created on';


--
-- Name: COLUMN confirm_stock_sms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN confirm_stock_sms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.write_date IS 'Last Updated on';


--
-- Name: confirm_stock_sms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.confirm_stock_sms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.confirm_stock_sms_id_seq OWNER TO runbot;

--
-- Name: confirm_stock_sms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.confirm_stock_sms_id_seq OWNED BY public.confirm_stock_sms.id;


--
-- Name: crm_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_tag (
    id integer NOT NULL,
    name character varying NOT NULL,
    color integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_tag OWNER TO runbot;

--
-- Name: TABLE crm_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_tag IS 'CRM Tag';


--
-- Name: COLUMN crm_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.name IS 'Tag Name';


--
-- Name: COLUMN crm_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.color IS 'Color';


--
-- Name: COLUMN crm_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.create_uid IS 'Created by';


--
-- Name: COLUMN crm_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.create_date IS 'Created on';


--
-- Name: COLUMN crm_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.write_date IS 'Last Updated on';


--
-- Name: crm_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_tag_id_seq OWNER TO runbot;

--
-- Name: crm_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_tag_id_seq OWNED BY public.crm_tag.id;


--
-- Name: crm_team; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team (
    id integer NOT NULL,
    message_main_attachment_id integer,
    name character varying NOT NULL,
    sequence integer,
    active boolean,
    company_id integer,
    user_id integer,
    color integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    use_quotations boolean,
    invoiced_target double precision
);


ALTER TABLE public.crm_team OWNER TO runbot;

--
-- Name: TABLE crm_team; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team IS 'Sales Team';


--
-- Name: COLUMN crm_team.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN crm_team.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.name IS 'Sales Team';


--
-- Name: COLUMN crm_team.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.sequence IS 'Sequence';


--
-- Name: COLUMN crm_team.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.active IS 'Active';


--
-- Name: COLUMN crm_team.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.company_id IS 'Company';


--
-- Name: COLUMN crm_team.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.user_id IS 'Team Leader';


--
-- Name: COLUMN crm_team.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.color IS 'Color Index';


--
-- Name: COLUMN crm_team.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.create_date IS 'Created on';


--
-- Name: COLUMN crm_team.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_team.use_quotations; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.use_quotations IS 'Quotations';


--
-- Name: COLUMN crm_team.invoiced_target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.invoiced_target IS 'Invoicing Target';


--
-- Name: crm_team_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_team_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_team_id_seq OWNER TO runbot;

--
-- Name: crm_team_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_team_id_seq OWNED BY public.crm_team.id;


--
-- Name: crm_team_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team_member (
    id integer NOT NULL,
    message_main_attachment_id integer,
    crm_team_id integer NOT NULL,
    user_id integer NOT NULL,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_team_member OWNER TO runbot;

--
-- Name: TABLE crm_team_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team_member IS 'Sales Team Member';


--
-- Name: COLUMN crm_team_member.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN crm_team_member.crm_team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.crm_team_id IS 'Sales Team';


--
-- Name: COLUMN crm_team_member.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_team_member.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.active IS 'Active';


--
-- Name: COLUMN crm_team_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.create_date IS 'Created on';


--
-- Name: COLUMN crm_team_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.write_date IS 'Last Updated on';


--
-- Name: crm_team_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_team_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_team_member_id_seq OWNER TO runbot;

--
-- Name: crm_team_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_team_member_id_seq OWNED BY public.crm_team_member.id;


--
-- Name: date_range; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.date_range (
    id integer NOT NULL,
    name character varying NOT NULL,
    date_start date NOT NULL,
    date_end date NOT NULL,
    type_id integer NOT NULL,
    type_name character varying,
    company_id integer,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.date_range OWNER TO runbot;

--
-- Name: TABLE date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.date_range IS 'Date Range';


--
-- Name: COLUMN date_range.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range.name IS 'Name';


--
-- Name: COLUMN date_range.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range.date_start IS 'Start date';


--
-- Name: COLUMN date_range.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range.date_end IS 'End date';


--
-- Name: COLUMN date_range.type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range.type_id IS 'Type';


--
-- Name: COLUMN date_range.type_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range.type_name IS 'Type Name';


--
-- Name: COLUMN date_range.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range.company_id IS 'Company';


--
-- Name: COLUMN date_range.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range.active IS 'Active';


--
-- Name: COLUMN date_range.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range.create_uid IS 'Created by';


--
-- Name: COLUMN date_range.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range.create_date IS 'Created on';


--
-- Name: COLUMN date_range.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN date_range.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range.write_date IS 'Last Updated on';


--
-- Name: date_range_generator; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.date_range_generator (
    id integer NOT NULL,
    name_expr text,
    name_prefix character varying,
    date_start date NOT NULL,
    type_id integer NOT NULL,
    company_id integer,
    unit_of_time character varying NOT NULL,
    duration_count integer NOT NULL,
    count integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.date_range_generator OWNER TO runbot;

--
-- Name: TABLE date_range_generator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.date_range_generator IS 'Date Range Generator';


--
-- Name: COLUMN date_range_generator.name_expr; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_generator.name_expr IS 'Range name expression';


--
-- Name: COLUMN date_range_generator.name_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_generator.name_prefix IS 'Range name prefix';


--
-- Name: COLUMN date_range_generator.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_generator.date_start IS 'Start date';


--
-- Name: COLUMN date_range_generator.type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_generator.type_id IS 'Type';


--
-- Name: COLUMN date_range_generator.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_generator.company_id IS 'Company';


--
-- Name: COLUMN date_range_generator.unit_of_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_generator.unit_of_time IS 'Unit Of Time';


--
-- Name: COLUMN date_range_generator.duration_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_generator.duration_count IS 'Duration';


--
-- Name: COLUMN date_range_generator.count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_generator.count IS 'Number of ranges to generate';


--
-- Name: COLUMN date_range_generator.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_generator.create_uid IS 'Created by';


--
-- Name: COLUMN date_range_generator.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_generator.create_date IS 'Created on';


--
-- Name: COLUMN date_range_generator.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_generator.write_uid IS 'Last Updated by';


--
-- Name: COLUMN date_range_generator.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_generator.write_date IS 'Last Updated on';


--
-- Name: date_range_generator_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.date_range_generator_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.date_range_generator_id_seq OWNER TO runbot;

--
-- Name: date_range_generator_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.date_range_generator_id_seq OWNED BY public.date_range_generator.id;


--
-- Name: date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.date_range_id_seq OWNER TO runbot;

--
-- Name: date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.date_range_id_seq OWNED BY public.date_range.id;


--
-- Name: date_range_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.date_range_type (
    id integer NOT NULL,
    name character varying NOT NULL,
    allow_overlap boolean,
    active boolean,
    company_id integer,
    name_expr text,
    range_name_preview character varying,
    name_prefix character varying,
    duration_count integer,
    unit_of_time character varying,
    autogeneration_date_start date,
    autogeneration_count integer,
    autogeneration_unit character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.date_range_type OWNER TO runbot;

--
-- Name: TABLE date_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.date_range_type IS 'Date Range Type';


--
-- Name: COLUMN date_range_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_type.name IS 'Name';


--
-- Name: COLUMN date_range_type.allow_overlap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_type.allow_overlap IS 'Allow Overlap';


--
-- Name: COLUMN date_range_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_type.active IS 'Active';


--
-- Name: COLUMN date_range_type.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_type.company_id IS 'Company';


--
-- Name: COLUMN date_range_type.name_expr; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_type.name_expr IS 'Range name expression';


--
-- Name: COLUMN date_range_type.range_name_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_type.range_name_preview IS 'Range Name Preview';


--
-- Name: COLUMN date_range_type.name_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_type.name_prefix IS 'Range name prefix';


--
-- Name: COLUMN date_range_type.duration_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_type.duration_count IS 'Duration';


--
-- Name: COLUMN date_range_type.unit_of_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_type.unit_of_time IS 'Unit Of Time';


--
-- Name: COLUMN date_range_type.autogeneration_date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_type.autogeneration_date_start IS 'Autogeneration Start Date';


--
-- Name: COLUMN date_range_type.autogeneration_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_type.autogeneration_count IS 'Autogeneration Count';


--
-- Name: COLUMN date_range_type.autogeneration_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_type.autogeneration_unit IS 'Autogeneration Unit';


--
-- Name: COLUMN date_range_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_type.create_uid IS 'Created by';


--
-- Name: COLUMN date_range_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_type.create_date IS 'Created on';


--
-- Name: COLUMN date_range_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN date_range_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.date_range_type.write_date IS 'Last Updated on';


--
-- Name: date_range_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.date_range_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.date_range_type_id_seq OWNER TO runbot;

--
-- Name: date_range_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.date_range_type_id_seq OWNED BY public.date_range_type.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    name character varying NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: delivery_carrier; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_carrier (
    id integer NOT NULL,
    name character varying NOT NULL,
    active boolean,
    sequence integer,
    delivery_type character varying NOT NULL,
    integration_level character varying,
    prod_environment boolean,
    debug_logging boolean,
    company_id integer,
    product_id integer NOT NULL,
    invoice_policy character varying NOT NULL,
    zip_from character varying,
    zip_to character varying,
    margin double precision,
    free_over boolean,
    amount double precision,
    return_label_on_delivery boolean,
    get_return_label_from_portal boolean,
    fixed_price double precision,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    autoprint_paperformat_id integer,
    printer_id integer,
    printer_bin integer,
    CONSTRAINT delivery_carrier_margin_not_under_100_percent CHECK ((margin >= ('-100'::integer)::double precision))
);


ALTER TABLE public.delivery_carrier OWNER TO runbot;

--
-- Name: TABLE delivery_carrier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_carrier IS 'Shipping Methods';


--
-- Name: COLUMN delivery_carrier.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.name IS 'Delivery Method';


--
-- Name: COLUMN delivery_carrier.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.active IS 'Active';


--
-- Name: COLUMN delivery_carrier.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.sequence IS 'Sequence';


--
-- Name: COLUMN delivery_carrier.delivery_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.delivery_type IS 'Provider';


--
-- Name: COLUMN delivery_carrier.integration_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.integration_level IS 'Integration Level';


--
-- Name: COLUMN delivery_carrier.prod_environment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.prod_environment IS 'Environment';


--
-- Name: COLUMN delivery_carrier.debug_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.debug_logging IS 'Debug logging';


--
-- Name: COLUMN delivery_carrier.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.company_id IS 'Company';


--
-- Name: COLUMN delivery_carrier.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.product_id IS 'Delivery Product';


--
-- Name: COLUMN delivery_carrier.invoice_policy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.invoice_policy IS 'Invoicing Policy';


--
-- Name: COLUMN delivery_carrier.zip_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.zip_from IS 'Zip From';


--
-- Name: COLUMN delivery_carrier.zip_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.zip_to IS 'Zip To';


--
-- Name: COLUMN delivery_carrier.margin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.margin IS 'Margin';


--
-- Name: COLUMN delivery_carrier.free_over; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.free_over IS 'Free if order amount is above';


--
-- Name: COLUMN delivery_carrier.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.amount IS 'Amount';


--
-- Name: COLUMN delivery_carrier.return_label_on_delivery; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.return_label_on_delivery IS 'Generate Return Label';


--
-- Name: COLUMN delivery_carrier.get_return_label_from_portal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.get_return_label_from_portal IS 'Return Label Accessible from Customer Portal';


--
-- Name: COLUMN delivery_carrier.fixed_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.fixed_price IS 'Fixed Price';


--
-- Name: COLUMN delivery_carrier.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.create_uid IS 'Created by';


--
-- Name: COLUMN delivery_carrier.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.create_date IS 'Created on';


--
-- Name: COLUMN delivery_carrier.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.write_uid IS 'Last Updated by';


--
-- Name: COLUMN delivery_carrier.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.write_date IS 'Last Updated on';


--
-- Name: COLUMN delivery_carrier.autoprint_paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.autoprint_paperformat_id IS 'Autoprint Paper Format';


--
-- Name: COLUMN delivery_carrier.printer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.printer_id IS 'Printer';


--
-- Name: COLUMN delivery_carrier.printer_bin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.printer_bin IS 'Printer Bin';


--
-- Name: CONSTRAINT delivery_carrier_margin_not_under_100_percent ON delivery_carrier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT delivery_carrier_margin_not_under_100_percent ON public.delivery_carrier IS 'CHECK (margin >= -100)';


--
-- Name: delivery_carrier_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_carrier_country_rel (
    carrier_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.delivery_carrier_country_rel OWNER TO runbot;

--
-- Name: TABLE delivery_carrier_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_carrier_country_rel IS 'RELATION BETWEEN delivery_carrier AND res_country';


--
-- Name: delivery_carrier_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.delivery_carrier_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.delivery_carrier_id_seq OWNER TO runbot;

--
-- Name: delivery_carrier_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.delivery_carrier_id_seq OWNED BY public.delivery_carrier.id;


--
-- Name: delivery_carrier_state_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_carrier_state_rel (
    carrier_id integer NOT NULL,
    state_id integer NOT NULL
);


ALTER TABLE public.delivery_carrier_state_rel OWNER TO runbot;

--
-- Name: TABLE delivery_carrier_state_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_carrier_state_rel IS 'RELATION BETWEEN delivery_carrier AND res_country_state';


--
-- Name: delivery_price_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_price_rule (
    id integer NOT NULL,
    sequence integer NOT NULL,
    carrier_id integer NOT NULL,
    variable character varying NOT NULL,
    operator character varying NOT NULL,
    max_value double precision NOT NULL,
    list_base_price numeric NOT NULL,
    list_price numeric NOT NULL,
    variable_factor character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.delivery_price_rule OWNER TO runbot;

--
-- Name: TABLE delivery_price_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_price_rule IS 'Delivery Price Rules';


--
-- Name: COLUMN delivery_price_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.sequence IS 'Sequence';


--
-- Name: COLUMN delivery_price_rule.carrier_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.carrier_id IS 'Carrier';


--
-- Name: COLUMN delivery_price_rule.variable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.variable IS 'Variable';


--
-- Name: COLUMN delivery_price_rule.operator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.operator IS 'Operator';


--
-- Name: COLUMN delivery_price_rule.max_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.max_value IS 'Maximum Value';


--
-- Name: COLUMN delivery_price_rule.list_base_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.list_base_price IS 'Sale Base Price';


--
-- Name: COLUMN delivery_price_rule.list_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.list_price IS 'Sale Price';


--
-- Name: COLUMN delivery_price_rule.variable_factor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.variable_factor IS 'Variable Factor';


--
-- Name: COLUMN delivery_price_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.create_uid IS 'Created by';


--
-- Name: COLUMN delivery_price_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.create_date IS 'Created on';


--
-- Name: COLUMN delivery_price_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN delivery_price_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.write_date IS 'Last Updated on';


--
-- Name: delivery_price_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.delivery_price_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.delivery_price_rule_id_seq OWNER TO runbot;

--
-- Name: delivery_price_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.delivery_price_rule_id_seq OWNED BY public.delivery_price_rule.id;


--
-- Name: digest_digest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest (
    id integer NOT NULL,
    name character varying NOT NULL,
    periodicity character varying NOT NULL,
    next_run_date date,
    company_id integer,
    state character varying,
    kpi_res_users_connected boolean,
    kpi_mail_message_total boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    kpi_account_total_revenue boolean,
    kpi_all_sale_total boolean
);


ALTER TABLE public.digest_digest OWNER TO runbot;

--
-- Name: TABLE digest_digest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest IS 'Digest';


--
-- Name: COLUMN digest_digest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.name IS 'Name';


--
-- Name: COLUMN digest_digest.periodicity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.periodicity IS 'Periodicity';


--
-- Name: COLUMN digest_digest.next_run_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.next_run_date IS 'Next Send Date';


--
-- Name: COLUMN digest_digest.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.company_id IS 'Company';


--
-- Name: COLUMN digest_digest.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.state IS 'Status';


--
-- Name: COLUMN digest_digest.kpi_res_users_connected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_res_users_connected IS 'Connected Users';


--
-- Name: COLUMN digest_digest.kpi_mail_message_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_mail_message_total IS 'Messages';


--
-- Name: COLUMN digest_digest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_uid IS 'Created by';


--
-- Name: COLUMN digest_digest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_date IS 'Created on';


--
-- Name: COLUMN digest_digest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_digest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_date IS 'Last Updated on';


--
-- Name: COLUMN digest_digest.kpi_account_total_revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_account_total_revenue IS 'Revenue';


--
-- Name: COLUMN digest_digest.kpi_all_sale_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_all_sale_total IS 'All Sales';


--
-- Name: digest_digest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_digest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_digest_id_seq OWNER TO runbot;

--
-- Name: digest_digest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_digest_id_seq OWNED BY public.digest_digest.id;


--
-- Name: digest_digest_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest_res_users_rel (
    digest_digest_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_digest_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_digest_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest_res_users_rel IS 'RELATION BETWEEN digest_digest AND res_users';


--
-- Name: digest_tip; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip (
    id integer NOT NULL,
    sequence integer,
    name character varying,
    tip_description text,
    group_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.digest_tip OWNER TO runbot;

--
-- Name: TABLE digest_tip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip IS 'Digest Tips';


--
-- Name: COLUMN digest_tip.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.sequence IS 'Sequence';


--
-- Name: COLUMN digest_tip.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.name IS 'Name';


--
-- Name: COLUMN digest_tip.tip_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.tip_description IS 'Tip description';


--
-- Name: COLUMN digest_tip.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.group_id IS 'Authorized Group';


--
-- Name: COLUMN digest_tip.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_uid IS 'Created by';


--
-- Name: COLUMN digest_tip.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_date IS 'Created on';


--
-- Name: COLUMN digest_tip.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_tip.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_date IS 'Last Updated on';


--
-- Name: digest_tip_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_tip_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_tip_id_seq OWNER TO runbot;

--
-- Name: digest_tip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_tip_id_seq OWNED BY public.digest_tip.id;


--
-- Name: digest_tip_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip_res_users_rel (
    digest_tip_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_tip_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_tip_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip_res_users_rel IS 'RELATION BETWEEN digest_tip AND res_users';


--
-- Name: email_template_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.email_template_attachment_rel (
    email_template_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.email_template_attachment_rel OWNER TO runbot;

--
-- Name: TABLE email_template_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.email_template_attachment_rel IS 'RELATION BETWEEN mail_template AND ir_attachment';


--
-- Name: fetchmail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.fetchmail_server (
    id integer NOT NULL,
    name character varying NOT NULL,
    active boolean,
    state character varying,
    server character varying,
    port integer,
    server_type character varying NOT NULL,
    is_ssl boolean,
    attach boolean,
    original boolean,
    date timestamp without time zone,
    "user" character varying,
    password character varying,
    object_id integer,
    priority integer,
    configuration text,
    script character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.fetchmail_server OWNER TO runbot;

--
-- Name: TABLE fetchmail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.fetchmail_server IS 'Incoming Mail Server';


--
-- Name: COLUMN fetchmail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.name IS 'Name';


--
-- Name: COLUMN fetchmail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.active IS 'Active';


--
-- Name: COLUMN fetchmail_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.state IS 'Status';


--
-- Name: COLUMN fetchmail_server.server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server IS 'Server Name';


--
-- Name: COLUMN fetchmail_server.port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.port IS 'Port';


--
-- Name: COLUMN fetchmail_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server_type IS 'Server Type';


--
-- Name: COLUMN fetchmail_server.is_ssl; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.is_ssl IS 'SSL/TLS';


--
-- Name: COLUMN fetchmail_server.attach; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.attach IS 'Keep Attachments';


--
-- Name: COLUMN fetchmail_server.original; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.original IS 'Keep Original';


--
-- Name: COLUMN fetchmail_server.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.date IS 'Last Fetch Date';


--
-- Name: COLUMN fetchmail_server."user"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server."user" IS 'Username';


--
-- Name: COLUMN fetchmail_server.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.password IS 'Password';


--
-- Name: COLUMN fetchmail_server.object_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.object_id IS 'Create a New Record';


--
-- Name: COLUMN fetchmail_server.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.priority IS 'Server Priority';


--
-- Name: COLUMN fetchmail_server.configuration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.configuration IS 'Configuration';


--
-- Name: COLUMN fetchmail_server.script; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.script IS 'Script';


--
-- Name: COLUMN fetchmail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_uid IS 'Created by';


--
-- Name: COLUMN fetchmail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_date IS 'Created on';


--
-- Name: COLUMN fetchmail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN fetchmail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_date IS 'Last Updated on';


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.fetchmail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.fetchmail_server_id_seq OWNER TO runbot;

--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.fetchmail_server_id_seq OWNED BY public.fetchmail_server.id;


--
-- Name: fields_sqlquery_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.fields_sqlquery_rel (
    sql_id integer NOT NULL,
    field_id integer NOT NULL
);


ALTER TABLE public.fields_sqlquery_rel OWNER TO runbot;

--
-- Name: TABLE fields_sqlquery_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.fields_sqlquery_rel IS 'RELATION BETWEEN sql_export AND ir_model_fields';


--
-- Name: general_ledger_report_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.general_ledger_report_wizard (
    id integer NOT NULL,
    company_id integer,
    date_range_id integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    target_move character varying NOT NULL,
    centralize boolean,
    hide_account_at_0 boolean,
    show_analytic_tags boolean,
    receivable_accounts_only boolean,
    payable_accounts_only boolean,
    not_only_one_unaffected_earnings_account boolean,
    foreign_currency boolean,
    account_code_from integer,
    account_code_to integer,
    grouped_by character varying,
    show_cost_center boolean,
    domain character varying,
    unaffected_earnings_account integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.general_ledger_report_wizard OWNER TO runbot;

--
-- Name: TABLE general_ledger_report_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.general_ledger_report_wizard IS 'General Ledger Report Wizard';


--
-- Name: COLUMN general_ledger_report_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.company_id IS 'Company';


--
-- Name: COLUMN general_ledger_report_wizard.date_range_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.date_range_id IS 'Date range';


--
-- Name: COLUMN general_ledger_report_wizard.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.date_from IS 'Date From';


--
-- Name: COLUMN general_ledger_report_wizard.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.date_to IS 'Date To';


--
-- Name: COLUMN general_ledger_report_wizard.target_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.target_move IS 'Target Moves';


--
-- Name: COLUMN general_ledger_report_wizard.centralize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.centralize IS 'Activate centralization';


--
-- Name: COLUMN general_ledger_report_wizard.hide_account_at_0; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.hide_account_at_0 IS 'Hide account ending balance at 0';


--
-- Name: COLUMN general_ledger_report_wizard.show_analytic_tags; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.show_analytic_tags IS 'Show Analytic Tags';


--
-- Name: COLUMN general_ledger_report_wizard.receivable_accounts_only; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.receivable_accounts_only IS 'Receivable Accounts Only';


--
-- Name: COLUMN general_ledger_report_wizard.payable_accounts_only; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.payable_accounts_only IS 'Payable Accounts Only';


--
-- Name: COLUMN general_ledger_report_wizard.not_only_one_unaffected_earnings_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.not_only_one_unaffected_earnings_account IS 'Not Only One Unaffected Earnings Account';


--
-- Name: COLUMN general_ledger_report_wizard.foreign_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.foreign_currency IS 'Show foreign currency';


--
-- Name: COLUMN general_ledger_report_wizard.account_code_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.account_code_from IS 'Account Code From';


--
-- Name: COLUMN general_ledger_report_wizard.account_code_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.account_code_to IS 'Account Code To';


--
-- Name: COLUMN general_ledger_report_wizard.grouped_by; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.grouped_by IS 'Grouped By';


--
-- Name: COLUMN general_ledger_report_wizard.show_cost_center; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.show_cost_center IS 'Show Analytic Account';


--
-- Name: COLUMN general_ledger_report_wizard.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.domain IS 'Journal Items Domain';


--
-- Name: COLUMN general_ledger_report_wizard.unaffected_earnings_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.unaffected_earnings_account IS 'Unaffected Earnings Account';


--
-- Name: COLUMN general_ledger_report_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN general_ledger_report_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.create_date IS 'Created on';


--
-- Name: COLUMN general_ledger_report_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN general_ledger_report_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.general_ledger_report_wizard.write_date IS 'Last Updated on';


--
-- Name: general_ledger_report_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.general_ledger_report_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.general_ledger_report_wizard_id_seq OWNER TO runbot;

--
-- Name: general_ledger_report_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.general_ledger_report_wizard_id_seq OWNED BY public.general_ledger_report_wizard.id;


--
-- Name: general_ledger_report_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.general_ledger_report_wizard_res_partner_rel (
    general_ledger_report_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.general_ledger_report_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE general_ledger_report_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.general_ledger_report_wizard_res_partner_rel IS 'RELATION BETWEEN general_ledger_report_wizard AND res_partner';


--
-- Name: hs_code; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hs_code (
    id integer NOT NULL,
    description character varying,
    local_code character varying NOT NULL,
    active boolean,
    company_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.hs_code OWNER TO runbot;

--
-- Name: TABLE hs_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hs_code IS 'H.S. Code';


--
-- Name: COLUMN hs_code.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hs_code.description IS 'Description';


--
-- Name: COLUMN hs_code.local_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hs_code.local_code IS 'Local Code';


--
-- Name: COLUMN hs_code.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hs_code.active IS 'Active';


--
-- Name: COLUMN hs_code.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hs_code.company_id IS 'Company';


--
-- Name: COLUMN hs_code.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hs_code.create_uid IS 'Created by';


--
-- Name: COLUMN hs_code.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hs_code.create_date IS 'Created on';


--
-- Name: COLUMN hs_code.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hs_code.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hs_code.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hs_code.write_date IS 'Last Updated on';


--
-- Name: hs_code_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hs_code_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hs_code_id_seq OWNER TO runbot;

--
-- Name: hs_code_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hs_code_id_seq OWNED BY public.hs_code.id;


--
-- Name: iap_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account (
    id integer NOT NULL,
    service_name character varying,
    account_token character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.iap_account OWNER TO runbot;

--
-- Name: TABLE iap_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account IS 'IAP Account';


--
-- Name: COLUMN iap_account.service_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_name IS 'Service Name';


--
-- Name: COLUMN iap_account.account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_date IS 'Created on';


--
-- Name: COLUMN iap_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_date IS 'Last Updated on';


--
-- Name: iap_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_account_id_seq OWNER TO runbot;

--
-- Name: iap_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_account_id_seq OWNED BY public.iap_account.id;


--
-- Name: iap_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_company_rel (
    iap_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_company_rel IS 'RELATION BETWEEN iap_account AND res_company';


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    name character varying NOT NULL,
    type character varying NOT NULL,
    help text,
    binding_model_id integer,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions OWNER TO runbot;

--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.name IS 'Name';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_client OWNER TO runbot;

--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml (
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    multi boolean,
    paperformat_id integer,
    print_report_name character varying,
    attachment_use boolean,
    attachment character varying
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_report_xml OWNER TO runbot;

--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server (
    usage character varying NOT NULL,
    state character varying NOT NULL,
    sequence integer,
    model_id integer NOT NULL,
    model_name character varying,
    code text,
    crud_model_id integer,
    link_field_id integer,
    mass_edit_message text,
    template_id integer,
    activity_type_id integer,
    activity_summary character varying,
    activity_note text,
    activity_date_deadline_range integer,
    activity_date_deadline_range_type character varying,
    activity_user_type character varying,
    activity_user_id integer,
    activity_user_field_name character varying,
    sms_template_id integer,
    sms_mass_keep_log boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_server OWNER TO runbot;

--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Action To Do';


--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.model_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_name IS 'Model Name';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Target Model';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: COLUMN ir_act_server.mass_edit_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mass_edit_message IS 'Message';


--
-- Name: COLUMN ir_act_server.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.template_id IS 'Email Template';


--
-- Name: COLUMN ir_act_server.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_type_id IS 'Activity';


--
-- Name: COLUMN ir_act_server.activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_summary IS 'Summary';


--
-- Name: COLUMN ir_act_server.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_note IS 'Note';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range IS 'Due Date In';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range_type IS 'Due type';


--
-- Name: COLUMN ir_act_server.activity_user_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_type IS 'Activity User Type';


--
-- Name: COLUMN ir_act_server.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_id IS 'Responsible';


--
-- Name: COLUMN ir_act_server.activity_user_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_field_name IS 'User field name';


--
-- Name: COLUMN ir_act_server.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN ir_act_server.sms_mass_keep_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_mass_keep_log IS 'Log as Note';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_server_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_server_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_res_partner_rel (
    ir_act_server_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_res_partner_rel IS 'RELATION BETWEEN ir_act_server AND res_partner';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_url (
    url text NOT NULL,
    target character varying NOT NULL
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_url OWNER TO runbot;

--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_id integer,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    usage character varying,
    "limit" integer,
    search_view_id integer,
    filter boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_window OWNER TO runbot;

--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_window_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    view_mode character varying NOT NULL,
    act_window_id integer,
    multi boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_act_window_view OWNER TO runbot;

--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_act_window_view_id_seq OWNER TO runbot;

--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_id_seq OWNER TO runbot;

--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    state character varying NOT NULL,
    name character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_todo OWNER TO runbot;

--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_todo_id_seq OWNER TO runbot;

--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    sequence integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_asset OWNER TO runbot;

--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_asset_id_seq OWNER TO runbot;

--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    name character varying NOT NULL,
    description text,
    res_model character varying,
    res_field character varying,
    res_id integer,
    company_id integer,
    type character varying NOT NULL,
    url character varying(1024),
    public boolean,
    access_token character varying,
    db_datas bytea,
    store_fname character varying,
    file_size integer,
    checksum character varying(40),
    mimetype character varying,
    index_content text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    original_id integer
);


ALTER TABLE public.ir_attachment OWNER TO runbot;

--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_attachment_id_seq OWNER TO runbot;

--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    key character varying NOT NULL,
    value text NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_config_parameter OWNER TO runbot;

--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_config_parameter_id_seq OWNER TO runbot;

--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    cron_name character varying,
    user_id integer NOT NULL,
    active boolean,
    interval_number integer,
    interval_type character varying,
    numbercall integer,
    doall boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    priority integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    run_as_queue_job boolean
);


ALTER TABLE public.ir_cron OWNER TO runbot;

--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.numbercall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.numbercall IS 'Number of Calls';


--
-- Name: COLUMN ir_cron.doall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.doall IS 'Repeat Missed';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_cron.run_as_queue_job; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.run_as_queue_job IS 'Run As Queue Job';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_id_seq OWNER TO runbot;

--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer,
    call_at timestamp without time zone,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_trigger OWNER TO runbot;

--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNER TO runbot;

--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    condition character varying,
    "json_value" character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_default OWNER TO runbot;

--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default."json_value"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default."json_value" IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_default_id_seq OWNER TO runbot;

--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo OWNER TO runbot;

--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    error character varying,
    wizard_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure_wizard OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_id_seq OWNER TO runbot;

--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    name character varying,
    resource character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    language_agnostic boolean,
    global_resolver_id integer
);


ALTER TABLE public.ir_exports OWNER TO runbot;

--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_exports.language_agnostic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.language_agnostic IS 'Language Agnostic';


--
-- Name: COLUMN ir_exports.global_resolver_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.global_resolver_id IS 'Custom global resolver';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_id_seq OWNER TO runbot;

--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    name character varying,
    export_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    target character varying,
    active boolean,
    lang_id integer,
    resolver_id integer,
    instance_method_name character varying
);


ALTER TABLE public.ir_exports_line OWNER TO runbot;

--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_exports_line.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.target IS 'Target';


--
-- Name: COLUMN ir_exports_line.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.active IS 'Active';


--
-- Name: COLUMN ir_exports_line.lang_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.lang_id IS 'Language';


--
-- Name: COLUMN ir_exports_line.resolver_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.resolver_id IS 'Custom resolver';


--
-- Name: COLUMN ir_exports_line.instance_method_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.instance_method_name IS 'Function';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_line_id_seq OWNER TO runbot;

--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_exports_resolver; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_resolver (
    id integer NOT NULL,
    name character varying,
    type character varying,
    python_code text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports_resolver OWNER TO runbot;

--
-- Name: TABLE ir_exports_resolver; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_resolver IS 'Export Resolver';


--
-- Name: COLUMN ir_exports_resolver.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_resolver.name IS 'Name';


--
-- Name: COLUMN ir_exports_resolver.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_resolver.type IS 'Type';


--
-- Name: COLUMN ir_exports_resolver.python_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_resolver.python_code IS 'Python Code';


--
-- Name: COLUMN ir_exports_resolver.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_resolver.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_resolver.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_resolver.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_resolver.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_resolver.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_resolver.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_resolver.write_date IS 'Last Updated on';


--
-- Name: ir_exports_resolver_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_resolver_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_resolver_id_seq OWNER TO runbot;

--
-- Name: ir_exports_resolver_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_resolver_id_seq OWNED BY public.ir_exports_resolver.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer,
    domain text NOT NULL,
    context text NOT NULL,
    sort text NOT NULL,
    model_id character varying NOT NULL,
    is_default boolean,
    action_id integer,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_filters OWNER TO runbot;

--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.user_id IS 'User';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_filters_id_seq OWNER TO runbot;

--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    message text NOT NULL,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL
);


ALTER TABLE public.ir_logging OWNER TO runbot;

--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_logging_id_seq OWNER TO runbot;

--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying NOT NULL,
    smtp_port integer NOT NULL,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea,
    smtp_debug boolean,
    sequence integer,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_mail_server OWNER TO runbot;

--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Description';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'From Filter';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Security';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_mail_server_id_seq OWNER TO runbot;

--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    name character varying NOT NULL,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    info text,
    state character varying,
    transient boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    is_mail_thread boolean,
    is_mail_activity boolean,
    is_mail_blacklist boolean
);


ALTER TABLE public.ir_model OWNER TO runbot;

--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model.is_mail_thread; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_thread IS 'Mail Thread';


--
-- Name: COLUMN ir_model.is_mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_activity IS 'Mail Activity';


--
-- Name: COLUMN ir_model.is_mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_blacklist IS 'Mail Blacklist';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    name character varying NOT NULL,
    active boolean,
    model_id integer NOT NULL,
    group_id integer,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_access OWNER TO runbot;

--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_access_id_seq OWNER TO runbot;

--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    name character varying NOT NULL,
    definition character varying,
    message character varying,
    model integer NOT NULL,
    module integer NOT NULL,
    type character varying(1) NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone,
    create_uid integer,
    write_uid integer
);


ALTER TABLE public.ir_model_constraint OWNER TO runbot;

--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Create Date';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_constraint_id_seq OWNER TO runbot;

--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    res_id integer,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '% %'::text))
);


ALTER TABLE public.ir_model_data OWNER TO runbot;

--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''% %'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_data_id_seq OWNER TO runbot;

--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    name character varying NOT NULL,
    complete_name character varying,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    relation_field_id integer,
    model_id integer NOT NULL,
    field_description character varying NOT NULL,
    help text,
    ttype character varying NOT NULL,
    copied boolean,
    related character varying,
    related_field_id integer,
    required boolean,
    readonly boolean,
    index boolean,
    translate boolean,
    size integer,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    group_expand boolean,
    selectable boolean,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    compute text,
    depends character varying,
    store boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    serialization_field_id integer,
    tracking integer,
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


ALTER TABLE public.ir_model_fields OWNER TO runbot;

--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.complete_name IS 'Complete Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related field';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model_fields.serialization_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.serialization_field_id IS 'Serialization Field';


--
-- Name: COLUMN ir_model_fields.tracking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.tracking IS 'Enable Ordered Tracking';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_mis_report_query_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_mis_report_query_rel (
    mis_report_query_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_mis_report_query_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_mis_report_query_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_mis_report_query_rel IS 'RELATION BETWEEN mis_report_query AND ir_model_fields';


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    value character varying NOT NULL,
    name character varying NOT NULL,
    sequence integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_fields_selection OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_id_seq OWNER TO runbot;

--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    name character varying NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone,
    create_uid integer,
    write_uid integer
);


ALTER TABLE public.ir_model_relation OWNER TO runbot;

--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_relation_id_seq OWNER TO runbot;

--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_model_vacuum_rule_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_vacuum_rule_rel (
    vacuum_rule_id integer NOT NULL,
    ir_model_id integer NOT NULL
);


ALTER TABLE public.ir_model_vacuum_rule_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_vacuum_rule_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_vacuum_rule_rel IS 'RELATION BETWEEN vacuum_rule AND ir_model';


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name character varying NOT NULL,
    description text,
    sequence integer,
    visible boolean,
    exclusive boolean
);


ALTER TABLE public.ir_module_category OWNER TO runbot;

--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_category_id_seq OWNER TO runbot;

--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary character varying,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc character varying,
    category_id integer,
    description text,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    contributors text,
    published_version character varying,
    url character varying,
    menus_by_module text,
    reports_by_module text,
    views_by_module text
);


ALTER TABLE public.ir_module_module OWNER TO runbot;

--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


ALTER TABLE public.ir_module_module_dependency OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_module_module_exclusion OWNER TO runbot;

--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_profile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_profile (
    id integer NOT NULL,
    create_date timestamp without time zone,
    session character varying,
    name character varying,
    duration double precision,
    init_stack_trace text,
    sql text,
    traces_async text,
    traces_sync text,
    qweb text,
    entry_count integer
);


ALTER TABLE public.ir_profile OWNER TO runbot;

--
-- Name: TABLE ir_profile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_profile IS 'Profiling results';


--
-- Name: COLUMN ir_profile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.create_date IS 'Creation Date';


--
-- Name: COLUMN ir_profile.session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.session IS 'Session';


--
-- Name: COLUMN ir_profile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.name IS 'Description';


--
-- Name: COLUMN ir_profile.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.duration IS 'Duration';


--
-- Name: COLUMN ir_profile.init_stack_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.init_stack_trace IS 'Initial stack trace';


--
-- Name: COLUMN ir_profile.sql; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql IS 'Sql';


--
-- Name: COLUMN ir_profile.traces_async; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_async IS 'Traces Async';


--
-- Name: COLUMN ir_profile.traces_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_sync IS 'Traces Sync';


--
-- Name: COLUMN ir_profile.qweb; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.qweb IS 'Qweb';


--
-- Name: COLUMN ir_profile.entry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.entry_count IS 'Entry count';


--
-- Name: ir_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_profile_id_seq OWNER TO runbot;

--
-- Name: ir_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_profile_id_seq OWNED BY public.ir_profile.id;


--
-- Name: ir_property; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_property (
    id integer NOT NULL,
    name character varying,
    res_id character varying,
    company_id integer,
    fields_id integer NOT NULL,
    value_float double precision,
    value_integer integer,
    value_text text,
    value_binary bytea,
    value_reference character varying,
    value_datetime timestamp without time zone,
    type character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_property OWNER TO runbot;

--
-- Name: TABLE ir_property; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_property IS 'Company Property';


--
-- Name: COLUMN ir_property.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.name IS 'Name';


--
-- Name: COLUMN ir_property.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.res_id IS 'Resource';


--
-- Name: COLUMN ir_property.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.company_id IS 'Company';


--
-- Name: COLUMN ir_property.fields_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.fields_id IS 'Field';


--
-- Name: COLUMN ir_property.value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_float IS 'Value Float';


--
-- Name: COLUMN ir_property.value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_integer IS 'Value Integer';


--
-- Name: COLUMN ir_property.value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_text IS 'Value Text';


--
-- Name: COLUMN ir_property.value_binary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_binary IS 'Value Binary';


--
-- Name: COLUMN ir_property.value_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_reference IS 'Value Reference';


--
-- Name: COLUMN ir_property.value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_datetime IS 'Value Datetime';


--
-- Name: COLUMN ir_property.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.type IS 'Type';


--
-- Name: COLUMN ir_property.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.create_uid IS 'Created by';


--
-- Name: COLUMN ir_property.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.create_date IS 'Created on';


--
-- Name: COLUMN ir_property.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_property.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.write_date IS 'Last Updated on';


--
-- Name: ir_property_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_property_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_property_id_seq OWNER TO runbot;

--
-- Name: ir_property_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_property_id_seq OWNED BY public.ir_property.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    name character varying,
    active boolean,
    model_id integer NOT NULL,
    domain_force text,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    global boolean,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


ALTER TABLE public.ir_rule OWNER TO runbot;

--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Model';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Apply for Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Apply for Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Apply for Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Apply for Delete';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_rule_id_seq OWNER TO runbot;

--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    active boolean,
    prefix character varying,
    suffix character varying,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    use_date_range boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence OWNER TO runbot;

--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_001; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_001
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_001 OWNER TO runbot;

--
-- Name: ir_sequence_002; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_002
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_002 OWNER TO runbot;

--
-- Name: ir_sequence_003; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_003
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_003 OWNER TO runbot;

--
-- Name: ir_sequence_004; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_004
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_004 OWNER TO runbot;

--
-- Name: ir_sequence_005; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_005
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_005 OWNER TO runbot;

--
-- Name: ir_sequence_006; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_006
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_006 OWNER TO runbot;

--
-- Name: ir_sequence_007; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_007
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_007 OWNER TO runbot;

--
-- Name: ir_sequence_008; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_008
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_008 OWNER TO runbot;

--
-- Name: ir_sequence_009; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_009
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_009 OWNER TO runbot;

--
-- Name: ir_sequence_010; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_010
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_010 OWNER TO runbot;

--
-- Name: ir_sequence_011; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_011
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_011 OWNER TO runbot;

--
-- Name: ir_sequence_012; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_012
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_012 OWNER TO runbot;

--
-- Name: ir_sequence_013; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_013
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_013 OWNER TO runbot;

--
-- Name: ir_sequence_014; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_014
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_014 OWNER TO runbot;

--
-- Name: ir_sequence_015; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_015
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_015 OWNER TO runbot;

--
-- Name: ir_sequence_016; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_016
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_016 OWNER TO runbot;

--
-- Name: ir_sequence_017; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_017
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_017 OWNER TO runbot;

--
-- Name: ir_sequence_018; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_018
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_018 OWNER TO runbot;

--
-- Name: ir_sequence_019; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_019
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_019 OWNER TO runbot;

--
-- Name: ir_sequence_020; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_020
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_020 OWNER TO runbot;

--
-- Name: ir_sequence_021; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_021
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_021 OWNER TO runbot;

--
-- Name: ir_sequence_063; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_063
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_063 OWNER TO runbot;

--
-- Name: ir_sequence_064; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_064
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_064 OWNER TO runbot;

--
-- Name: ir_sequence_065; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_065
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_065 OWNER TO runbot;

--
-- Name: ir_sequence_066; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_066
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_066 OWNER TO runbot;

--
-- Name: ir_sequence_067; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_067
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_067 OWNER TO runbot;

--
-- Name: ir_sequence_068; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_068
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_068 OWNER TO runbot;

--
-- Name: ir_sequence_069; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_069
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_069 OWNER TO runbot;

--
-- Name: ir_sequence_153; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_153
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_153 OWNER TO runbot;

--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence_date_range OWNER TO runbot;

--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_server_object_lines; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_server_object_lines (
    id integer NOT NULL,
    server_id integer,
    col1 integer NOT NULL,
    value text NOT NULL,
    evaluation_type character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_server_object_lines OWNER TO runbot;

--
-- Name: TABLE ir_server_object_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_server_object_lines IS 'Server Action value mapping';


--
-- Name: COLUMN ir_server_object_lines.server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.server_id IS 'Related Server Action';


--
-- Name: COLUMN ir_server_object_lines.col1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.col1 IS 'Field';


--
-- Name: COLUMN ir_server_object_lines.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.value IS 'Value';


--
-- Name: COLUMN ir_server_object_lines.evaluation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.evaluation_type IS 'Evaluation Type';


--
-- Name: COLUMN ir_server_object_lines.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.create_uid IS 'Created by';


--
-- Name: COLUMN ir_server_object_lines.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.create_date IS 'Created on';


--
-- Name: COLUMN ir_server_object_lines.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_server_object_lines.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.write_date IS 'Last Updated on';


--
-- Name: ir_server_object_lines_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_server_object_lines_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_server_object_lines_id_seq OWNER TO runbot;

--
-- Name: ir_server_object_lines_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_server_object_lines_id_seq OWNED BY public.ir_server_object_lines.id;


--
-- Name: ir_translation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_translation (
    id integer NOT NULL,
    name character varying NOT NULL,
    res_id integer,
    lang character varying,
    type character varying,
    src text,
    value text,
    module character varying,
    state character varying,
    comments text
);


ALTER TABLE public.ir_translation OWNER TO runbot;

--
-- Name: TABLE ir_translation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_translation IS 'Translation';


--
-- Name: COLUMN ir_translation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.name IS 'Translated field';


--
-- Name: COLUMN ir_translation.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.res_id IS 'Record ID';


--
-- Name: COLUMN ir_translation.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.lang IS 'Language';


--
-- Name: COLUMN ir_translation.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.type IS 'Type';


--
-- Name: COLUMN ir_translation.src; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.src IS 'Internal Source';


--
-- Name: COLUMN ir_translation.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.value IS 'Translation Value';


--
-- Name: COLUMN ir_translation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.module IS 'Module';


--
-- Name: COLUMN ir_translation.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.state IS 'Status';


--
-- Name: COLUMN ir_translation.comments; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.comments IS 'Translation comments';


--
-- Name: ir_translation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_translation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_translation_id_seq OWNER TO runbot;

--
-- Name: ir_translation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_translation_id_seq OWNED BY public.ir_translation.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    name character varying NOT NULL,
    active boolean,
    sequence integer,
    parent_id integer,
    parent_path character varying,
    web_icon character varying,
    action character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_menu OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_path IS 'Parent Path';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_ui_menu_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_menu_id_seq OWNER TO runbot;

--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    priority integer NOT NULL,
    type character varying,
    arch_db text,
    arch_fs character varying,
    arch_updated boolean,
    arch_prev text,
    inherit_id integer,
    field_parent character varying,
    mode character varying NOT NULL,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    customize_show boolean,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


ALTER TABLE public.ir_ui_view OWNER TO runbot;

--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.field_parent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.field_parent IS 'Child Field';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_ui_view.customize_show; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.customize_show IS 'Show As Optional Inherit';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    arch text NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_view_custom OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_ui_view_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: journal_account_control_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.journal_account_control_rel (
    journal_id integer NOT NULL,
    account_id integer NOT NULL
);


ALTER TABLE public.journal_account_control_rel OWNER TO runbot;

--
-- Name: TABLE journal_account_control_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.journal_account_control_rel IS 'RELATION BETWEEN account_journal AND account_account';


--
-- Name: journal_account_type_control_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.journal_account_type_control_rel (
    journal_id integer NOT NULL,
    type_id integer NOT NULL
);


ALTER TABLE public.journal_account_type_control_rel OWNER TO runbot;

--
-- Name: TABLE journal_account_type_control_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.journal_account_type_control_rel IS 'RELATION BETWEEN account_journal AND account_account_type';


--
-- Name: journal_ledger_report_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.journal_ledger_report_wizard (
    id integer NOT NULL,
    company_id integer,
    date_range_id integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    move_target character varying NOT NULL,
    foreign_currency boolean,
    sort_option character varying NOT NULL,
    group_option character varying NOT NULL,
    with_account_name boolean,
    with_auto_sequence boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.journal_ledger_report_wizard OWNER TO runbot;

--
-- Name: TABLE journal_ledger_report_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.journal_ledger_report_wizard IS 'Journal Ledger Report Wizard';


--
-- Name: COLUMN journal_ledger_report_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.journal_ledger_report_wizard.company_id IS 'Company';


--
-- Name: COLUMN journal_ledger_report_wizard.date_range_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.journal_ledger_report_wizard.date_range_id IS 'Date range';


--
-- Name: COLUMN journal_ledger_report_wizard.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.journal_ledger_report_wizard.date_from IS 'Start date';


--
-- Name: COLUMN journal_ledger_report_wizard.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.journal_ledger_report_wizard.date_to IS 'End date';


--
-- Name: COLUMN journal_ledger_report_wizard.move_target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.journal_ledger_report_wizard.move_target IS 'Move Target';


--
-- Name: COLUMN journal_ledger_report_wizard.foreign_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.journal_ledger_report_wizard.foreign_currency IS 'Foreign Currency';


--
-- Name: COLUMN journal_ledger_report_wizard.sort_option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.journal_ledger_report_wizard.sort_option IS 'Sort entries by';


--
-- Name: COLUMN journal_ledger_report_wizard.group_option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.journal_ledger_report_wizard.group_option IS 'Group entries by';


--
-- Name: COLUMN journal_ledger_report_wizard.with_account_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.journal_ledger_report_wizard.with_account_name IS 'With Account Name';


--
-- Name: COLUMN journal_ledger_report_wizard.with_auto_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.journal_ledger_report_wizard.with_auto_sequence IS 'Show Auto Sequence';


--
-- Name: COLUMN journal_ledger_report_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.journal_ledger_report_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN journal_ledger_report_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.journal_ledger_report_wizard.create_date IS 'Created on';


--
-- Name: COLUMN journal_ledger_report_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.journal_ledger_report_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN journal_ledger_report_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.journal_ledger_report_wizard.write_date IS 'Last Updated on';


--
-- Name: journal_ledger_report_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.journal_ledger_report_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.journal_ledger_report_wizard_id_seq OWNER TO runbot;

--
-- Name: journal_ledger_report_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.journal_ledger_report_wizard_id_seq OWNED BY public.journal_ledger_report_wizard.id;


--
-- Name: mail_activity; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity (
    id integer NOT NULL,
    res_model_id integer NOT NULL,
    res_model character varying,
    res_id integer NOT NULL,
    res_name character varying,
    activity_type_id integer,
    summary character varying,
    note text,
    date_deadline date NOT NULL,
    automated boolean,
    user_id integer NOT NULL,
    request_partner_id integer,
    recommended_activity_type_id integer,
    previous_activity_type_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    calendar_event_id integer
);


ALTER TABLE public.mail_activity OWNER TO runbot;

--
-- Name: TABLE mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity IS 'Activity';


--
-- Name: COLUMN mail_activity.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model_id IS 'Document Model';


--
-- Name: COLUMN mail_activity.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_activity.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_activity.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_name IS 'Document Name';


--
-- Name: COLUMN mail_activity.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.summary IS 'Summary';


--
-- Name: COLUMN mail_activity.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.note IS 'Note';


--
-- Name: COLUMN mail_activity.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity.automated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.automated IS 'Automated activity';


--
-- Name: COLUMN mail_activity.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity.request_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.request_partner_id IS 'Requesting Partner';


--
-- Name: COLUMN mail_activity.recommended_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.recommended_activity_type_id IS 'Recommended Activity Type';


--
-- Name: COLUMN mail_activity.previous_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.previous_activity_type_id IS 'Previous Activity Type';


--
-- Name: COLUMN mail_activity.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_activity.calendar_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.calendar_event_id IS 'Calendar Meeting';


--
-- Name: mail_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_id_seq OWNER TO runbot;

--
-- Name: mail_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_id_seq OWNED BY public.mail_activity.id;


--
-- Name: mail_activity_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_rel (
    activity_id integer NOT NULL,
    recommended_id integer NOT NULL
);


ALTER TABLE public.mail_activity_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_rel IS 'RELATION BETWEEN mail_activity_type AND mail_activity_type';


--
-- Name: mail_activity_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type (
    id integer NOT NULL,
    name character varying NOT NULL,
    summary character varying,
    sequence integer,
    active boolean,
    create_uid integer,
    delay_count integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    icon character varying,
    decoration_type character varying,
    res_model character varying,
    triggered_next_type_id integer,
    chaining_type character varying NOT NULL,
    category character varying,
    default_user_id integer,
    default_note text,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_type OWNER TO runbot;

--
-- Name: TABLE mail_activity_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type IS 'Activity Type';


--
-- Name: COLUMN mail_activity_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.name IS 'Name';


--
-- Name: COLUMN mail_activity_type.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.summary IS 'Default Summary';


--
-- Name: COLUMN mail_activity_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.active IS 'Active';


--
-- Name: COLUMN mail_activity_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_uid IS 'Create Uid';


--
-- Name: COLUMN mail_activity_type.delay_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_count IS 'Schedule';


--
-- Name: COLUMN mail_activity_type.delay_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_type.delay_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_from IS 'Delay Type';


--
-- Name: COLUMN mail_activity_type.icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.icon IS 'Icon';


--
-- Name: COLUMN mail_activity_type.decoration_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.decoration_type IS 'Decoration Type';


--
-- Name: COLUMN mail_activity_type.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_type.triggered_next_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.triggered_next_type_id IS 'Trigger';


--
-- Name: COLUMN mail_activity_type.chaining_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.chaining_type IS 'Chaining Type';


--
-- Name: COLUMN mail_activity_type.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.category IS 'Action';


--
-- Name: COLUMN mail_activity_type.default_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_user_id IS 'Default User';


--
-- Name: COLUMN mail_activity_type.default_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_note IS 'Default Note';


--
-- Name: COLUMN mail_activity_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_date IS 'Last Updated on';


--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_type_id_seq OWNER TO runbot;

--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_type_id_seq OWNED BY public.mail_activity_type.id;


--
-- Name: mail_activity_type_mail_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type_mail_template_rel (
    mail_activity_type_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_activity_type_mail_template_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_type_mail_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type_mail_template_rel IS 'RELATION BETWEEN mail_activity_type AND mail_template';


--
-- Name: mail_alias; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_alias (
    id integer NOT NULL,
    alias_name character varying,
    alias_model_id integer NOT NULL,
    alias_user_id integer,
    alias_defaults text NOT NULL,
    alias_force_thread_id integer,
    alias_parent_model_id integer,
    alias_parent_thread_id integer,
    alias_contact character varying NOT NULL,
    alias_bounced_content text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_alias OWNER TO runbot;

--
-- Name: TABLE mail_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_alias IS 'Email Aliases';


--
-- Name: COLUMN mail_alias.alias_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_name IS 'Alias Name';


--
-- Name: COLUMN mail_alias.alias_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_model_id IS 'Aliased Model';


--
-- Name: COLUMN mail_alias.alias_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_user_id IS 'Owner';


--
-- Name: COLUMN mail_alias.alias_defaults; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_defaults IS 'Default Values';


--
-- Name: COLUMN mail_alias.alias_force_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_force_thread_id IS 'Record Thread ID';


--
-- Name: COLUMN mail_alias.alias_parent_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_model_id IS 'Parent Model';


--
-- Name: COLUMN mail_alias.alias_parent_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_thread_id IS 'Parent Record Thread ID';


--
-- Name: COLUMN mail_alias.alias_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_contact IS 'Alias Contact Security';


--
-- Name: COLUMN mail_alias.alias_bounced_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_bounced_content IS 'Custom Bounced Message';


--
-- Name: COLUMN mail_alias.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_date IS 'Last Updated on';


--
-- Name: mail_alias_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_alias_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_alias_id_seq OWNER TO runbot;

--
-- Name: mail_alias_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_alias_id_seq OWNED BY public.mail_alias.id;


--
-- Name: mail_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist (
    id integer NOT NULL,
    message_main_attachment_id integer,
    email character varying NOT NULL,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist OWNER TO runbot;

--
-- Name: TABLE mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist IS 'Mail Blacklist';


--
-- Name: COLUMN mail_blacklist.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN mail_blacklist.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.email IS 'Email Address';


--
-- Name: COLUMN mail_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.active IS 'Active';


--
-- Name: COLUMN mail_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_id_seq OWNED BY public.mail_blacklist.id;


--
-- Name: mail_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist_remove (
    id integer NOT NULL,
    email character varying NOT NULL,
    reason character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE mail_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist_remove IS 'Remove email from blacklist wizard';


--
-- Name: COLUMN mail_blacklist_remove.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.email IS 'Email';


--
-- Name: COLUMN mail_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN mail_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNED BY public.mail_blacklist_remove.id;


--
-- Name: mail_channel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_channel (
    id integer NOT NULL,
    alias_id integer NOT NULL,
    message_main_attachment_id integer,
    name character varying NOT NULL,
    active boolean,
    channel_type character varying,
    default_display_mode character varying,
    description text,
    uuid character varying(50),
    public character varying NOT NULL,
    group_public_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_channel OWNER TO runbot;

--
-- Name: TABLE mail_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_channel IS 'Discussion Channel';


--
-- Name: COLUMN mail_channel.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.alias_id IS 'Alias';


--
-- Name: COLUMN mail_channel.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN mail_channel.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.name IS 'Name';


--
-- Name: COLUMN mail_channel.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.active IS 'Active';


--
-- Name: COLUMN mail_channel.channel_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.channel_type IS 'Channel Type';


--
-- Name: COLUMN mail_channel.default_display_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.default_display_mode IS 'Default Display Mode';


--
-- Name: COLUMN mail_channel.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.description IS 'Description';


--
-- Name: COLUMN mail_channel.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.uuid IS 'UUID';


--
-- Name: COLUMN mail_channel.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.public IS 'Privacy';


--
-- Name: COLUMN mail_channel.group_public_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.group_public_id IS 'Authorized Group';


--
-- Name: COLUMN mail_channel.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.create_uid IS 'Created by';


--
-- Name: COLUMN mail_channel.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.create_date IS 'Created on';


--
-- Name: COLUMN mail_channel.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_channel.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.write_date IS 'Last Updated on';


--
-- Name: mail_channel_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_channel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_channel_id_seq OWNER TO runbot;

--
-- Name: mail_channel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_channel_id_seq OWNED BY public.mail_channel.id;


--
-- Name: mail_channel_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_channel_partner (
    id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    channel_id integer NOT NULL,
    custom_channel_name character varying,
    fetched_message_id integer,
    seen_message_id integer,
    fold_state character varying,
    is_minimized boolean,
    is_pinned boolean,
    last_interest_dt timestamp without time zone,
    rtc_inviting_session_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT mail_channel_partner_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.mail_channel_partner OWNER TO runbot;

--
-- Name: TABLE mail_channel_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_channel_partner IS 'Listeners of a Channel';


--
-- Name: COLUMN mail_channel_partner.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_partner.partner_id IS 'Recipient';


--
-- Name: COLUMN mail_channel_partner.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_partner.guest_id IS 'Guest';


--
-- Name: COLUMN mail_channel_partner.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_partner.channel_id IS 'Channel';


--
-- Name: COLUMN mail_channel_partner.custom_channel_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_partner.custom_channel_name IS 'Custom channel name';


--
-- Name: COLUMN mail_channel_partner.fetched_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_partner.fetched_message_id IS 'Last Fetched';


--
-- Name: COLUMN mail_channel_partner.seen_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_partner.seen_message_id IS 'Last Seen';


--
-- Name: COLUMN mail_channel_partner.fold_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_partner.fold_state IS 'Conversation Fold State';


--
-- Name: COLUMN mail_channel_partner.is_minimized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_partner.is_minimized IS 'Conversation is minimized';


--
-- Name: COLUMN mail_channel_partner.is_pinned; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_partner.is_pinned IS 'Is pinned on the interface';


--
-- Name: COLUMN mail_channel_partner.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_partner.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN mail_channel_partner.rtc_inviting_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_partner.rtc_inviting_session_id IS 'Ringing session';


--
-- Name: COLUMN mail_channel_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_partner.create_uid IS 'Created by';


--
-- Name: COLUMN mail_channel_partner.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_partner.create_date IS 'Created on';


--
-- Name: COLUMN mail_channel_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_channel_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_partner.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT mail_channel_partner_partner_or_guest_exists ON mail_channel_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_channel_partner_partner_or_guest_exists ON public.mail_channel_partner IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: mail_channel_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_channel_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_channel_partner_id_seq OWNER TO runbot;

--
-- Name: mail_channel_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_channel_partner_id_seq OWNED BY public.mail_channel_partner.id;


--
-- Name: mail_channel_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_channel_res_groups_rel (
    mail_channel_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.mail_channel_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE mail_channel_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_channel_res_groups_rel IS 'RELATION BETWEEN mail_channel AND res_groups';


--
-- Name: mail_channel_rtc_session; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_channel_rtc_session (
    id integer NOT NULL,
    channel_partner_id integer NOT NULL,
    channel_id integer,
    write_date timestamp without time zone,
    is_screen_sharing_on boolean,
    is_camera_on boolean,
    is_muted boolean,
    is_deaf boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer
);


ALTER TABLE public.mail_channel_rtc_session OWNER TO runbot;

--
-- Name: TABLE mail_channel_rtc_session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_channel_rtc_session IS 'Mail RTC session';


--
-- Name: COLUMN mail_channel_rtc_session.channel_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.channel_partner_id IS 'Channel Partner';


--
-- Name: COLUMN mail_channel_rtc_session.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.channel_id IS 'Channel';


--
-- Name: COLUMN mail_channel_rtc_session.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.write_date IS 'Last Updated On';


--
-- Name: COLUMN mail_channel_rtc_session.is_screen_sharing_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.is_screen_sharing_on IS 'Is sharing the screen';


--
-- Name: COLUMN mail_channel_rtc_session.is_camera_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.is_camera_on IS 'Is sending user video';


--
-- Name: COLUMN mail_channel_rtc_session.is_muted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.is_muted IS 'Is microphone muted';


--
-- Name: COLUMN mail_channel_rtc_session.is_deaf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.is_deaf IS 'Has disabled incoming sound';


--
-- Name: COLUMN mail_channel_rtc_session.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.create_uid IS 'Created by';


--
-- Name: COLUMN mail_channel_rtc_session.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.create_date IS 'Created on';


--
-- Name: COLUMN mail_channel_rtc_session.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.write_uid IS 'Last Updated by';


--
-- Name: mail_channel_rtc_session_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_channel_rtc_session_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_channel_rtc_session_id_seq OWNER TO runbot;

--
-- Name: mail_channel_rtc_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_channel_rtc_session_id_seq OWNED BY public.mail_channel_rtc_session.id;


--
-- Name: mail_compose_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message (
    id integer NOT NULL,
    lang character varying,
    subject character varying,
    body text,
    template_id integer,
    parent_id integer,
    layout character varying,
    add_sign boolean,
    email_from character varying,
    author_id integer,
    composition_mode character varying,
    model character varying,
    res_id integer,
    record_name character varying,
    use_active_domain boolean,
    active_domain text,
    message_type character varying NOT NULL,
    subtype_id integer,
    mail_activity_type_id integer,
    reply_to character varying,
    reply_to_force_new boolean,
    is_log boolean,
    notify boolean,
    auto_delete boolean,
    auto_delete_message boolean,
    mail_server_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_compose_message OWNER TO runbot;

--
-- Name: TABLE mail_compose_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message IS 'Email composition wizard';


--
-- Name: COLUMN mail_compose_message.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.lang IS 'Language';


--
-- Name: COLUMN mail_compose_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subject IS 'Subject';


--
-- Name: COLUMN mail_compose_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.body IS 'Contents';


--
-- Name: COLUMN mail_compose_message.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.template_id IS 'Use template';


--
-- Name: COLUMN mail_compose_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_compose_message.layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.layout IS 'Layout';


--
-- Name: COLUMN mail_compose_message.add_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.add_sign IS 'Add Sign';


--
-- Name: COLUMN mail_compose_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_from IS 'From';


--
-- Name: COLUMN mail_compose_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.author_id IS 'Author';


--
-- Name: COLUMN mail_compose_message.composition_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.composition_mode IS 'Composition mode';


--
-- Name: COLUMN mail_compose_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_compose_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_compose_message.record_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_name IS 'Message Record Name';


--
-- Name: COLUMN mail_compose_message.use_active_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.use_active_domain IS 'Use active domain';


--
-- Name: COLUMN mail_compose_message.active_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.active_domain IS 'Active domain';


--
-- Name: COLUMN mail_compose_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.message_type IS 'Type';


--
-- Name: COLUMN mail_compose_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_compose_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_compose_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_compose_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to_force_new IS 'Considers answers as new thread';


--
-- Name: COLUMN mail_compose_message.is_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.is_log IS 'Log an Internal Note';


--
-- Name: COLUMN mail_compose_message.notify; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.notify IS 'Notify followers';


--
-- Name: COLUMN mail_compose_message.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete IS 'Delete Emails';


--
-- Name: COLUMN mail_compose_message.auto_delete_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete_message IS 'Delete Message Copy';


--
-- Name: COLUMN mail_compose_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_compose_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_compose_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_compose_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_compose_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_date IS 'Last Updated on';


--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_compose_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_compose_message_id_seq OWNER TO runbot;

--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_compose_message_id_seq OWNED BY public.mail_compose_message.id;


--
-- Name: mail_compose_message_ir_attachments_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_ir_attachments_rel (
    wizard_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_ir_attachments_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_ir_attachments_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_ir_attachments_rel IS 'RELATION BETWEEN mail_compose_message AND ir_attachment';


--
-- Name: mail_compose_message_res_partner_bcc_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_res_partner_bcc_rel (
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_res_partner_bcc_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_res_partner_bcc_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_res_partner_bcc_rel IS 'RELATION BETWEEN mail_compose_message AND res_partner';


--
-- Name: mail_compose_message_res_partner_cc_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_res_partner_cc_rel (
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_res_partner_cc_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_res_partner_cc_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_res_partner_cc_rel IS 'RELATION BETWEEN mail_compose_message AND res_partner';


--
-- Name: mail_compose_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_res_partner_rel (
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_res_partner_rel IS 'RELATION BETWEEN mail_compose_message AND res_partner';


--
-- Name: mail_followers; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers (
    id integer NOT NULL,
    res_model character varying NOT NULL,
    res_id integer,
    partner_id integer NOT NULL
);


ALTER TABLE public.mail_followers OWNER TO runbot;

--
-- Name: TABLE mail_followers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers IS 'Document Followers';


--
-- Name: COLUMN mail_followers.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_model IS 'Related Document Model Name';


--
-- Name: COLUMN mail_followers.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_followers.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.partner_id IS 'Related Partner';


--
-- Name: mail_followers_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_followers_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_followers_id_seq OWNER TO runbot;

--
-- Name: mail_followers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_followers_id_seq OWNED BY public.mail_followers.id;


--
-- Name: mail_followers_mail_message_subtype_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_mail_message_subtype_rel (
    mail_followers_id integer NOT NULL,
    mail_message_subtype_id integer NOT NULL
);


ALTER TABLE public.mail_followers_mail_message_subtype_rel OWNER TO runbot;

--
-- Name: TABLE mail_followers_mail_message_subtype_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_mail_message_subtype_rel IS 'RELATION BETWEEN mail_followers AND mail_message_subtype';


--
-- Name: mail_guest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_guest (
    id integer NOT NULL,
    name character varying NOT NULL,
    access_token character varying NOT NULL,
    country_id integer,
    lang character varying,
    timezone character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_guest OWNER TO runbot;

--
-- Name: TABLE mail_guest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_guest IS 'Guest';


--
-- Name: COLUMN mail_guest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.name IS 'Name';


--
-- Name: COLUMN mail_guest.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.access_token IS 'Access Token';


--
-- Name: COLUMN mail_guest.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.country_id IS 'Country';


--
-- Name: COLUMN mail_guest.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.lang IS 'Language';


--
-- Name: COLUMN mail_guest.timezone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.timezone IS 'Timezone';


--
-- Name: COLUMN mail_guest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_uid IS 'Created by';


--
-- Name: COLUMN mail_guest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_date IS 'Created on';


--
-- Name: COLUMN mail_guest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_guest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_date IS 'Last Updated on';


--
-- Name: mail_guest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_guest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_guest_id_seq OWNER TO runbot;

--
-- Name: mail_guest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_guest_id_seq OWNED BY public.mail_guest.id;


--
-- Name: mail_ice_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_ice_server (
    id integer NOT NULL,
    server_type character varying NOT NULL,
    uri character varying NOT NULL,
    username character varying,
    credential character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_ice_server OWNER TO runbot;

--
-- Name: TABLE mail_ice_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_ice_server IS 'ICE server';


--
-- Name: COLUMN mail_ice_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.server_type IS 'Type';


--
-- Name: COLUMN mail_ice_server.uri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.uri IS 'URI';


--
-- Name: COLUMN mail_ice_server.username; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.username IS 'Username';


--
-- Name: COLUMN mail_ice_server.credential; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.credential IS 'Credential';


--
-- Name: COLUMN mail_ice_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_uid IS 'Created by';


--
-- Name: COLUMN mail_ice_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_date IS 'Created on';


--
-- Name: COLUMN mail_ice_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_ice_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_date IS 'Last Updated on';


--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_ice_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_ice_server_id_seq OWNER TO runbot;

--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_ice_server_id_seq OWNED BY public.mail_ice_server.id;


--
-- Name: mail_mail; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    body_html text,
    "references" text,
    headers text,
    is_notification boolean,
    email_to text,
    email_cc character varying,
    state character varying,
    failure_type character varying,
    failure_reason text,
    auto_delete boolean,
    scheduled_date character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    fetchmail_server_id integer,
    email_bcc character varying
);


ALTER TABLE public.mail_mail OWNER TO runbot;

--
-- Name: TABLE mail_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail IS 'Outgoing Mails';


--
-- Name: COLUMN mail_mail.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_mail.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.body_html IS 'Rich-text Contents';


--
-- Name: COLUMN mail_mail."references"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail."references" IS 'References';


--
-- Name: COLUMN mail_mail.headers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.headers IS 'Headers';


--
-- Name: COLUMN mail_mail.is_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.is_notification IS 'Notification Email';


--
-- Name: COLUMN mail_mail.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_to IS 'To';


--
-- Name: COLUMN mail_mail.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_cc IS 'Cc';


--
-- Name: COLUMN mail_mail.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.state IS 'Status';


--
-- Name: COLUMN mail_mail.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_mail.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_reason IS 'Failure Reason';


--
-- Name: COLUMN mail_mail.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_mail.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.scheduled_date IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_mail.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_uid IS 'Created by';


--
-- Name: COLUMN mail_mail.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_date IS 'Created on';


--
-- Name: COLUMN mail_mail.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_mail.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_mail.fetchmail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.fetchmail_server_id IS 'Inbound Mail Server';


--
-- Name: COLUMN mail_mail.email_bcc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_bcc IS 'Bcc';


--
-- Name: mail_mail_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_mail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_mail_id_seq OWNER TO runbot;

--
-- Name: mail_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_mail_id_seq OWNED BY public.mail_mail.id;


--
-- Name: mail_mail_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail_res_partner_rel (
    mail_mail_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_mail_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_mail_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail_res_partner_rel IS 'RELATION BETWEEN mail_mail AND res_partner';


--
-- Name: mail_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message (
    id integer NOT NULL,
    subject character varying,
    date timestamp without time zone,
    body text,
    parent_id integer,
    model character varying,
    res_id integer,
    record_name character varying,
    message_type character varying NOT NULL,
    subtype_id integer,
    mail_activity_type_id integer,
    is_internal boolean,
    email_from character varying,
    author_id integer,
    author_guest_id integer,
    reply_to_force_new boolean,
    message_id character varying,
    reply_to character varying,
    mail_server_id integer,
    email_layout_xmlid character varying,
    add_sign boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message OWNER TO runbot;

--
-- Name: TABLE mail_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message IS 'Message';


--
-- Name: COLUMN mail_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subject IS 'Subject';


--
-- Name: COLUMN mail_message.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.date IS 'Date';


--
-- Name: COLUMN mail_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.body IS 'Contents';


--
-- Name: COLUMN mail_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_message.record_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_name IS 'Message Record Name';


--
-- Name: COLUMN mail_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_type IS 'Type';


--
-- Name: COLUMN mail_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_message.is_internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.is_internal IS 'Employee Only';


--
-- Name: COLUMN mail_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_from IS 'From';


--
-- Name: COLUMN mail_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_id IS 'Author';


--
-- Name: COLUMN mail_message.author_guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_guest_id IS 'Guest';


--
-- Name: COLUMN mail_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to_force_new IS 'No threading for answers';


--
-- Name: COLUMN mail_message.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_id IS 'Message-Id';


--
-- Name: COLUMN mail_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_layout_xmlid IS 'Layout';


--
-- Name: COLUMN mail_message.add_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.add_sign IS 'Add Sign';


--
-- Name: COLUMN mail_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_date IS 'Last Updated on';


--
-- Name: mail_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_id_seq OWNER TO runbot;

--
-- Name: mail_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_id_seq OWNED BY public.mail_message.id;


--
-- Name: mail_message_reaction; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_reaction (
    id integer NOT NULL,
    message_id integer NOT NULL,
    content character varying NOT NULL,
    partner_id integer,
    guest_id integer,
    CONSTRAINT mail_message_reaction_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.mail_message_reaction OWNER TO runbot;

--
-- Name: TABLE mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_reaction IS 'Message Reaction';


--
-- Name: COLUMN mail_message_reaction.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.message_id IS 'Message';


--
-- Name: COLUMN mail_message_reaction.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.content IS 'Content';


--
-- Name: COLUMN mail_message_reaction.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.partner_id IS 'Reacting Partner';


--
-- Name: COLUMN mail_message_reaction.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.guest_id IS 'Reacting Guest';


--
-- Name: CONSTRAINT mail_message_reaction_partner_or_guest_exists ON mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_message_reaction_partner_or_guest_exists ON public.mail_message_reaction IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_reaction_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_reaction_id_seq OWNER TO runbot;

--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_reaction_id_seq OWNED BY public.mail_message_reaction.id;


--
-- Name: mail_message_res_partner_bcc_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_bcc_rel (
    mail_message_id integer NOT NULL,
    parent_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_bcc_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_bcc_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_bcc_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_res_partner_cc_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_cc_rel (
    mail_message_id integer NOT NULL,
    parent_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_cc_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_cc_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_cc_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_res_partner_starred_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_starred_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_starred_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_starred_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_starred_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_subtype; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_subtype (
    id integer NOT NULL,
    name character varying NOT NULL,
    description text,
    internal boolean,
    parent_id integer,
    relation_field character varying,
    res_model character varying,
    "default" boolean,
    sequence integer,
    hidden boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_subtype OWNER TO runbot;

--
-- Name: TABLE mail_message_subtype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_subtype IS 'Message subtypes';


--
-- Name: COLUMN mail_message_subtype.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.name IS 'Message Type';


--
-- Name: COLUMN mail_message_subtype.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.description IS 'Description';


--
-- Name: COLUMN mail_message_subtype.internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.internal IS 'Internal Only';


--
-- Name: COLUMN mail_message_subtype.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.parent_id IS 'Parent';


--
-- Name: COLUMN mail_message_subtype.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.relation_field IS 'Relation field';


--
-- Name: COLUMN mail_message_subtype.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.res_model IS 'Model';


--
-- Name: COLUMN mail_message_subtype."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype."default" IS 'Default';


--
-- Name: COLUMN mail_message_subtype.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.sequence IS 'Sequence';


--
-- Name: COLUMN mail_message_subtype.hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.hidden IS 'Hidden';


--
-- Name: COLUMN mail_message_subtype.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_subtype.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_subtype.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_subtype.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_date IS 'Last Updated on';


--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_subtype_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_subtype_id_seq OWNER TO runbot;

--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_subtype_id_seq OWNED BY public.mail_message_subtype.id;


--
-- Name: mail_message_subtype_vacuum_rule_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_subtype_vacuum_rule_rel (
    vacuum_rule_id integer NOT NULL,
    mail_message_subtype_id integer NOT NULL
);


ALTER TABLE public.mail_message_subtype_vacuum_rule_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_subtype_vacuum_rule_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_subtype_vacuum_rule_rel IS 'RELATION BETWEEN vacuum_rule AND mail_message_subtype';


--
-- Name: mail_notification; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_notification (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    mail_mail_id integer,
    res_partner_id integer,
    notification_type character varying NOT NULL,
    notification_status character varying,
    is_read boolean,
    read_date timestamp without time zone,
    failure_type character varying,
    failure_reason text,
    sms_id integer,
    sms_number character varying,
    letter_id integer,
    CONSTRAINT mail_notification_notification_partner_required CHECK ((((notification_type)::text <> ALL ((ARRAY['email'::character varying, 'inbox'::character varying])::text[])) OR (res_partner_id IS NOT NULL)))
);


ALTER TABLE public.mail_notification OWNER TO runbot;

--
-- Name: TABLE mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_notification IS 'Message Notifications';


--
-- Name: COLUMN mail_notification.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_notification.mail_mail_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_mail_id IS 'Mail';


--
-- Name: COLUMN mail_notification.res_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.res_partner_id IS 'Recipient';


--
-- Name: COLUMN mail_notification.notification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_type IS 'Notification Type';


--
-- Name: COLUMN mail_notification.notification_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_status IS 'Status';


--
-- Name: COLUMN mail_notification.is_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.is_read IS 'Is Read';


--
-- Name: COLUMN mail_notification.read_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.read_date IS 'Read Date';


--
-- Name: COLUMN mail_notification.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_notification.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_reason IS 'Failure reason';


--
-- Name: COLUMN mail_notification.sms_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.sms_id IS 'SMS';


--
-- Name: COLUMN mail_notification.sms_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.sms_number IS 'SMS Number';


--
-- Name: COLUMN mail_notification.letter_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.letter_id IS 'Snailmail Letter';


--
-- Name: CONSTRAINT mail_notification_notification_partner_required ON mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_notification_notification_partner_required ON public.mail_notification IS 'CHECK(notification_type NOT IN (''email'', ''inbox'') OR res_partner_id IS NOT NULL)';


--
-- Name: mail_notification_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_notification_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_notification_id_seq OWNER TO runbot;

--
-- Name: mail_notification_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_notification_id_seq OWNED BY public.mail_notification.id;


--
-- Name: mail_notification_mail_resend_message_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_notification_mail_resend_message_rel (
    mail_resend_message_id integer NOT NULL,
    mail_notification_id integer NOT NULL
);


ALTER TABLE public.mail_notification_mail_resend_message_rel OWNER TO runbot;

--
-- Name: TABLE mail_notification_mail_resend_message_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_notification_mail_resend_message_rel IS 'RELATION BETWEEN mail_resend_message AND mail_notification';


--
-- Name: mail_resend_cancel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_resend_cancel (
    id integer NOT NULL,
    model character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_resend_cancel OWNER TO runbot;

--
-- Name: TABLE mail_resend_cancel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_resend_cancel IS 'Dismiss notification for resend by model';


--
-- Name: COLUMN mail_resend_cancel.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_cancel.model IS 'Model';


--
-- Name: COLUMN mail_resend_cancel.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_cancel.create_uid IS 'Created by';


--
-- Name: COLUMN mail_resend_cancel.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_cancel.create_date IS 'Created on';


--
-- Name: COLUMN mail_resend_cancel.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_cancel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_resend_cancel.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_cancel.write_date IS 'Last Updated on';


--
-- Name: mail_resend_cancel_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_resend_cancel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_resend_cancel_id_seq OWNER TO runbot;

--
-- Name: mail_resend_cancel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_resend_cancel_id_seq OWNED BY public.mail_resend_cancel.id;


--
-- Name: mail_resend_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_resend_message (
    id integer NOT NULL,
    mail_message_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_resend_message OWNER TO runbot;

--
-- Name: TABLE mail_resend_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_resend_message IS 'Email resend wizard';


--
-- Name: COLUMN mail_resend_message.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_resend_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_resend_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_resend_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_resend_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.write_date IS 'Last Updated on';


--
-- Name: mail_resend_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_resend_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_resend_message_id_seq OWNER TO runbot;

--
-- Name: mail_resend_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_resend_message_id_seq OWNED BY public.mail_resend_message.id;


--
-- Name: mail_resend_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_resend_partner (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    resend boolean,
    resend_wizard_id integer,
    message character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_resend_partner OWNER TO runbot;

--
-- Name: TABLE mail_resend_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_resend_partner IS 'Partner with additional information for mail resend';


--
-- Name: COLUMN mail_resend_partner.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.partner_id IS 'Partner';


--
-- Name: COLUMN mail_resend_partner.resend; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.resend IS 'Send Again';


--
-- Name: COLUMN mail_resend_partner.resend_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.resend_wizard_id IS 'Resend wizard';


--
-- Name: COLUMN mail_resend_partner.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.message IS 'Help message';


--
-- Name: COLUMN mail_resend_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.create_uid IS 'Created by';


--
-- Name: COLUMN mail_resend_partner.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.create_date IS 'Created on';


--
-- Name: COLUMN mail_resend_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_resend_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.write_date IS 'Last Updated on';


--
-- Name: mail_resend_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_resend_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_resend_partner_id_seq OWNER TO runbot;

--
-- Name: mail_resend_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_resend_partner_id_seq OWNED BY public.mail_resend_partner.id;


--
-- Name: mail_shortcode; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_shortcode (
    id integer NOT NULL,
    source character varying NOT NULL,
    substitution text NOT NULL,
    description character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_shortcode OWNER TO runbot;

--
-- Name: TABLE mail_shortcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_shortcode IS 'Canned Response / Shortcode';


--
-- Name: COLUMN mail_shortcode.source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_shortcode.source IS 'Shortcut';


--
-- Name: COLUMN mail_shortcode.substitution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_shortcode.substitution IS 'Substitution';


--
-- Name: COLUMN mail_shortcode.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_shortcode.description IS 'Description';


--
-- Name: COLUMN mail_shortcode.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_shortcode.create_uid IS 'Created by';


--
-- Name: COLUMN mail_shortcode.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_shortcode.create_date IS 'Created on';


--
-- Name: COLUMN mail_shortcode.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_shortcode.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_shortcode.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_shortcode.write_date IS 'Last Updated on';


--
-- Name: mail_shortcode_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_shortcode_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_shortcode_id_seq OWNER TO runbot;

--
-- Name: mail_shortcode_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_shortcode_id_seq OWNED BY public.mail_shortcode.id;


--
-- Name: mail_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template (
    id integer NOT NULL,
    lang character varying,
    name character varying,
    model_id integer,
    model character varying,
    subject character varying,
    email_from character varying,
    use_default_to boolean,
    email_to character varying,
    partner_to character varying,
    email_cc character varying,
    reply_to character varying,
    body_html text,
    report_name character varying,
    report_template integer,
    mail_server_id integer,
    scheduled_date character varying,
    auto_delete boolean,
    ref_ir_act_window integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    email_bcc character varying
);


ALTER TABLE public.mail_template OWNER TO runbot;

--
-- Name: TABLE mail_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template IS 'Email Templates';


--
-- Name: COLUMN mail_template.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.lang IS 'Language';


--
-- Name: COLUMN mail_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.name IS 'Name';


--
-- Name: COLUMN mail_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model_id IS 'Applies to';


--
-- Name: COLUMN mail_template.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model IS 'Related Document Model';


--
-- Name: COLUMN mail_template.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.subject IS 'Subject';


--
-- Name: COLUMN mail_template.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_from IS 'From';


--
-- Name: COLUMN mail_template.use_default_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.use_default_to IS 'Default recipients';


--
-- Name: COLUMN mail_template.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_to IS 'To (Emails)';


--
-- Name: COLUMN mail_template.partner_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.partner_to IS 'To (Partners)';


--
-- Name: COLUMN mail_template.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_cc IS 'Cc';


--
-- Name: COLUMN mail_template.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_template.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.body_html IS 'Body';


--
-- Name: COLUMN mail_template.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.report_name IS 'Report Filename';


--
-- Name: COLUMN mail_template.report_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.report_template IS 'Optional report to print and attach';


--
-- Name: COLUMN mail_template.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.mail_server_id IS 'Outgoing Mail Server';


--
-- Name: COLUMN mail_template.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_template.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_template.ref_ir_act_window; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.ref_ir_act_window IS 'Sidebar action';


--
-- Name: COLUMN mail_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_template.email_bcc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_bcc IS 'Bcc';


--
-- Name: mail_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_id_seq OWNER TO runbot;

--
-- Name: mail_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_id_seq OWNED BY public.mail_template.id;


--
-- Name: mail_template_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_preview (
    id integer NOT NULL,
    mail_template_id integer NOT NULL,
    resource_ref character varying,
    lang character varying,
    error_msg character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_preview OWNER TO runbot;

--
-- Name: TABLE mail_template_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_preview IS 'Email Template Preview';


--
-- Name: COLUMN mail_template_preview.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.mail_template_id IS 'Related Mail Template';


--
-- Name: COLUMN mail_template_preview.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.resource_ref IS 'Record';


--
-- Name: COLUMN mail_template_preview.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.lang IS 'Template Preview Language';


--
-- Name: COLUMN mail_template_preview.error_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.error_msg IS 'Error Message';


--
-- Name: COLUMN mail_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_date IS 'Last Updated on';


--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_preview_id_seq OWNER TO runbot;

--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_preview_id_seq OWNED BY public.mail_template_preview.id;


--
-- Name: mail_tracking_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_tracking_value (
    id integer NOT NULL,
    field integer NOT NULL,
    field_desc character varying NOT NULL,
    field_type character varying,
    old_value_integer integer,
    old_value_float double precision,
    old_value_monetary double precision,
    old_value_char character varying,
    old_value_text text,
    old_value_datetime timestamp without time zone,
    new_value_integer integer,
    new_value_float double precision,
    new_value_monetary double precision,
    new_value_char character varying,
    new_value_text text,
    new_value_datetime timestamp without time zone,
    currency_id integer,
    mail_message_id integer NOT NULL,
    tracking_sequence integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_tracking_value OWNER TO runbot;

--
-- Name: TABLE mail_tracking_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_tracking_value IS 'Mail Tracking Value';


--
-- Name: COLUMN mail_tracking_value.field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field IS 'Field';


--
-- Name: COLUMN mail_tracking_value.field_desc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_desc IS 'Field Description';


--
-- Name: COLUMN mail_tracking_value.field_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_type IS 'Field Type';


--
-- Name: COLUMN mail_tracking_value.old_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_integer IS 'Old Value Integer';


--
-- Name: COLUMN mail_tracking_value.old_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_float IS 'Old Value Float';


--
-- Name: COLUMN mail_tracking_value.old_value_monetary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_monetary IS 'Old Value Monetary';


--
-- Name: COLUMN mail_tracking_value.old_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_char IS 'Old Value Char';


--
-- Name: COLUMN mail_tracking_value.old_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_text IS 'Old Value Text';


--
-- Name: COLUMN mail_tracking_value.old_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_datetime IS 'Old Value DateTime';


--
-- Name: COLUMN mail_tracking_value.new_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_integer IS 'New Value Integer';


--
-- Name: COLUMN mail_tracking_value.new_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_float IS 'New Value Float';


--
-- Name: COLUMN mail_tracking_value.new_value_monetary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_monetary IS 'New Value Monetary';


--
-- Name: COLUMN mail_tracking_value.new_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_char IS 'New Value Char';


--
-- Name: COLUMN mail_tracking_value.new_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_text IS 'New Value Text';


--
-- Name: COLUMN mail_tracking_value.new_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_datetime IS 'New Value Datetime';


--
-- Name: COLUMN mail_tracking_value.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.currency_id IS 'Currency';


--
-- Name: COLUMN mail_tracking_value.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.mail_message_id IS 'Message ID';


--
-- Name: COLUMN mail_tracking_value.tracking_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.tracking_sequence IS 'Tracking field sequence';


--
-- Name: COLUMN mail_tracking_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_uid IS 'Created by';


--
-- Name: COLUMN mail_tracking_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_date IS 'Created on';


--
-- Name: COLUMN mail_tracking_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_tracking_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_date IS 'Last Updated on';


--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_tracking_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_tracking_value_id_seq OWNER TO runbot;

--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_tracking_value_id_seq OWNED BY public.mail_tracking_value.id;


--
-- Name: mail_wizard_invite; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_wizard_invite (
    id integer NOT NULL,
    res_model character varying NOT NULL,
    res_id integer,
    message text,
    send_mail boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_wizard_invite OWNER TO runbot;

--
-- Name: TABLE mail_wizard_invite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_wizard_invite IS 'Invite wizard';


--
-- Name: COLUMN mail_wizard_invite.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_wizard_invite.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_wizard_invite.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.message IS 'Message';


--
-- Name: COLUMN mail_wizard_invite.send_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.send_mail IS 'Send Email';


--
-- Name: COLUMN mail_wizard_invite.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.create_uid IS 'Created by';


--
-- Name: COLUMN mail_wizard_invite.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.create_date IS 'Created on';


--
-- Name: COLUMN mail_wizard_invite.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_wizard_invite.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.write_date IS 'Last Updated on';


--
-- Name: mail_wizard_invite_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_wizard_invite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_wizard_invite_id_seq OWNER TO runbot;

--
-- Name: mail_wizard_invite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_wizard_invite_id_seq OWNED BY public.mail_wizard_invite.id;


--
-- Name: mail_wizard_invite_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_wizard_invite_res_partner_rel (
    mail_wizard_invite_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_wizard_invite_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_wizard_invite_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_wizard_invite_res_partner_rel IS 'RELATION BETWEEN mail_wizard_invite AND res_partner';


--
-- Name: map_website; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.map_website (
    id integer NOT NULL,
    name character varying NOT NULL,
    address_url character varying,
    lat_lon_url character varying,
    route_address_url character varying,
    route_lat_lon_url character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.map_website OWNER TO runbot;

--
-- Name: TABLE map_website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.map_website IS 'Map Website';


--
-- Name: COLUMN map_website.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.map_website.name IS 'Map Website Name';


--
-- Name: COLUMN map_website.address_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.map_website.address_url IS 'URL that uses the address';


--
-- Name: COLUMN map_website.lat_lon_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.map_website.lat_lon_url IS 'URL that uses latitude and longitude';


--
-- Name: COLUMN map_website.route_address_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.map_website.route_address_url IS 'Route URL that uses the addresses';


--
-- Name: COLUMN map_website.route_lat_lon_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.map_website.route_lat_lon_url IS 'Route URL that uses latitude and longitude';


--
-- Name: COLUMN map_website.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.map_website.create_uid IS 'Created by';


--
-- Name: COLUMN map_website.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.map_website.create_date IS 'Created on';


--
-- Name: COLUMN map_website.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.map_website.write_uid IS 'Last Updated by';


--
-- Name: COLUMN map_website.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.map_website.write_date IS 'Last Updated on';


--
-- Name: map_website_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.map_website_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.map_website_id_seq OWNER TO runbot;

--
-- Name: map_website_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.map_website_id_seq OWNED BY public.map_website.id;


--
-- Name: mass_editing_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mass_editing_line (
    id integer NOT NULL,
    sequence integer,
    server_action_id integer NOT NULL,
    field_id integer NOT NULL,
    widget_option character varying,
    apply_domain boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mass_editing_line OWNER TO runbot;

--
-- Name: TABLE mass_editing_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mass_editing_line IS 'Mass Editing Line';


--
-- Name: COLUMN mass_editing_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_line.sequence IS 'Sequence';


--
-- Name: COLUMN mass_editing_line.server_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_line.server_action_id IS 'Server Action';


--
-- Name: COLUMN mass_editing_line.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_line.field_id IS 'Field';


--
-- Name: COLUMN mass_editing_line.widget_option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_line.widget_option IS 'Widget Option';


--
-- Name: COLUMN mass_editing_line.apply_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_line.apply_domain IS 'Apply Domain';


--
-- Name: COLUMN mass_editing_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_line.create_uid IS 'Created by';


--
-- Name: COLUMN mass_editing_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_line.create_date IS 'Created on';


--
-- Name: COLUMN mass_editing_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mass_editing_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_line.write_date IS 'Last Updated on';


--
-- Name: mass_editing_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mass_editing_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mass_editing_line_id_seq OWNER TO runbot;

--
-- Name: mass_editing_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mass_editing_line_id_seq OWNED BY public.mass_editing_line.id;


--
-- Name: mass_editing_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mass_editing_wizard (
    id integer NOT NULL,
    selected_item_qty integer,
    remaining_item_qty integer,
    operation_description_info text,
    operation_description_warning text,
    operation_description_danger text,
    message text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mass_editing_wizard OWNER TO runbot;

--
-- Name: TABLE mass_editing_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mass_editing_wizard IS 'Wizard for mass edition';


--
-- Name: COLUMN mass_editing_wizard.selected_item_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.selected_item_qty IS 'Selected Item Qty';


--
-- Name: COLUMN mass_editing_wizard.remaining_item_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.remaining_item_qty IS 'Remaining Item Qty';


--
-- Name: COLUMN mass_editing_wizard.operation_description_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.operation_description_info IS 'Operation Description Info';


--
-- Name: COLUMN mass_editing_wizard.operation_description_warning; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.operation_description_warning IS 'Operation Description Warning';


--
-- Name: COLUMN mass_editing_wizard.operation_description_danger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.operation_description_danger IS 'Operation Description Danger';


--
-- Name: COLUMN mass_editing_wizard.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.message IS 'Message';


--
-- Name: COLUMN mass_editing_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN mass_editing_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.create_date IS 'Created on';


--
-- Name: COLUMN mass_editing_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mass_editing_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.write_date IS 'Last Updated on';


--
-- Name: mass_editing_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mass_editing_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mass_editing_wizard_id_seq OWNER TO runbot;

--
-- Name: mass_editing_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mass_editing_wizard_id_seq OWNED BY public.mass_editing_wizard.id;


--
-- Name: meeting_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.meeting_category_rel (
    event_id integer NOT NULL,
    type_id integer NOT NULL
);


ALTER TABLE public.meeting_category_rel OWNER TO runbot;

--
-- Name: TABLE meeting_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.meeting_category_rel IS 'RELATION BETWEEN calendar_event AND calendar_event_type';


--
-- Name: message_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.message_attachment_rel (
    message_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.message_attachment_rel OWNER TO runbot;

--
-- Name: TABLE message_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.message_attachment_rel IS 'RELATION BETWEEN mail_message AND ir_attachment';


--
-- Name: mis_report; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mis_report (
    id integer NOT NULL,
    name character varying NOT NULL,
    description character varying,
    style_id integer,
    move_lines_source integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mis_report OWNER TO runbot;

--
-- Name: TABLE mis_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mis_report IS 'MIS Report Template';


--
-- Name: COLUMN mis_report.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report.name IS 'Name';


--
-- Name: COLUMN mis_report.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report.description IS 'Description';


--
-- Name: COLUMN mis_report.style_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report.style_id IS 'Style';


--
-- Name: COLUMN mis_report.move_lines_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report.move_lines_source IS 'Move Lines Source';


--
-- Name: COLUMN mis_report.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report.create_uid IS 'Created by';


--
-- Name: COLUMN mis_report.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report.create_date IS 'Created on';


--
-- Name: COLUMN mis_report.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mis_report.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report.write_date IS 'Last Updated on';


--
-- Name: mis_report_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mis_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mis_report_id_seq OWNER TO runbot;

--
-- Name: mis_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mis_report_id_seq OWNED BY public.mis_report.id;


--
-- Name: mis_report_instance; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mis_report_instance (
    id integer NOT NULL,
    name character varying NOT NULL,
    date date,
    report_id integer NOT NULL,
    target_move character varying NOT NULL,
    company_id integer,
    multi_company boolean,
    currency_id integer,
    landscape_pdf boolean,
    no_auto_expand_accounts boolean,
    display_columns_description boolean,
    date_range_id integer,
    date_from date,
    date_to date,
    temporary boolean,
    analytic_account_id integer,
    analytic_group_id integer,
    hide_analytic_filters boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    horizontal boolean
);


ALTER TABLE public.mis_report_instance OWNER TO runbot;

--
-- Name: TABLE mis_report_instance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mis_report_instance IS 'MIS Report Instance';


--
-- Name: COLUMN mis_report_instance.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.name IS 'Name';


--
-- Name: COLUMN mis_report_instance.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.date IS 'Base date';


--
-- Name: COLUMN mis_report_instance.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.report_id IS 'Report';


--
-- Name: COLUMN mis_report_instance.target_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.target_move IS 'Target Moves';


--
-- Name: COLUMN mis_report_instance.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.company_id IS 'Allowed company';


--
-- Name: COLUMN mis_report_instance.multi_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.multi_company IS 'Multiple companies';


--
-- Name: COLUMN mis_report_instance.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.currency_id IS 'Currency';


--
-- Name: COLUMN mis_report_instance.landscape_pdf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.landscape_pdf IS 'Landscape PDF';


--
-- Name: COLUMN mis_report_instance.no_auto_expand_accounts; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.no_auto_expand_accounts IS 'Disable account details expansion';


--
-- Name: COLUMN mis_report_instance.display_columns_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.display_columns_description IS 'Display Columns Description';


--
-- Name: COLUMN mis_report_instance.date_range_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.date_range_id IS 'Date Range';


--
-- Name: COLUMN mis_report_instance.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.date_from IS 'From';


--
-- Name: COLUMN mis_report_instance.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.date_to IS 'To';


--
-- Name: COLUMN mis_report_instance.temporary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.temporary IS 'Temporary';


--
-- Name: COLUMN mis_report_instance.analytic_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.analytic_account_id IS 'Analytic Account';


--
-- Name: COLUMN mis_report_instance.analytic_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.analytic_group_id IS 'Analytic Account Group';


--
-- Name: COLUMN mis_report_instance.hide_analytic_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.hide_analytic_filters IS 'Hide Analytic Filters';


--
-- Name: COLUMN mis_report_instance.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.create_uid IS 'Created by';


--
-- Name: COLUMN mis_report_instance.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.create_date IS 'Created on';


--
-- Name: COLUMN mis_report_instance.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mis_report_instance.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.write_date IS 'Last Updated on';


--
-- Name: COLUMN mis_report_instance.horizontal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance.horizontal IS 'Horizontal';


--
-- Name: mis_report_instance_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mis_report_instance_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mis_report_instance_id_seq OWNER TO runbot;

--
-- Name: mis_report_instance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mis_report_instance_id_seq OWNED BY public.mis_report_instance.id;


--
-- Name: mis_report_instance_period; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mis_report_instance_period (
    id integer NOT NULL,
    name character varying NOT NULL,
    mode character varying NOT NULL,
    type character varying,
    is_ytd boolean,
    date_range_type_id integer,
    "offset" integer,
    duration integer,
    manual_date_from date,
    manual_date_to date,
    date_range_id integer,
    sequence integer,
    report_instance_id integer NOT NULL,
    normalize_factor integer,
    source character varying NOT NULL,
    source_aml_model_id integer,
    source_sumcol_accdet boolean,
    source_cmpcol_from_id integer,
    source_cmpcol_to_id integer,
    analytic_account_id integer,
    analytic_group_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT mis_report_instance_period_duration CHECK ((duration > 0)),
    CONSTRAINT mis_report_instance_period_normalize_factor CHECK ((normalize_factor > 0))
);


ALTER TABLE public.mis_report_instance_period OWNER TO runbot;

--
-- Name: TABLE mis_report_instance_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mis_report_instance_period IS 'MIS Report Instance Period';


--
-- Name: COLUMN mis_report_instance_period.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.name IS 'Label';


--
-- Name: COLUMN mis_report_instance_period.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.mode IS 'Mode';


--
-- Name: COLUMN mis_report_instance_period.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.type IS 'Period type';


--
-- Name: COLUMN mis_report_instance_period.is_ytd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.is_ytd IS 'Year to date';


--
-- Name: COLUMN mis_report_instance_period.date_range_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.date_range_type_id IS 'Date Range Type';


--
-- Name: COLUMN mis_report_instance_period."offset"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period."offset" IS 'Offset';


--
-- Name: COLUMN mis_report_instance_period.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.duration IS 'Duration';


--
-- Name: COLUMN mis_report_instance_period.manual_date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.manual_date_from IS 'From';


--
-- Name: COLUMN mis_report_instance_period.manual_date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.manual_date_to IS 'To';


--
-- Name: COLUMN mis_report_instance_period.date_range_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.date_range_id IS 'Date Range';


--
-- Name: COLUMN mis_report_instance_period.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.sequence IS 'Sequence';


--
-- Name: COLUMN mis_report_instance_period.report_instance_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.report_instance_id IS 'Report Instance';


--
-- Name: COLUMN mis_report_instance_period.normalize_factor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.normalize_factor IS 'Factor';


--
-- Name: COLUMN mis_report_instance_period.source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.source IS 'Source';


--
-- Name: COLUMN mis_report_instance_period.source_aml_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.source_aml_model_id IS 'Move lines source';


--
-- Name: COLUMN mis_report_instance_period.source_sumcol_accdet; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.source_sumcol_accdet IS 'Sum account details';


--
-- Name: COLUMN mis_report_instance_period.source_cmpcol_from_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.source_cmpcol_from_id IS 'versus';


--
-- Name: COLUMN mis_report_instance_period.source_cmpcol_to_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.source_cmpcol_to_id IS 'Compare';


--
-- Name: COLUMN mis_report_instance_period.analytic_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.analytic_account_id IS 'Analytic Account';


--
-- Name: COLUMN mis_report_instance_period.analytic_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.analytic_group_id IS 'Analytic Account Group';


--
-- Name: COLUMN mis_report_instance_period.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.create_uid IS 'Created by';


--
-- Name: COLUMN mis_report_instance_period.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.create_date IS 'Created on';


--
-- Name: COLUMN mis_report_instance_period.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mis_report_instance_period.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT mis_report_instance_period_duration ON mis_report_instance_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mis_report_instance_period_duration ON public.mis_report_instance_period IS 'CHECK (duration>0)';


--
-- Name: CONSTRAINT mis_report_instance_period_normalize_factor ON mis_report_instance_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mis_report_instance_period_normalize_factor ON public.mis_report_instance_period IS 'CHECK (normalize_factor>0)';


--
-- Name: mis_report_instance_period_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mis_report_instance_period_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mis_report_instance_period_id_seq OWNER TO runbot;

--
-- Name: mis_report_instance_period_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mis_report_instance_period_id_seq OWNED BY public.mis_report_instance_period.id;


--
-- Name: mis_report_instance_period_mis_report_subkpi_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mis_report_instance_period_mis_report_subkpi_rel (
    mis_report_instance_period_id integer NOT NULL,
    mis_report_subkpi_id integer NOT NULL
);


ALTER TABLE public.mis_report_instance_period_mis_report_subkpi_rel OWNER TO runbot;

--
-- Name: TABLE mis_report_instance_period_mis_report_subkpi_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mis_report_instance_period_mis_report_subkpi_rel IS 'RELATION BETWEEN mis_report_instance_period AND mis_report_subkpi';


--
-- Name: mis_report_instance_period_sum; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mis_report_instance_period_sum (
    id integer NOT NULL,
    period_id integer NOT NULL,
    period_to_sum_id integer NOT NULL,
    sign character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mis_report_instance_period_sum OWNER TO runbot;

--
-- Name: TABLE mis_report_instance_period_sum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mis_report_instance_period_sum IS 'MIS Report Instance Period Sum';


--
-- Name: COLUMN mis_report_instance_period_sum.period_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period_sum.period_id IS 'Parent column';


--
-- Name: COLUMN mis_report_instance_period_sum.period_to_sum_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period_sum.period_to_sum_id IS 'Column';


--
-- Name: COLUMN mis_report_instance_period_sum.sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period_sum.sign IS 'Sign';


--
-- Name: COLUMN mis_report_instance_period_sum.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period_sum.create_uid IS 'Created by';


--
-- Name: COLUMN mis_report_instance_period_sum.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period_sum.create_date IS 'Created on';


--
-- Name: COLUMN mis_report_instance_period_sum.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period_sum.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mis_report_instance_period_sum.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_instance_period_sum.write_date IS 'Last Updated on';


--
-- Name: mis_report_instance_period_sum_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mis_report_instance_period_sum_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mis_report_instance_period_sum_id_seq OWNER TO runbot;

--
-- Name: mis_report_instance_period_sum_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mis_report_instance_period_sum_id_seq OWNED BY public.mis_report_instance_period_sum.id;


--
-- Name: mis_report_instance_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mis_report_instance_res_company_rel (
    mis_report_instance_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.mis_report_instance_res_company_rel OWNER TO runbot;

--
-- Name: TABLE mis_report_instance_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mis_report_instance_res_company_rel IS 'RELATION BETWEEN mis_report_instance AND res_company';


--
-- Name: mis_report_kpi; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mis_report_kpi (
    id integer NOT NULL,
    name character varying NOT NULL,
    description character varying NOT NULL,
    multi boolean,
    auto_expand_accounts boolean,
    auto_expand_accounts_style_id integer,
    style_id integer,
    style_expression character varying,
    type character varying NOT NULL,
    compare_method character varying NOT NULL,
    accumulation_method character varying NOT NULL,
    sequence integer,
    report_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mis_report_kpi OWNER TO runbot;

--
-- Name: TABLE mis_report_kpi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mis_report_kpi IS 'MIS Report KPI';


--
-- Name: COLUMN mis_report_kpi.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi.name IS 'Name';


--
-- Name: COLUMN mis_report_kpi.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi.description IS 'Description';


--
-- Name: COLUMN mis_report_kpi.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi.multi IS 'Multi';


--
-- Name: COLUMN mis_report_kpi.auto_expand_accounts; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi.auto_expand_accounts IS 'Display details by account';


--
-- Name: COLUMN mis_report_kpi.auto_expand_accounts_style_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi.auto_expand_accounts_style_id IS 'Style for account detail rows';


--
-- Name: COLUMN mis_report_kpi.style_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi.style_id IS 'Style';


--
-- Name: COLUMN mis_report_kpi.style_expression; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi.style_expression IS 'Style Expression';


--
-- Name: COLUMN mis_report_kpi.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi.type IS 'Value type';


--
-- Name: COLUMN mis_report_kpi.compare_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi.compare_method IS 'Comparison Method';


--
-- Name: COLUMN mis_report_kpi.accumulation_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi.accumulation_method IS 'Accumulation Method';


--
-- Name: COLUMN mis_report_kpi.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi.sequence IS 'Sequence';


--
-- Name: COLUMN mis_report_kpi.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi.report_id IS 'Report';


--
-- Name: COLUMN mis_report_kpi.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi.create_uid IS 'Created by';


--
-- Name: COLUMN mis_report_kpi.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi.create_date IS 'Created on';


--
-- Name: COLUMN mis_report_kpi.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mis_report_kpi.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi.write_date IS 'Last Updated on';


--
-- Name: mis_report_kpi_expression; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mis_report_kpi_expression (
    id integer NOT NULL,
    sequence integer,
    name character varying,
    kpi_id integer NOT NULL,
    subkpi_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mis_report_kpi_expression OWNER TO runbot;

--
-- Name: TABLE mis_report_kpi_expression; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mis_report_kpi_expression IS 'MIS Report KPI Expression';


--
-- Name: COLUMN mis_report_kpi_expression.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi_expression.sequence IS 'Sequence';


--
-- Name: COLUMN mis_report_kpi_expression.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi_expression.name IS 'Expression';


--
-- Name: COLUMN mis_report_kpi_expression.kpi_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi_expression.kpi_id IS 'Kpi';


--
-- Name: COLUMN mis_report_kpi_expression.subkpi_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi_expression.subkpi_id IS 'Subkpi';


--
-- Name: COLUMN mis_report_kpi_expression.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi_expression.create_uid IS 'Created by';


--
-- Name: COLUMN mis_report_kpi_expression.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi_expression.create_date IS 'Created on';


--
-- Name: COLUMN mis_report_kpi_expression.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi_expression.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mis_report_kpi_expression.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_kpi_expression.write_date IS 'Last Updated on';


--
-- Name: mis_report_kpi_expression_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mis_report_kpi_expression_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mis_report_kpi_expression_id_seq OWNER TO runbot;

--
-- Name: mis_report_kpi_expression_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mis_report_kpi_expression_id_seq OWNED BY public.mis_report_kpi_expression.id;


--
-- Name: mis_report_kpi_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mis_report_kpi_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mis_report_kpi_id_seq OWNER TO runbot;

--
-- Name: mis_report_kpi_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mis_report_kpi_id_seq OWNED BY public.mis_report_kpi.id;


--
-- Name: mis_report_query; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mis_report_query (
    id integer NOT NULL,
    name character varying NOT NULL,
    model_id integer NOT NULL,
    aggregate character varying,
    date_field integer NOT NULL,
    domain character varying,
    report_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mis_report_query OWNER TO runbot;

--
-- Name: TABLE mis_report_query; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mis_report_query IS 'MIS Report Query';


--
-- Name: COLUMN mis_report_query.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_query.name IS 'Name';


--
-- Name: COLUMN mis_report_query.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_query.model_id IS 'Model';


--
-- Name: COLUMN mis_report_query.aggregate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_query.aggregate IS 'Aggregate';


--
-- Name: COLUMN mis_report_query.date_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_query.date_field IS 'Date Field';


--
-- Name: COLUMN mis_report_query.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_query.domain IS 'Domain';


--
-- Name: COLUMN mis_report_query.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_query.report_id IS 'Report';


--
-- Name: COLUMN mis_report_query.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_query.create_uid IS 'Created by';


--
-- Name: COLUMN mis_report_query.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_query.create_date IS 'Created on';


--
-- Name: COLUMN mis_report_query.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_query.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mis_report_query.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_query.write_date IS 'Last Updated on';


--
-- Name: mis_report_query_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mis_report_query_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mis_report_query_id_seq OWNER TO runbot;

--
-- Name: mis_report_query_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mis_report_query_id_seq OWNED BY public.mis_report_query.id;


--
-- Name: mis_report_style; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mis_report_style (
    id integer NOT NULL,
    name character varying NOT NULL,
    color_inherit boolean,
    color character varying,
    background_color_inherit boolean,
    background_color character varying,
    font_style_inherit boolean,
    font_style character varying,
    font_weight_inherit boolean,
    font_weight character varying,
    font_size_inherit boolean,
    font_size character varying,
    indent_level_inherit boolean,
    indent_level integer,
    prefix_inherit boolean,
    prefix character varying,
    suffix_inherit boolean,
    suffix character varying,
    dp_inherit boolean,
    dp integer,
    divider_inherit boolean,
    divider character varying,
    hide_empty_inherit boolean,
    hide_empty boolean,
    hide_always_inherit boolean,
    hide_always boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mis_report_style OWNER TO runbot;

--
-- Name: TABLE mis_report_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mis_report_style IS 'MIS Report Style';


--
-- Name: COLUMN mis_report_style.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.name IS 'Style name';


--
-- Name: COLUMN mis_report_style.color_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.color_inherit IS 'Color Inherit';


--
-- Name: COLUMN mis_report_style.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.color IS 'Text color';


--
-- Name: COLUMN mis_report_style.background_color_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.background_color_inherit IS 'Background Color Inherit';


--
-- Name: COLUMN mis_report_style.background_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.background_color IS 'Background Color';


--
-- Name: COLUMN mis_report_style.font_style_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.font_style_inherit IS 'Font Style Inherit';


--
-- Name: COLUMN mis_report_style.font_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.font_style IS 'Font Style';


--
-- Name: COLUMN mis_report_style.font_weight_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.font_weight_inherit IS 'Font Weight Inherit';


--
-- Name: COLUMN mis_report_style.font_weight; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.font_weight IS 'Font Weight';


--
-- Name: COLUMN mis_report_style.font_size_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.font_size_inherit IS 'Font Size Inherit';


--
-- Name: COLUMN mis_report_style.font_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.font_size IS 'Font Size';


--
-- Name: COLUMN mis_report_style.indent_level_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.indent_level_inherit IS 'Indent Level Inherit';


--
-- Name: COLUMN mis_report_style.indent_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.indent_level IS 'Indent Level';


--
-- Name: COLUMN mis_report_style.prefix_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.prefix_inherit IS 'Prefix Inherit';


--
-- Name: COLUMN mis_report_style.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.prefix IS 'Prefix';


--
-- Name: COLUMN mis_report_style.suffix_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.suffix_inherit IS 'Suffix Inherit';


--
-- Name: COLUMN mis_report_style.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.suffix IS 'Suffix';


--
-- Name: COLUMN mis_report_style.dp_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.dp_inherit IS 'Dp Inherit';


--
-- Name: COLUMN mis_report_style.dp; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.dp IS 'Rounding';


--
-- Name: COLUMN mis_report_style.divider_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.divider_inherit IS 'Divider Inherit';


--
-- Name: COLUMN mis_report_style.divider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.divider IS 'Factor';


--
-- Name: COLUMN mis_report_style.hide_empty_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.hide_empty_inherit IS 'Hide Empty Inherit';


--
-- Name: COLUMN mis_report_style.hide_empty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.hide_empty IS 'Hide Empty';


--
-- Name: COLUMN mis_report_style.hide_always_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.hide_always_inherit IS 'Hide Always Inherit';


--
-- Name: COLUMN mis_report_style.hide_always; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.hide_always IS 'Hide Always';


--
-- Name: COLUMN mis_report_style.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.create_uid IS 'Created by';


--
-- Name: COLUMN mis_report_style.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.create_date IS 'Created on';


--
-- Name: COLUMN mis_report_style.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mis_report_style.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_style.write_date IS 'Last Updated on';


--
-- Name: mis_report_style_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mis_report_style_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mis_report_style_id_seq OWNER TO runbot;

--
-- Name: mis_report_style_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mis_report_style_id_seq OWNED BY public.mis_report_style.id;


--
-- Name: mis_report_subkpi; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mis_report_subkpi (
    id integer NOT NULL,
    sequence integer,
    report_id integer NOT NULL,
    name character varying NOT NULL,
    description character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mis_report_subkpi OWNER TO runbot;

--
-- Name: TABLE mis_report_subkpi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mis_report_subkpi IS 'MIS Report Sub-KPI';


--
-- Name: COLUMN mis_report_subkpi.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_subkpi.sequence IS 'Sequence';


--
-- Name: COLUMN mis_report_subkpi.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_subkpi.report_id IS 'Report';


--
-- Name: COLUMN mis_report_subkpi.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_subkpi.name IS 'Name';


--
-- Name: COLUMN mis_report_subkpi.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_subkpi.description IS 'Description';


--
-- Name: COLUMN mis_report_subkpi.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_subkpi.create_uid IS 'Created by';


--
-- Name: COLUMN mis_report_subkpi.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_subkpi.create_date IS 'Created on';


--
-- Name: COLUMN mis_report_subkpi.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_subkpi.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mis_report_subkpi.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_subkpi.write_date IS 'Last Updated on';


--
-- Name: mis_report_subkpi_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mis_report_subkpi_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mis_report_subkpi_id_seq OWNER TO runbot;

--
-- Name: mis_report_subkpi_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mis_report_subkpi_id_seq OWNED BY public.mis_report_subkpi.id;


--
-- Name: mis_report_subreport; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mis_report_subreport (
    id integer NOT NULL,
    name character varying NOT NULL,
    report_id integer NOT NULL,
    subreport_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.mis_report_subreport OWNER TO runbot;

--
-- Name: TABLE mis_report_subreport; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mis_report_subreport IS 'MIS Report - Sub Reports Relation';


--
-- Name: COLUMN mis_report_subreport.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_subreport.name IS 'Name';


--
-- Name: COLUMN mis_report_subreport.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_subreport.report_id IS 'Report';


--
-- Name: COLUMN mis_report_subreport.subreport_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_subreport.subreport_id IS 'Subreport';


--
-- Name: COLUMN mis_report_subreport.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_subreport.create_uid IS 'Created by';


--
-- Name: COLUMN mis_report_subreport.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_subreport.create_date IS 'Created on';


--
-- Name: COLUMN mis_report_subreport.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_subreport.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mis_report_subreport.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mis_report_subreport.write_date IS 'Last Updated on';


--
-- Name: mis_report_subreport_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mis_report_subreport_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mis_report_subreport_id_seq OWNER TO runbot;

--
-- Name: mis_report_subreport_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mis_report_subreport_id_seq OWNED BY public.mis_report_subreport.id;


--
-- Name: online_bank_statement_provider; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.online_bank_statement_provider (
    id integer NOT NULL,
    message_main_attachment_id integer,
    company_id integer,
    active boolean,
    name character varying,
    journal_id integer NOT NULL,
    tz character varying,
    service character varying NOT NULL,
    interval_type character varying NOT NULL,
    interval_number integer NOT NULL,
    last_successful_run timestamp without time zone,
    next_run timestamp without time zone NOT NULL,
    statement_creation_mode character varying NOT NULL,
    api_base character varying,
    origin character varying,
    username character varying,
    password character varying,
    passphrase character varying,
    certificate_public_key text,
    certificate_private_key text,
    certificate_chain text,
    allow_empty_statements boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    ponto_token character varying,
    ponto_token_expiration timestamp without time zone,
    ponto_last_identifier character varying,
    CONSTRAINT online_bank_statement_provider_valid_interval_number CHECK ((interval_number > 0))
);


ALTER TABLE public.online_bank_statement_provider OWNER TO runbot;

--
-- Name: TABLE online_bank_statement_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.online_bank_statement_provider IS 'Online Bank Statement Provider';


--
-- Name: COLUMN online_bank_statement_provider.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN online_bank_statement_provider.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.company_id IS 'Company';


--
-- Name: COLUMN online_bank_statement_provider.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.active IS 'Active';


--
-- Name: COLUMN online_bank_statement_provider.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.name IS 'Name';


--
-- Name: COLUMN online_bank_statement_provider.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.journal_id IS 'Journal';


--
-- Name: COLUMN online_bank_statement_provider.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.tz IS 'Timezone';


--
-- Name: COLUMN online_bank_statement_provider.service; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.service IS 'Service';


--
-- Name: COLUMN online_bank_statement_provider.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.interval_type IS 'Interval Type';


--
-- Name: COLUMN online_bank_statement_provider.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.interval_number IS 'Scheduled update interval';


--
-- Name: COLUMN online_bank_statement_provider.last_successful_run; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.last_successful_run IS 'Last successful pull';


--
-- Name: COLUMN online_bank_statement_provider.next_run; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.next_run IS 'Next scheduled pull';


--
-- Name: COLUMN online_bank_statement_provider.statement_creation_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.statement_creation_mode IS 'Statement Creation Mode';


--
-- Name: COLUMN online_bank_statement_provider.api_base; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.api_base IS 'Api Base';


--
-- Name: COLUMN online_bank_statement_provider.origin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.origin IS 'Origin';


--
-- Name: COLUMN online_bank_statement_provider.username; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.username IS 'Username';


--
-- Name: COLUMN online_bank_statement_provider.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.password IS 'Password';


--
-- Name: COLUMN online_bank_statement_provider.passphrase; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.passphrase IS 'Passphrase';


--
-- Name: COLUMN online_bank_statement_provider.certificate_public_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.certificate_public_key IS 'Certificate Public Key';


--
-- Name: COLUMN online_bank_statement_provider.certificate_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.certificate_private_key IS 'Certificate Private Key';


--
-- Name: COLUMN online_bank_statement_provider.certificate_chain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.certificate_chain IS 'Certificate Chain';


--
-- Name: COLUMN online_bank_statement_provider.allow_empty_statements; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.allow_empty_statements IS 'Allow Empty Statements';


--
-- Name: COLUMN online_bank_statement_provider.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.create_uid IS 'Created by';


--
-- Name: COLUMN online_bank_statement_provider.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.create_date IS 'Created on';


--
-- Name: COLUMN online_bank_statement_provider.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.write_uid IS 'Last Updated by';


--
-- Name: COLUMN online_bank_statement_provider.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.write_date IS 'Last Updated on';


--
-- Name: COLUMN online_bank_statement_provider.ponto_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.ponto_token IS 'Ponto Token';


--
-- Name: COLUMN online_bank_statement_provider.ponto_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.ponto_token_expiration IS 'Ponto Token Expiration';


--
-- Name: COLUMN online_bank_statement_provider.ponto_last_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_provider.ponto_last_identifier IS 'Ponto Last Identifier';


--
-- Name: CONSTRAINT online_bank_statement_provider_valid_interval_number ON online_bank_statement_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT online_bank_statement_provider_valid_interval_number ON public.online_bank_statement_provider IS 'CHECK(interval_number > 0)';


--
-- Name: online_bank_statement_provider_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.online_bank_statement_provider_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.online_bank_statement_provider_id_seq OWNER TO runbot;

--
-- Name: online_bank_statement_provider_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.online_bank_statement_provider_id_seq OWNED BY public.online_bank_statement_provider.id;


--
-- Name: online_bank_statement_provider_pull_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.online_bank_statement_provider_pull_wizard_rel (
    wizard_id integer NOT NULL,
    provider_id integer NOT NULL
);


ALTER TABLE public.online_bank_statement_provider_pull_wizard_rel OWNER TO runbot;

--
-- Name: TABLE online_bank_statement_provider_pull_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.online_bank_statement_provider_pull_wizard_rel IS 'RELATION BETWEEN online_bank_statement_pull_wizard AND online_bank_statement_provider';


--
-- Name: online_bank_statement_pull_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.online_bank_statement_pull_wizard (
    id integer NOT NULL,
    date_since timestamp without time zone NOT NULL,
    date_until timestamp without time zone NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.online_bank_statement_pull_wizard OWNER TO runbot;

--
-- Name: TABLE online_bank_statement_pull_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.online_bank_statement_pull_wizard IS 'Online Bank Statement Pull Wizard';


--
-- Name: COLUMN online_bank_statement_pull_wizard.date_since; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_pull_wizard.date_since IS 'From';


--
-- Name: COLUMN online_bank_statement_pull_wizard.date_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_pull_wizard.date_until IS 'To';


--
-- Name: COLUMN online_bank_statement_pull_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_pull_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN online_bank_statement_pull_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_pull_wizard.create_date IS 'Created on';


--
-- Name: COLUMN online_bank_statement_pull_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_pull_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN online_bank_statement_pull_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.online_bank_statement_pull_wizard.write_date IS 'Last Updated on';


--
-- Name: online_bank_statement_pull_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.online_bank_statement_pull_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.online_bank_statement_pull_wizard_id_seq OWNER TO runbot;

--
-- Name: online_bank_statement_pull_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.online_bank_statement_pull_wizard_id_seq OWNED BY public.online_bank_statement_pull_wizard.id;


--
-- Name: open_items_report_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.open_items_report_wizard (
    id integer NOT NULL,
    company_id integer,
    date_at date NOT NULL,
    date_from date,
    target_move character varying NOT NULL,
    hide_account_at_0 boolean,
    receivable_accounts_only boolean,
    payable_accounts_only boolean,
    foreign_currency boolean,
    show_partner_details boolean,
    account_code_from integer,
    account_code_to integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.open_items_report_wizard OWNER TO runbot;

--
-- Name: TABLE open_items_report_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.open_items_report_wizard IS 'Open Items Report Wizard';


--
-- Name: COLUMN open_items_report_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.open_items_report_wizard.company_id IS 'Company';


--
-- Name: COLUMN open_items_report_wizard.date_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.open_items_report_wizard.date_at IS 'Date At';


--
-- Name: COLUMN open_items_report_wizard.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.open_items_report_wizard.date_from IS 'Date From';


--
-- Name: COLUMN open_items_report_wizard.target_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.open_items_report_wizard.target_move IS 'Target Moves';


--
-- Name: COLUMN open_items_report_wizard.hide_account_at_0; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.open_items_report_wizard.hide_account_at_0 IS 'Hide account ending balance at 0';


--
-- Name: COLUMN open_items_report_wizard.receivable_accounts_only; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.open_items_report_wizard.receivable_accounts_only IS 'Receivable Accounts Only';


--
-- Name: COLUMN open_items_report_wizard.payable_accounts_only; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.open_items_report_wizard.payable_accounts_only IS 'Payable Accounts Only';


--
-- Name: COLUMN open_items_report_wizard.foreign_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.open_items_report_wizard.foreign_currency IS 'Show foreign currency';


--
-- Name: COLUMN open_items_report_wizard.show_partner_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.open_items_report_wizard.show_partner_details IS 'Show Partner Details';


--
-- Name: COLUMN open_items_report_wizard.account_code_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.open_items_report_wizard.account_code_from IS 'Account Code From';


--
-- Name: COLUMN open_items_report_wizard.account_code_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.open_items_report_wizard.account_code_to IS 'Account Code To';


--
-- Name: COLUMN open_items_report_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.open_items_report_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN open_items_report_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.open_items_report_wizard.create_date IS 'Created on';


--
-- Name: COLUMN open_items_report_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.open_items_report_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN open_items_report_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.open_items_report_wizard.write_date IS 'Last Updated on';


--
-- Name: open_items_report_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.open_items_report_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.open_items_report_wizard_id_seq OWNER TO runbot;

--
-- Name: open_items_report_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.open_items_report_wizard_id_seq OWNED BY public.open_items_report_wizard.id;


--
-- Name: open_items_report_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.open_items_report_wizard_res_partner_rel (
    open_items_report_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.open_items_report_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE open_items_report_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.open_items_report_wizard_res_partner_rel IS 'RELATION BETWEEN open_items_report_wizard AND res_partner';


--
-- Name: payment_acquirer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_acquirer (
    id integer NOT NULL,
    name character varying NOT NULL,
    sequence integer,
    provider character varying NOT NULL,
    state character varying NOT NULL,
    company_id integer NOT NULL,
    allow_tokenization boolean,
    capture_manually boolean,
    redirect_form_view_id integer,
    inline_form_view_id integer,
    fees_active boolean,
    fees_dom_fixed double precision,
    fees_dom_var double precision,
    fees_int_fixed double precision,
    fees_int_var double precision,
    display_as character varying,
    pre_msg text,
    pending_msg text,
    auth_msg text,
    done_msg text,
    cancel_msg text,
    support_authorization boolean,
    support_fees_computation boolean,
    support_tokenization boolean,
    support_refund character varying,
    description text,
    color integer,
    module_id integer,
    module_state character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    qr_code boolean,
    so_reference_type character varying
);


ALTER TABLE public.payment_acquirer OWNER TO runbot;

--
-- Name: TABLE payment_acquirer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_acquirer IS 'Payment Acquirer';


--
-- Name: COLUMN payment_acquirer.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.name IS 'Name';


--
-- Name: COLUMN payment_acquirer.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.sequence IS 'Sequence';


--
-- Name: COLUMN payment_acquirer.provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.provider IS 'Provider';


--
-- Name: COLUMN payment_acquirer.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.state IS 'State';


--
-- Name: COLUMN payment_acquirer.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.company_id IS 'Company';


--
-- Name: COLUMN payment_acquirer.allow_tokenization; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.allow_tokenization IS 'Allow Saving Payment Methods';


--
-- Name: COLUMN payment_acquirer.capture_manually; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.capture_manually IS 'Capture Amount Manually';


--
-- Name: COLUMN payment_acquirer.redirect_form_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.redirect_form_view_id IS 'Redirect Form Template';


--
-- Name: COLUMN payment_acquirer.inline_form_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.inline_form_view_id IS 'Inline Form Template';


--
-- Name: COLUMN payment_acquirer.fees_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.fees_active IS 'Add Extra Fees';


--
-- Name: COLUMN payment_acquirer.fees_dom_fixed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.fees_dom_fixed IS 'Fixed domestic fees';


--
-- Name: COLUMN payment_acquirer.fees_dom_var; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.fees_dom_var IS 'Variable domestic fees (in percents)';


--
-- Name: COLUMN payment_acquirer.fees_int_fixed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.fees_int_fixed IS 'Fixed international fees';


--
-- Name: COLUMN payment_acquirer.fees_int_var; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.fees_int_var IS 'Variable international fees (in percents)';


--
-- Name: COLUMN payment_acquirer.display_as; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.display_as IS 'Displayed as';


--
-- Name: COLUMN payment_acquirer.pre_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.pre_msg IS 'Help Message';


--
-- Name: COLUMN payment_acquirer.pending_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.pending_msg IS 'Pending Message';


--
-- Name: COLUMN payment_acquirer.auth_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.auth_msg IS 'Authorize Message';


--
-- Name: COLUMN payment_acquirer.done_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.done_msg IS 'Done Message';


--
-- Name: COLUMN payment_acquirer.cancel_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.cancel_msg IS 'Canceled Message';


--
-- Name: COLUMN payment_acquirer.support_authorization; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.support_authorization IS 'Authorize Mechanism Supported';


--
-- Name: COLUMN payment_acquirer.support_fees_computation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.support_fees_computation IS 'Fees Computation Supported';


--
-- Name: COLUMN payment_acquirer.support_tokenization; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.support_tokenization IS 'Tokenization Supported';


--
-- Name: COLUMN payment_acquirer.support_refund; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.support_refund IS 'Type of Refund Supported';


--
-- Name: COLUMN payment_acquirer.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.description IS 'Description';


--
-- Name: COLUMN payment_acquirer.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.color IS 'Color';


--
-- Name: COLUMN payment_acquirer.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.module_id IS 'Corresponding Module';


--
-- Name: COLUMN payment_acquirer.module_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.module_state IS 'Installation State';


--
-- Name: COLUMN payment_acquirer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.create_uid IS 'Created by';


--
-- Name: COLUMN payment_acquirer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.create_date IS 'Created on';


--
-- Name: COLUMN payment_acquirer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_acquirer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.write_date IS 'Last Updated on';


--
-- Name: COLUMN payment_acquirer.qr_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.qr_code IS 'Enable QR Codes';


--
-- Name: COLUMN payment_acquirer.so_reference_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer.so_reference_type IS 'Communication';


--
-- Name: payment_acquirer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_acquirer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_acquirer_id_seq OWNER TO runbot;

--
-- Name: payment_acquirer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_acquirer_id_seq OWNED BY public.payment_acquirer.id;


--
-- Name: payment_acquirer_onboarding_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_acquirer_onboarding_wizard (
    id integer NOT NULL,
    payment_method character varying,
    paypal_user_type character varying,
    paypal_email_account character varying,
    paypal_seller_account character varying,
    paypal_pdt_token character varying,
    stripe_secret_key character varying,
    stripe_publishable_key character varying,
    manual_name character varying,
    journal_name character varying,
    acc_number character varying,
    manual_post_msg text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.payment_acquirer_onboarding_wizard OWNER TO runbot;

--
-- Name: TABLE payment_acquirer_onboarding_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_acquirer_onboarding_wizard IS 'Payment acquire onboarding wizard';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.payment_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.payment_method IS 'Payment Method';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.paypal_user_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.paypal_user_type IS 'Paypal User Type';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.paypal_email_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.paypal_email_account IS 'Email';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.paypal_seller_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.paypal_seller_account IS 'Merchant Account ID';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.paypal_pdt_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.paypal_pdt_token IS 'PDT Identity Token';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.stripe_secret_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.stripe_secret_key IS 'Stripe Secret Key';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.stripe_publishable_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.stripe_publishable_key IS 'Stripe Publishable Key';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.manual_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.manual_name IS 'Method';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.journal_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.journal_name IS 'Bank Name';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.acc_number IS 'Account Number';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.manual_post_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.manual_post_msg IS 'Payment Instructions';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.create_date IS 'Created on';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_acquirer_onboarding_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_acquirer_onboarding_wizard.write_date IS 'Last Updated on';


--
-- Name: payment_acquirer_onboarding_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_acquirer_onboarding_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_acquirer_onboarding_wizard_id_seq OWNER TO runbot;

--
-- Name: payment_acquirer_onboarding_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_acquirer_onboarding_wizard_id_seq OWNED BY public.payment_acquirer_onboarding_wizard.id;


--
-- Name: payment_acquirer_payment_icon_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_acquirer_payment_icon_rel (
    payment_acquirer_id integer NOT NULL,
    payment_icon_id integer NOT NULL
);


ALTER TABLE public.payment_acquirer_payment_icon_rel OWNER TO runbot;

--
-- Name: TABLE payment_acquirer_payment_icon_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_acquirer_payment_icon_rel IS 'RELATION BETWEEN payment_acquirer AND payment_icon';


--
-- Name: payment_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_country_rel (
    payment_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.payment_country_rel OWNER TO runbot;

--
-- Name: TABLE payment_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_country_rel IS 'RELATION BETWEEN payment_acquirer AND res_country';


--
-- Name: payment_icon; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_icon (
    id integer NOT NULL,
    name character varying,
    sequence integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.payment_icon OWNER TO runbot;

--
-- Name: TABLE payment_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_icon IS 'Payment Icon';


--
-- Name: COLUMN payment_icon.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_icon.name IS 'Name';


--
-- Name: COLUMN payment_icon.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_icon.sequence IS 'Sequence';


--
-- Name: COLUMN payment_icon.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_icon.create_uid IS 'Created by';


--
-- Name: COLUMN payment_icon.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_icon.create_date IS 'Created on';


--
-- Name: COLUMN payment_icon.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_icon.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_icon.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_icon.write_date IS 'Last Updated on';


--
-- Name: payment_icon_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_icon_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_icon_id_seq OWNER TO runbot;

--
-- Name: payment_icon_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_icon_id_seq OWNED BY public.payment_icon.id;


--
-- Name: payment_link_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_link_wizard (
    id integer NOT NULL,
    res_model character varying NOT NULL,
    res_id integer NOT NULL,
    amount numeric NOT NULL,
    amount_max numeric,
    currency_id integer,
    partner_id integer,
    description character varying,
    acquirer_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.payment_link_wizard OWNER TO runbot;

--
-- Name: TABLE payment_link_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_link_wizard IS 'Generate Payment Link';


--
-- Name: COLUMN payment_link_wizard.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.res_model IS 'Related Document Model';


--
-- Name: COLUMN payment_link_wizard.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.res_id IS 'Related Document ID';


--
-- Name: COLUMN payment_link_wizard.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.amount IS 'Amount';


--
-- Name: COLUMN payment_link_wizard.amount_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.amount_max IS 'Amount Max';


--
-- Name: COLUMN payment_link_wizard.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.currency_id IS 'Currency';


--
-- Name: COLUMN payment_link_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN payment_link_wizard.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.description IS 'Payment Ref';


--
-- Name: COLUMN payment_link_wizard.acquirer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.acquirer_id IS 'Force Payment Acquirer';


--
-- Name: COLUMN payment_link_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN payment_link_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.create_date IS 'Created on';


--
-- Name: COLUMN payment_link_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_link_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.write_date IS 'Last Updated on';


--
-- Name: payment_link_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_link_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_link_wizard_id_seq OWNER TO runbot;

--
-- Name: payment_link_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_link_wizard_id_seq OWNED BY public.payment_link_wizard.id;


--
-- Name: payment_refund_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_refund_wizard (
    id integer NOT NULL,
    payment_id integer,
    amount_to_refund numeric,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.payment_refund_wizard OWNER TO runbot;

--
-- Name: TABLE payment_refund_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_refund_wizard IS 'Payment Refund Wizard';


--
-- Name: COLUMN payment_refund_wizard.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.payment_id IS 'Payment';


--
-- Name: COLUMN payment_refund_wizard.amount_to_refund; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.amount_to_refund IS 'Refund Amount';


--
-- Name: COLUMN payment_refund_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN payment_refund_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.create_date IS 'Created on';


--
-- Name: COLUMN payment_refund_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_refund_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.write_date IS 'Last Updated on';


--
-- Name: payment_refund_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_refund_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_refund_wizard_id_seq OWNER TO runbot;

--
-- Name: payment_refund_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_refund_wizard_id_seq OWNED BY public.payment_refund_wizard.id;


--
-- Name: payment_token; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_token (
    id integer NOT NULL,
    acquirer_id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    company_id integer,
    acquirer_ref character varying NOT NULL,
    verified boolean,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.payment_token OWNER TO runbot;

--
-- Name: TABLE payment_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_token IS 'Payment Token';


--
-- Name: COLUMN payment_token.acquirer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.acquirer_id IS 'Acquirer Account';


--
-- Name: COLUMN payment_token.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.name IS 'Name';


--
-- Name: COLUMN payment_token.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.partner_id IS 'Partner';


--
-- Name: COLUMN payment_token.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.company_id IS 'Company';


--
-- Name: COLUMN payment_token.acquirer_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.acquirer_ref IS 'Acquirer Reference';


--
-- Name: COLUMN payment_token.verified; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.verified IS 'Verified';


--
-- Name: COLUMN payment_token.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.active IS 'Active';


--
-- Name: COLUMN payment_token.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.create_uid IS 'Created by';


--
-- Name: COLUMN payment_token.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.create_date IS 'Created on';


--
-- Name: COLUMN payment_token.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_token.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.write_date IS 'Last Updated on';


--
-- Name: payment_token_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_token_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_token_id_seq OWNER TO runbot;

--
-- Name: payment_token_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_token_id_seq OWNED BY public.payment_token.id;


--
-- Name: payment_transaction; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_transaction (
    id integer NOT NULL,
    acquirer_id integer NOT NULL,
    company_id integer,
    reference character varying NOT NULL,
    acquirer_reference character varying,
    amount numeric NOT NULL,
    currency_id integer NOT NULL,
    fees numeric,
    token_id integer,
    state character varying NOT NULL,
    state_message text,
    last_state_change timestamp without time zone,
    operation character varying,
    payment_id integer,
    source_transaction_id integer,
    is_post_processed boolean,
    tokenize boolean,
    landing_route character varying,
    callback_model_id integer,
    callback_res_id integer,
    callback_method character varying,
    callback_hash character varying,
    callback_is_done boolean,
    partner_id integer NOT NULL,
    partner_name character varying,
    partner_lang character varying,
    partner_email character varying,
    partner_address character varying,
    partner_zip character varying,
    partner_city character varying,
    partner_state_id integer,
    partner_country_id integer,
    partner_phone character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.payment_transaction OWNER TO runbot;

--
-- Name: TABLE payment_transaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_transaction IS 'Payment Transaction';


--
-- Name: COLUMN payment_transaction.acquirer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.acquirer_id IS 'Acquirer';


--
-- Name: COLUMN payment_transaction.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.company_id IS 'Company';


--
-- Name: COLUMN payment_transaction.reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.reference IS 'Reference';


--
-- Name: COLUMN payment_transaction.acquirer_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.acquirer_reference IS 'Acquirer Reference';


--
-- Name: COLUMN payment_transaction.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.amount IS 'Amount';


--
-- Name: COLUMN payment_transaction.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.currency_id IS 'Currency';


--
-- Name: COLUMN payment_transaction.fees; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.fees IS 'Fees';


--
-- Name: COLUMN payment_transaction.token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.token_id IS 'Payment Token';


--
-- Name: COLUMN payment_transaction.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.state IS 'Status';


--
-- Name: COLUMN payment_transaction.state_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.state_message IS 'Message';


--
-- Name: COLUMN payment_transaction.last_state_change; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.last_state_change IS 'Last State Change Date';


--
-- Name: COLUMN payment_transaction.operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.operation IS 'Operation';


--
-- Name: COLUMN payment_transaction.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.payment_id IS 'Payment';


--
-- Name: COLUMN payment_transaction.source_transaction_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.source_transaction_id IS 'Source Transaction';


--
-- Name: COLUMN payment_transaction.is_post_processed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.is_post_processed IS 'Is Post-processed';


--
-- Name: COLUMN payment_transaction.tokenize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.tokenize IS 'Create Token';


--
-- Name: COLUMN payment_transaction.landing_route; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.landing_route IS 'Landing Route';


--
-- Name: COLUMN payment_transaction.callback_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.callback_model_id IS 'Callback Document Model';


--
-- Name: COLUMN payment_transaction.callback_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.callback_res_id IS 'Callback Record ID';


--
-- Name: COLUMN payment_transaction.callback_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.callback_method IS 'Callback Method';


--
-- Name: COLUMN payment_transaction.callback_hash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.callback_hash IS 'Callback Hash';


--
-- Name: COLUMN payment_transaction.callback_is_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.callback_is_done IS 'Callback Done';


--
-- Name: COLUMN payment_transaction.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_id IS 'Customer';


--
-- Name: COLUMN payment_transaction.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_name IS 'Partner Name';


--
-- Name: COLUMN payment_transaction.partner_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_lang IS 'Language';


--
-- Name: COLUMN payment_transaction.partner_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_email IS 'Email';


--
-- Name: COLUMN payment_transaction.partner_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_address IS 'Address';


--
-- Name: COLUMN payment_transaction.partner_zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_zip IS 'Zip';


--
-- Name: COLUMN payment_transaction.partner_city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_city IS 'City';


--
-- Name: COLUMN payment_transaction.partner_state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_state_id IS 'State';


--
-- Name: COLUMN payment_transaction.partner_country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_country_id IS 'Country';


--
-- Name: COLUMN payment_transaction.partner_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_phone IS 'Phone';


--
-- Name: COLUMN payment_transaction.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.create_uid IS 'Created by';


--
-- Name: COLUMN payment_transaction.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.create_date IS 'Created on';


--
-- Name: COLUMN payment_transaction.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_transaction.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.write_date IS 'Last Updated on';


--
-- Name: payment_transaction_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_transaction_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_transaction_id_seq OWNER TO runbot;

--
-- Name: payment_transaction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_transaction_id_seq OWNED BY public.payment_transaction.id;


--
-- Name: phone_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist (
    id integer NOT NULL,
    message_main_attachment_id integer,
    number character varying NOT NULL,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist OWNER TO runbot;

--
-- Name: TABLE phone_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist IS 'Phone Blacklist';


--
-- Name: COLUMN phone_blacklist.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN phone_blacklist.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.number IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.active IS 'Active';


--
-- Name: COLUMN phone_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_id_seq OWNED BY public.phone_blacklist.id;


--
-- Name: phone_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist_remove (
    id integer NOT NULL,
    phone character varying NOT NULL,
    reason character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE phone_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist_remove IS 'Remove phone from blacklist';


--
-- Name: COLUMN phone_blacklist_remove.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.phone IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN phone_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNED BY public.phone_blacklist_remove.id;


--
-- Name: portal_share; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_share (
    id integer NOT NULL,
    res_model character varying NOT NULL,
    res_id integer NOT NULL,
    note text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_share OWNER TO runbot;

--
-- Name: TABLE portal_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_share IS 'Portal Sharing';


--
-- Name: COLUMN portal_share.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.res_model IS 'Related Document Model';


--
-- Name: COLUMN portal_share.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.res_id IS 'Related Document ID';


--
-- Name: COLUMN portal_share.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.note IS 'Note';


--
-- Name: COLUMN portal_share.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.create_uid IS 'Created by';


--
-- Name: COLUMN portal_share.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.create_date IS 'Created on';


--
-- Name: COLUMN portal_share.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_share.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.write_date IS 'Last Updated on';


--
-- Name: portal_share_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_share_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_share_id_seq OWNER TO runbot;

--
-- Name: portal_share_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_share_id_seq OWNED BY public.portal_share.id;


--
-- Name: portal_share_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_share_res_partner_rel (
    portal_share_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.portal_share_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE portal_share_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_share_res_partner_rel IS 'RELATION BETWEEN portal_share AND res_partner';


--
-- Name: portal_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard (
    id integer NOT NULL,
    welcome_message text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_wizard OWNER TO runbot;

--
-- Name: TABLE portal_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard IS 'Grant Portal Access';


--
-- Name: COLUMN portal_wizard.welcome_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.welcome_message IS 'Invitation Message';


--
-- Name: COLUMN portal_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN portal_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.create_date IS 'Created on';


--
-- Name: COLUMN portal_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.write_date IS 'Last Updated on';


--
-- Name: portal_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_wizard_id_seq OWNER TO runbot;

--
-- Name: portal_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_wizard_id_seq OWNED BY public.portal_wizard.id;


--
-- Name: portal_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard_res_partner_rel (
    portal_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.portal_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE portal_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard_res_partner_rel IS 'RELATION BETWEEN portal_wizard AND res_partner';


--
-- Name: portal_wizard_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL,
    email character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_wizard_user OWNER TO runbot;

--
-- Name: TABLE portal_wizard_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard_user IS 'Portal User Config';


--
-- Name: COLUMN portal_wizard_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN portal_wizard_user.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.partner_id IS 'Contact';


--
-- Name: COLUMN portal_wizard_user.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.email IS 'Email';


--
-- Name: COLUMN portal_wizard_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.create_uid IS 'Created by';


--
-- Name: COLUMN portal_wizard_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.create_date IS 'Created on';


--
-- Name: COLUMN portal_wizard_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_wizard_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.write_date IS 'Last Updated on';


--
-- Name: portal_wizard_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_wizard_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_wizard_user_id_seq OWNER TO runbot;

--
-- Name: portal_wizard_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_wizard_user_id_seq OWNED BY public.portal_wizard_user.id;


--
-- Name: print_prenumbered_checks; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.print_prenumbered_checks (
    id integer NOT NULL,
    next_check_number character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.print_prenumbered_checks OWNER TO runbot;

--
-- Name: TABLE print_prenumbered_checks; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.print_prenumbered_checks IS 'Print Pre-numbered Checks';


--
-- Name: COLUMN print_prenumbered_checks.next_check_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.print_prenumbered_checks.next_check_number IS 'Next Check Number';


--
-- Name: COLUMN print_prenumbered_checks.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.print_prenumbered_checks.create_uid IS 'Created by';


--
-- Name: COLUMN print_prenumbered_checks.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.print_prenumbered_checks.create_date IS 'Created on';


--
-- Name: COLUMN print_prenumbered_checks.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.print_prenumbered_checks.write_uid IS 'Last Updated by';


--
-- Name: COLUMN print_prenumbered_checks.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.print_prenumbered_checks.write_date IS 'Last Updated on';


--
-- Name: print_prenumbered_checks_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.print_prenumbered_checks_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.print_prenumbered_checks_id_seq OWNER TO runbot;

--
-- Name: print_prenumbered_checks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.print_prenumbered_checks_id_seq OWNED BY public.print_prenumbered_checks.id;


--
-- Name: printnode_abstract_print_line_reports_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_abstract_print_line_reports_wizard_line (
    id integer NOT NULL,
    record_id integer NOT NULL,
    name character varying,
    quantity integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_abstract_print_line_reports_wizard_line OWNER TO runbot;

--
-- Name: TABLE printnode_abstract_print_line_reports_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_abstract_print_line_reports_wizard_line IS 'Record Line';


--
-- Name: COLUMN printnode_abstract_print_line_reports_wizard_line.record_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_abstract_print_line_reports_wizard_line.record_id IS 'Record';


--
-- Name: COLUMN printnode_abstract_print_line_reports_wizard_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_abstract_print_line_reports_wizard_line.name IS 'Name';


--
-- Name: COLUMN printnode_abstract_print_line_reports_wizard_line.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_abstract_print_line_reports_wizard_line.quantity IS 'Quantity';


--
-- Name: COLUMN printnode_abstract_print_line_reports_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_abstract_print_line_reports_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN printnode_abstract_print_line_reports_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_abstract_print_line_reports_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_abstract_print_line_reports_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_abstract_print_line_reports_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN printnode_abstract_print_line_reports_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_abstract_print_line_reports_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_abstract_print_line_reports_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_abstract_print_line_reports_wizard_line.write_date IS 'Last Updated on';


--
-- Name: printnode_abstract_print_line_reports_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_abstract_print_line_reports_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_abstract_print_line_reports_wizard_line_id_seq OWNER TO runbot;

--
-- Name: printnode_abstract_print_line_reports_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_abstract_print_line_reports_wizard_line_id_seq OWNED BY public.printnode_abstract_print_line_reports_wizard_line.id;


--
-- Name: printnode_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_account (
    id integer NOT NULL,
    alias character varying,
    endpoint character varying NOT NULL,
    limits integer,
    name character varying,
    password character varying,
    printed integer,
    printnode_id integer,
    status character varying,
    api_key character varying NOT NULL,
    is_dpc_account boolean,
    is_allowed_to_collect_data boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_account OWNER TO runbot;

--
-- Name: TABLE printnode_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_account IS 'PrintNode Account';


--
-- Name: COLUMN printnode_account.alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_account.alias IS 'Alias';


--
-- Name: COLUMN printnode_account.endpoint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_account.endpoint IS 'Endpoint';


--
-- Name: COLUMN printnode_account.limits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_account.limits IS 'Plan Page Limits';


--
-- Name: COLUMN printnode_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_account.name IS 'Name';


--
-- Name: COLUMN printnode_account.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_account.password IS 'Password';


--
-- Name: COLUMN printnode_account.printed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_account.printed IS 'Printed Pages';


--
-- Name: COLUMN printnode_account.printnode_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_account.printnode_id IS 'Direct Print ID';


--
-- Name: COLUMN printnode_account.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_account.status IS 'Status';


--
-- Name: COLUMN printnode_account.api_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_account.api_key IS 'API Key';


--
-- Name: COLUMN printnode_account.is_dpc_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_account.is_dpc_account IS 'Is Direct Print Client Account';


--
-- Name: COLUMN printnode_account.is_allowed_to_collect_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_account.is_allowed_to_collect_data IS 'Allow to collect stats';


--
-- Name: COLUMN printnode_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_account.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_account.create_date IS 'Created on';


--
-- Name: COLUMN printnode_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_account.write_date IS 'Last Updated on';


--
-- Name: printnode_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_account_id_seq OWNER TO runbot;

--
-- Name: printnode_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_account_id_seq OWNED BY public.printnode_account.id;


--
-- Name: printnode_action_button; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_action_button (
    id integer NOT NULL,
    active boolean,
    description character varying(64),
    model_id integer NOT NULL,
    method character varying(64),
    method_id integer NOT NULL,
    number_of_copies integer,
    report_id integer NOT NULL,
    printer_id integer,
    printer_bin integer,
    preprint boolean,
    domain text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_action_button OWNER TO runbot;

--
-- Name: TABLE printnode_action_button; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_action_button IS 'PrintNode Action Button';


--
-- Name: COLUMN printnode_action_button.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_button.active IS 'Active';


--
-- Name: COLUMN printnode_action_button.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_button.description IS 'Description';


--
-- Name: COLUMN printnode_action_button.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_button.model_id IS 'Model';


--
-- Name: COLUMN printnode_action_button.method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_button.method IS 'Method Name';


--
-- Name: COLUMN printnode_action_button.method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_button.method_id IS 'Method ID';


--
-- Name: COLUMN printnode_action_button.number_of_copies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_button.number_of_copies IS 'Number of Copies';


--
-- Name: COLUMN printnode_action_button.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_button.report_id IS 'Report';


--
-- Name: COLUMN printnode_action_button.printer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_button.printer_id IS 'Printer';


--
-- Name: COLUMN printnode_action_button.printer_bin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_button.printer_bin IS 'Printer Bin';


--
-- Name: COLUMN printnode_action_button.preprint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_button.preprint IS 'Print before action';


--
-- Name: COLUMN printnode_action_button.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_button.domain IS 'Domain';


--
-- Name: COLUMN printnode_action_button.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_button.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_action_button.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_button.create_date IS 'Created on';


--
-- Name: COLUMN printnode_action_button.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_button.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_action_button.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_button.write_date IS 'Last Updated on';


--
-- Name: printnode_action_button_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_action_button_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_action_button_id_seq OWNER TO runbot;

--
-- Name: printnode_action_button_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_action_button_id_seq OWNED BY public.printnode_action_button.id;


--
-- Name: printnode_action_method; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_action_method (
    id integer NOT NULL,
    name character varying(64) NOT NULL,
    model_id integer NOT NULL,
    method character varying(64) NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_action_method OWNER TO runbot;

--
-- Name: TABLE printnode_action_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_action_method IS 'PrintNode Action Method';


--
-- Name: COLUMN printnode_action_method.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_method.name IS 'Name';


--
-- Name: COLUMN printnode_action_method.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_method.model_id IS 'Model';


--
-- Name: COLUMN printnode_action_method.method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_method.method IS 'Method';


--
-- Name: COLUMN printnode_action_method.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_method.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_action_method.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_method.create_date IS 'Created on';


--
-- Name: COLUMN printnode_action_method.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_method.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_action_method.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_action_method.write_date IS 'Last Updated on';


--
-- Name: printnode_action_method_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_action_method_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_action_method_id_seq OWNER TO runbot;

--
-- Name: printnode_action_method_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_action_method_id_seq OWNED BY public.printnode_action_method.id;


--
-- Name: printnode_attach_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_attach_line (
    id integer NOT NULL,
    attachment_id integer,
    quantity integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_attach_line OWNER TO runbot;

--
-- Name: TABLE printnode_attach_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_attach_line IS 'Printnode Attachment Line';


--
-- Name: COLUMN printnode_attach_line.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_attach_line.attachment_id IS 'Attachment';


--
-- Name: COLUMN printnode_attach_line.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_attach_line.quantity IS 'Quantity';


--
-- Name: COLUMN printnode_attach_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_attach_line.wizard_id IS 'Parent Wizard';


--
-- Name: COLUMN printnode_attach_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_attach_line.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_attach_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_attach_line.create_date IS 'Created on';


--
-- Name: COLUMN printnode_attach_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_attach_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_attach_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_attach_line.write_date IS 'Last Updated on';


--
-- Name: printnode_attach_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_attach_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_attach_line_id_seq OWNER TO runbot;

--
-- Name: printnode_attach_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_attach_line_id_seq OWNED BY public.printnode_attach_line.id;


--
-- Name: printnode_attach_universal_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_attach_universal_wizard (
    id integer NOT NULL,
    with_custom_qty boolean,
    number_copy integer,
    printer_id integer NOT NULL,
    printer_bin integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_attach_universal_wizard OWNER TO runbot;

--
-- Name: TABLE printnode_attach_universal_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_attach_universal_wizard IS 'Print Attachments via Direct Print';


--
-- Name: COLUMN printnode_attach_universal_wizard.with_custom_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_attach_universal_wizard.with_custom_qty IS 'Custom quantity for each attachment';


--
-- Name: COLUMN printnode_attach_universal_wizard.number_copy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_attach_universal_wizard.number_copy IS 'Copies';


--
-- Name: COLUMN printnode_attach_universal_wizard.printer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_attach_universal_wizard.printer_id IS 'Printer';


--
-- Name: COLUMN printnode_attach_universal_wizard.printer_bin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_attach_universal_wizard.printer_bin IS 'Printer Bin';


--
-- Name: COLUMN printnode_attach_universal_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_attach_universal_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_attach_universal_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_attach_universal_wizard.create_date IS 'Created on';


--
-- Name: COLUMN printnode_attach_universal_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_attach_universal_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_attach_universal_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_attach_universal_wizard.write_date IS 'Last Updated on';


--
-- Name: printnode_attach_universal_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_attach_universal_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_attach_universal_wizard_id_seq OWNER TO runbot;

--
-- Name: printnode_attach_universal_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_attach_universal_wizard_id_seq OWNED BY public.printnode_attach_universal_wizard.id;


--
-- Name: printnode_computer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_computer (
    id integer NOT NULL,
    printnode_id integer,
    active boolean,
    name character varying(64) NOT NULL,
    status character varying(64),
    account_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_computer OWNER TO runbot;

--
-- Name: TABLE printnode_computer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_computer IS 'PrintNode Computer';


--
-- Name: COLUMN printnode_computer.printnode_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_computer.printnode_id IS 'Direct Print ID';


--
-- Name: COLUMN printnode_computer.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_computer.active IS 'Active';


--
-- Name: COLUMN printnode_computer.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_computer.name IS 'Name';


--
-- Name: COLUMN printnode_computer.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_computer.status IS 'Status';


--
-- Name: COLUMN printnode_computer.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_computer.account_id IS 'Account';


--
-- Name: COLUMN printnode_computer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_computer.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_computer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_computer.create_date IS 'Created on';


--
-- Name: COLUMN printnode_computer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_computer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_computer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_computer.write_date IS 'Last Updated on';


--
-- Name: printnode_computer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_computer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_computer_id_seq OWNER TO runbot;

--
-- Name: printnode_computer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_computer_id_seq OWNED BY public.printnode_computer.id;


--
-- Name: printnode_format; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_format (
    id integer NOT NULL,
    name character varying(8) NOT NULL,
    qweb character varying(16) NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_format OWNER TO runbot;

--
-- Name: TABLE printnode_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_format IS 'PrintNode Format';


--
-- Name: COLUMN printnode_format.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_format.name IS 'Content Type';


--
-- Name: COLUMN printnode_format.qweb; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_format.qweb IS 'QWeb Name';


--
-- Name: COLUMN printnode_format.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_format.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_format.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_format.create_date IS 'Created on';


--
-- Name: COLUMN printnode_format.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_format.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_format.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_format.write_date IS 'Last Updated on';


--
-- Name: printnode_format_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_format_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_format_id_seq OWNER TO runbot;

--
-- Name: printnode_format_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_format_id_seq OWNED BY public.printnode_format.id;


--
-- Name: printnode_format_printnode_printer_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_format_printnode_printer_rel (
    printnode_printer_id integer NOT NULL,
    printnode_format_id integer NOT NULL
);


ALTER TABLE public.printnode_format_printnode_printer_rel OWNER TO runbot;

--
-- Name: TABLE printnode_format_printnode_printer_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_format_printnode_printer_rel IS 'RELATION BETWEEN printnode_printer AND printnode_format';


--
-- Name: printnode_installer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_installer (
    id integer NOT NULL,
    api_key character varying,
    is_allowed_to_collect_data boolean,
    state character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_installer OWNER TO runbot;

--
-- Name: TABLE printnode_installer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_installer IS 'Direct Print API Key Installer';


--
-- Name: COLUMN printnode_installer.api_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_installer.api_key IS 'API Key';


--
-- Name: COLUMN printnode_installer.is_allowed_to_collect_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_installer.is_allowed_to_collect_data IS 'Collect statistics';


--
-- Name: COLUMN printnode_installer.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_installer.state IS 'Current Step';


--
-- Name: COLUMN printnode_installer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_installer.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_installer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_installer.create_date IS 'Created on';


--
-- Name: COLUMN printnode_installer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_installer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_installer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_installer.write_date IS 'Last Updated on';


--
-- Name: printnode_installer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_installer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_installer_id_seq OWNER TO runbot;

--
-- Name: printnode_installer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_installer_id_seq OWNED BY public.printnode_installer.id;


--
-- Name: printnode_log_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_log_type (
    id integer NOT NULL,
    active boolean,
    name character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_log_type OWNER TO runbot;

--
-- Name: TABLE printnode_log_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_log_type IS 'PrintNode Log Types';


--
-- Name: COLUMN printnode_log_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_log_type.active IS 'Active';


--
-- Name: COLUMN printnode_log_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_log_type.name IS 'Name of log types';


--
-- Name: COLUMN printnode_log_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_log_type.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_log_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_log_type.create_date IS 'Created on';


--
-- Name: COLUMN printnode_log_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_log_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_log_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_log_type.write_date IS 'Last Updated on';


--
-- Name: printnode_log_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_log_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_log_type_id_seq OWNER TO runbot;

--
-- Name: printnode_log_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_log_type_id_seq OWNED BY public.printnode_log_type.id;


--
-- Name: printnode_log_type_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_log_type_res_company_rel (
    res_company_id integer NOT NULL,
    printnode_log_type_id integer NOT NULL
);


ALTER TABLE public.printnode_log_type_res_company_rel OWNER TO runbot;

--
-- Name: TABLE printnode_log_type_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_log_type_res_company_rel IS 'RELATION BETWEEN res_company AND printnode_log_type';


--
-- Name: printnode_map_action_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_map_action_server (
    id integer NOT NULL,
    active boolean,
    name character varying NOT NULL,
    model_id integer NOT NULL,
    action_server_id integer,
    print_wizard_type character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_map_action_server OWNER TO runbot;

--
-- Name: TABLE printnode_map_action_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_map_action_server IS 'Proxy model for ir.actions.server';


--
-- Name: COLUMN printnode_map_action_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_map_action_server.active IS 'Active';


--
-- Name: COLUMN printnode_map_action_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_map_action_server.name IS 'Action Name';


--
-- Name: COLUMN printnode_map_action_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_map_action_server.model_id IS 'Model';


--
-- Name: COLUMN printnode_map_action_server.action_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_map_action_server.action_server_id IS 'Action';


--
-- Name: COLUMN printnode_map_action_server.print_wizard_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_map_action_server.print_wizard_type IS 'Print Wizard Type';


--
-- Name: COLUMN printnode_map_action_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_map_action_server.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_map_action_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_map_action_server.create_date IS 'Created on';


--
-- Name: COLUMN printnode_map_action_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_map_action_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_map_action_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_map_action_server.write_date IS 'Last Updated on';


--
-- Name: printnode_map_action_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_map_action_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_map_action_server_id_seq OWNER TO runbot;

--
-- Name: printnode_map_action_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_map_action_server_id_seq OWNED BY public.printnode_map_action_server.id;


--
-- Name: printnode_paper; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_paper (
    id integer NOT NULL,
    name character varying(64) NOT NULL,
    width integer,
    height integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_paper OWNER TO runbot;

--
-- Name: TABLE printnode_paper; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_paper IS 'PrintNode Paper';


--
-- Name: COLUMN printnode_paper.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_paper.name IS 'Name';


--
-- Name: COLUMN printnode_paper.width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_paper.width IS 'Width';


--
-- Name: COLUMN printnode_paper.height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_paper.height IS 'Height';


--
-- Name: COLUMN printnode_paper.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_paper.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_paper.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_paper.create_date IS 'Created on';


--
-- Name: COLUMN printnode_paper.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_paper.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_paper.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_paper.write_date IS 'Last Updated on';


--
-- Name: printnode_paper_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_paper_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_paper_id_seq OWNER TO runbot;

--
-- Name: printnode_paper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_paper_id_seq OWNED BY public.printnode_paper.id;


--
-- Name: printnode_paper_printnode_printer_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_paper_printnode_printer_rel (
    printnode_printer_id integer NOT NULL,
    printnode_paper_id integer NOT NULL
);


ALTER TABLE public.printnode_paper_printnode_printer_rel OWNER TO runbot;

--
-- Name: TABLE printnode_paper_printnode_printer_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_paper_printnode_printer_rel IS 'RELATION BETWEEN printnode_printer AND printnode_paper';


--
-- Name: printnode_print_reports_universal_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_print_reports_universal_wizard (
    id integer NOT NULL,
    report_id integer,
    number_copy integer,
    with_custom_qty boolean,
    printer_id integer,
    printer_bin integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_print_reports_universal_wizard OWNER TO runbot;

--
-- Name: TABLE printnode_print_reports_universal_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_print_reports_universal_wizard IS 'Print Reports Wizard';


--
-- Name: COLUMN printnode_print_reports_universal_wizard.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_reports_universal_wizard.report_id IS 'Report';


--
-- Name: COLUMN printnode_print_reports_universal_wizard.number_copy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_reports_universal_wizard.number_copy IS 'Copies';


--
-- Name: COLUMN printnode_print_reports_universal_wizard.with_custom_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_reports_universal_wizard.with_custom_qty IS 'Custom quantity for each record (Experimental)';


--
-- Name: COLUMN printnode_print_reports_universal_wizard.printer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_reports_universal_wizard.printer_id IS 'Printer';


--
-- Name: COLUMN printnode_print_reports_universal_wizard.printer_bin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_reports_universal_wizard.printer_bin IS 'Printer Bin';


--
-- Name: COLUMN printnode_print_reports_universal_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_reports_universal_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_print_reports_universal_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_reports_universal_wizard.create_date IS 'Created on';


--
-- Name: COLUMN printnode_print_reports_universal_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_reports_universal_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_print_reports_universal_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_reports_universal_wizard.write_date IS 'Last Updated on';


--
-- Name: printnode_print_reports_universal_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_print_reports_universal_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_print_reports_universal_wizard_id_seq OWNER TO runbot;

--
-- Name: printnode_print_reports_universal_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_print_reports_universal_wizard_id_seq OWNED BY public.printnode_print_reports_universal_wizard.id;


--
-- Name: printnode_print_reports_universal_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_print_reports_universal_wizard_line (
    id integer NOT NULL,
    record_id integer,
    quantity integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_print_reports_universal_wizard_line OWNER TO runbot;

--
-- Name: TABLE printnode_print_reports_universal_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_print_reports_universal_wizard_line IS 'Record Line';


--
-- Name: COLUMN printnode_print_reports_universal_wizard_line.record_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_reports_universal_wizard_line.record_id IS 'Record';


--
-- Name: COLUMN printnode_print_reports_universal_wizard_line.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_reports_universal_wizard_line.quantity IS 'Quantity';


--
-- Name: COLUMN printnode_print_reports_universal_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_reports_universal_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN printnode_print_reports_universal_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_reports_universal_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_print_reports_universal_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_reports_universal_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN printnode_print_reports_universal_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_reports_universal_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_print_reports_universal_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_reports_universal_wizard_line.write_date IS 'Last Updated on';


--
-- Name: printnode_print_reports_universal_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_print_reports_universal_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_print_reports_universal_wizard_line_id_seq OWNER TO runbot;

--
-- Name: printnode_print_reports_universal_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_print_reports_universal_wizard_line_id_seq OWNED BY public.printnode_print_reports_universal_wizard_line.id;


--
-- Name: printnode_print_sale_order_line_reports_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_print_sale_order_line_reports_wizard (
    id integer NOT NULL,
    number_copy integer,
    report_id integer,
    printer_id integer,
    printer_bin integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_print_sale_order_line_reports_wizard OWNER TO runbot;

--
-- Name: TABLE printnode_print_sale_order_line_reports_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_print_sale_order_line_reports_wizard IS 'Print sale.order.line Reports Wizard';


--
-- Name: COLUMN printnode_print_sale_order_line_reports_wizard.number_copy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_sale_order_line_reports_wizard.number_copy IS 'Copies';


--
-- Name: COLUMN printnode_print_sale_order_line_reports_wizard.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_sale_order_line_reports_wizard.report_id IS 'Report';


--
-- Name: COLUMN printnode_print_sale_order_line_reports_wizard.printer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_sale_order_line_reports_wizard.printer_id IS 'Printer';


--
-- Name: COLUMN printnode_print_sale_order_line_reports_wizard.printer_bin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_sale_order_line_reports_wizard.printer_bin IS 'Printer Bin';


--
-- Name: COLUMN printnode_print_sale_order_line_reports_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_sale_order_line_reports_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_print_sale_order_line_reports_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_sale_order_line_reports_wizard.create_date IS 'Created on';


--
-- Name: COLUMN printnode_print_sale_order_line_reports_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_sale_order_line_reports_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_print_sale_order_line_reports_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_sale_order_line_reports_wizard.write_date IS 'Last Updated on';


--
-- Name: printnode_print_sale_order_line_reports_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_print_sale_order_line_reports_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_print_sale_order_line_reports_wizard_id_seq OWNER TO runbot;

--
-- Name: printnode_print_sale_order_line_reports_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_print_sale_order_line_reports_wizard_id_seq OWNED BY public.printnode_print_sale_order_line_reports_wizard.id;


--
-- Name: printnode_print_sale_order_line_reports_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_print_sale_order_line_reports_wizard_line (
    id integer NOT NULL,
    record_id integer,
    quantity integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_print_sale_order_line_reports_wizard_line OWNER TO runbot;

--
-- Name: TABLE printnode_print_sale_order_line_reports_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_print_sale_order_line_reports_wizard_line IS 'Record Line';


--
-- Name: COLUMN printnode_print_sale_order_line_reports_wizard_line.record_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_sale_order_line_reports_wizard_line.record_id IS 'Record';


--
-- Name: COLUMN printnode_print_sale_order_line_reports_wizard_line.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_sale_order_line_reports_wizard_line.quantity IS 'Quantity';


--
-- Name: COLUMN printnode_print_sale_order_line_reports_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_sale_order_line_reports_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN printnode_print_sale_order_line_reports_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_sale_order_line_reports_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_print_sale_order_line_reports_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_sale_order_line_reports_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN printnode_print_sale_order_line_reports_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_sale_order_line_reports_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_print_sale_order_line_reports_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_sale_order_line_reports_wizard_line.write_date IS 'Last Updated on';


--
-- Name: printnode_print_sale_order_line_reports_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_print_sale_order_line_reports_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_print_sale_order_line_reports_wizard_line_id_seq OWNER TO runbot;

--
-- Name: printnode_print_sale_order_line_reports_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_print_sale_order_line_reports_wizard_line_id_seq OWNED BY public.printnode_print_sale_order_line_reports_wizard_line.id;


--
-- Name: printnode_print_stock_move_reports_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_print_stock_move_reports_wizard (
    id integer NOT NULL,
    number_copy integer,
    report_id integer,
    printer_id integer,
    printer_bin integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_print_stock_move_reports_wizard OWNER TO runbot;

--
-- Name: TABLE printnode_print_stock_move_reports_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_print_stock_move_reports_wizard IS 'Print stock.move Reports Wizard';


--
-- Name: COLUMN printnode_print_stock_move_reports_wizard.number_copy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_stock_move_reports_wizard.number_copy IS 'Copies';


--
-- Name: COLUMN printnode_print_stock_move_reports_wizard.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_stock_move_reports_wizard.report_id IS 'Report';


--
-- Name: COLUMN printnode_print_stock_move_reports_wizard.printer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_stock_move_reports_wizard.printer_id IS 'Printer';


--
-- Name: COLUMN printnode_print_stock_move_reports_wizard.printer_bin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_stock_move_reports_wizard.printer_bin IS 'Printer Bin';


--
-- Name: COLUMN printnode_print_stock_move_reports_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_stock_move_reports_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_print_stock_move_reports_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_stock_move_reports_wizard.create_date IS 'Created on';


--
-- Name: COLUMN printnode_print_stock_move_reports_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_stock_move_reports_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_print_stock_move_reports_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_stock_move_reports_wizard.write_date IS 'Last Updated on';


--
-- Name: printnode_print_stock_move_reports_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_print_stock_move_reports_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_print_stock_move_reports_wizard_id_seq OWNER TO runbot;

--
-- Name: printnode_print_stock_move_reports_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_print_stock_move_reports_wizard_id_seq OWNED BY public.printnode_print_stock_move_reports_wizard.id;


--
-- Name: printnode_print_stock_move_reports_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_print_stock_move_reports_wizard_line (
    id integer NOT NULL,
    record_id integer,
    quantity integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_print_stock_move_reports_wizard_line OWNER TO runbot;

--
-- Name: TABLE printnode_print_stock_move_reports_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_print_stock_move_reports_wizard_line IS 'Record Line';


--
-- Name: COLUMN printnode_print_stock_move_reports_wizard_line.record_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_stock_move_reports_wizard_line.record_id IS 'Record';


--
-- Name: COLUMN printnode_print_stock_move_reports_wizard_line.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_stock_move_reports_wizard_line.quantity IS 'Quantity';


--
-- Name: COLUMN printnode_print_stock_move_reports_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_stock_move_reports_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN printnode_print_stock_move_reports_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_stock_move_reports_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_print_stock_move_reports_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_stock_move_reports_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN printnode_print_stock_move_reports_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_stock_move_reports_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_print_stock_move_reports_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_print_stock_move_reports_wizard_line.write_date IS 'Last Updated on';


--
-- Name: printnode_print_stock_move_reports_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_print_stock_move_reports_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_print_stock_move_reports_wizard_line_id_seq OWNER TO runbot;

--
-- Name: printnode_print_stock_move_reports_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_print_stock_move_reports_wizard_line_id_seq OWNED BY public.printnode_print_stock_move_reports_wizard_line.id;


--
-- Name: printnode_printer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_printer (
    id integer NOT NULL,
    printnode_id integer,
    active boolean,
    online boolean,
    name character varying(64) NOT NULL,
    status character varying(64),
    computer_id integer NOT NULL,
    default_printer_bin integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_printer OWNER TO runbot;

--
-- Name: TABLE printnode_printer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_printer IS 'PrintNode Printer';


--
-- Name: COLUMN printnode_printer.printnode_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer.printnode_id IS 'Direct Print ID';


--
-- Name: COLUMN printnode_printer.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer.active IS 'Active';


--
-- Name: COLUMN printnode_printer.online; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer.online IS 'Online';


--
-- Name: COLUMN printnode_printer.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer.name IS 'Name';


--
-- Name: COLUMN printnode_printer.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer.status IS 'PrintNode Status';


--
-- Name: COLUMN printnode_printer.computer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer.computer_id IS 'Computer';


--
-- Name: COLUMN printnode_printer.default_printer_bin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer.default_printer_bin IS 'Default Bin';


--
-- Name: COLUMN printnode_printer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_printer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer.create_date IS 'Created on';


--
-- Name: COLUMN printnode_printer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_printer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer.write_date IS 'Last Updated on';


--
-- Name: printnode_printer_bin; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_printer_bin (
    id integer NOT NULL,
    name character varying NOT NULL,
    printer_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_printer_bin OWNER TO runbot;

--
-- Name: TABLE printnode_printer_bin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_printer_bin IS 'PrintNode Printer Bin';


--
-- Name: COLUMN printnode_printer_bin.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer_bin.name IS 'Bin Name';


--
-- Name: COLUMN printnode_printer_bin.printer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer_bin.printer_id IS 'Printer';


--
-- Name: COLUMN printnode_printer_bin.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer_bin.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_printer_bin.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer_bin.create_date IS 'Created on';


--
-- Name: COLUMN printnode_printer_bin.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer_bin.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_printer_bin.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printer_bin.write_date IS 'Last Updated on';


--
-- Name: printnode_printer_bin_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_printer_bin_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_printer_bin_id_seq OWNER TO runbot;

--
-- Name: printnode_printer_bin_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_printer_bin_id_seq OWNED BY public.printnode_printer_bin.id;


--
-- Name: printnode_printer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_printer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_printer_id_seq OWNER TO runbot;

--
-- Name: printnode_printer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_printer_id_seq OWNED BY public.printnode_printer.id;


--
-- Name: printnode_printjob; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_printjob (
    id integer NOT NULL,
    printnode_id character varying(64),
    printer_id integer,
    description character varying(64),
    attachment_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_printjob OWNER TO runbot;

--
-- Name: TABLE printnode_printjob; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_printjob IS 'PrintNode Job';


--
-- Name: COLUMN printnode_printjob.printnode_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printjob.printnode_id IS 'Direct Print ID';


--
-- Name: COLUMN printnode_printjob.printer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printjob.printer_id IS 'Printer';


--
-- Name: COLUMN printnode_printjob.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printjob.description IS 'Label';


--
-- Name: COLUMN printnode_printjob.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printjob.attachment_id IS 'Attachments';


--
-- Name: COLUMN printnode_printjob.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printjob.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_printjob.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printjob.create_date IS 'Created on';


--
-- Name: COLUMN printnode_printjob.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printjob.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_printjob.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_printjob.write_date IS 'Last Updated on';


--
-- Name: printnode_printjob_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_printjob_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_printjob_id_seq OWNER TO runbot;

--
-- Name: printnode_printjob_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_printjob_id_seq OWNED BY public.printnode_printjob.id;


--
-- Name: printnode_release; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_release (
    id integer NOT NULL,
    version character varying,
    release_notes text,
    is_critical_update boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_release OWNER TO runbot;

--
-- Name: TABLE printnode_release; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_release IS 'PrintNode Release';


--
-- Name: COLUMN printnode_release.version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_release.version IS 'Module Version';


--
-- Name: COLUMN printnode_release.release_notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_release.release_notes IS 'Release Notes';


--
-- Name: COLUMN printnode_release.is_critical_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_release.is_critical_update IS 'Is Critical Update';


--
-- Name: COLUMN printnode_release.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_release.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_release.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_release.create_date IS 'Created on';


--
-- Name: COLUMN printnode_release.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_release.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_release.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_release.write_date IS 'Last Updated on';


--
-- Name: printnode_release_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_release_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_release_id_seq OWNER TO runbot;

--
-- Name: printnode_release_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_release_id_seq OWNED BY public.printnode_release.id;


--
-- Name: printnode_report_policy; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_report_policy (
    id integer NOT NULL,
    report_id integer NOT NULL,
    printer_id integer,
    printer_bin integer,
    report_paper_id integer,
    exclude_from_auto_printing boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_report_policy OWNER TO runbot;

--
-- Name: TABLE printnode_report_policy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_report_policy IS 'PrintNode Report Policy';


--
-- Name: COLUMN printnode_report_policy.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_report_policy.report_id IS 'Report';


--
-- Name: COLUMN printnode_report_policy.printer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_report_policy.printer_id IS 'Printer';


--
-- Name: COLUMN printnode_report_policy.printer_bin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_report_policy.printer_bin IS 'Printer Bin';


--
-- Name: COLUMN printnode_report_policy.report_paper_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_report_policy.report_paper_id IS 'Report Paper';


--
-- Name: COLUMN printnode_report_policy.exclude_from_auto_printing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_report_policy.exclude_from_auto_printing IS 'Exclude from Auto-printing';


--
-- Name: COLUMN printnode_report_policy.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_report_policy.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_report_policy.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_report_policy.create_date IS 'Created on';


--
-- Name: COLUMN printnode_report_policy.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_report_policy.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_report_policy.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_report_policy.write_date IS 'Last Updated on';


--
-- Name: printnode_report_policy_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_report_policy_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_report_policy_id_seq OWNER TO runbot;

--
-- Name: printnode_report_policy_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_report_policy_id_seq OWNED BY public.printnode_report_policy.id;


--
-- Name: printnode_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_rule (
    id integer NOT NULL,
    active boolean,
    user_id integer NOT NULL,
    report_id integer NOT NULL,
    printer_id integer NOT NULL,
    printer_bin integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_rule OWNER TO runbot;

--
-- Name: TABLE printnode_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_rule IS 'PrintNode Rule';


--
-- Name: COLUMN printnode_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_rule.active IS 'Active';


--
-- Name: COLUMN printnode_rule.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_rule.user_id IS 'User';


--
-- Name: COLUMN printnode_rule.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_rule.report_id IS 'Report';


--
-- Name: COLUMN printnode_rule.printer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_rule.printer_id IS 'Printer';


--
-- Name: COLUMN printnode_rule.printer_bin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_rule.printer_bin IS 'Printer Bin';


--
-- Name: COLUMN printnode_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_rule.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_rule.create_date IS 'Created on';


--
-- Name: COLUMN printnode_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_rule.write_date IS 'Last Updated on';


--
-- Name: printnode_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_rule_id_seq OWNER TO runbot;

--
-- Name: printnode_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_rule_id_seq OWNED BY public.printnode_rule.id;


--
-- Name: printnode_scales; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_scales (
    id integer NOT NULL,
    printnode_id integer,
    active boolean,
    online boolean,
    name character varying(64) NOT NULL,
    device_num integer NOT NULL,
    status character varying(64),
    computer_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_scales OWNER TO runbot;

--
-- Name: TABLE printnode_scales; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_scales IS 'PrintNode Scales';


--
-- Name: COLUMN printnode_scales.printnode_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scales.printnode_id IS 'Printnode ID';


--
-- Name: COLUMN printnode_scales.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scales.active IS 'Active';


--
-- Name: COLUMN printnode_scales.online; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scales.online IS 'Online';


--
-- Name: COLUMN printnode_scales.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scales.name IS 'Device Name';


--
-- Name: COLUMN printnode_scales.device_num; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scales.device_num IS 'Device Num';


--
-- Name: COLUMN printnode_scales.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scales.status IS 'PrintNode Status';


--
-- Name: COLUMN printnode_scales.computer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scales.computer_id IS 'Computer';


--
-- Name: COLUMN printnode_scales.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scales.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_scales.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scales.create_date IS 'Created on';


--
-- Name: COLUMN printnode_scales.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scales.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_scales.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scales.write_date IS 'Last Updated on';


--
-- Name: printnode_scales_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_scales_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_scales_id_seq OWNER TO runbot;

--
-- Name: printnode_scales_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_scales_id_seq OWNED BY public.printnode_scales.id;


--
-- Name: printnode_scenario; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_scenario (
    id integer NOT NULL,
    action integer NOT NULL,
    active boolean,
    description character varying(200),
    domain text,
    number_of_copies integer,
    report_id integer NOT NULL,
    printer_id integer,
    printer_bin integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_scenario OWNER TO runbot;

--
-- Name: TABLE printnode_scenario; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_scenario IS 'PrintNode Scenarios';


--
-- Name: COLUMN printnode_scenario.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario.action IS 'Print Scenario Action';


--
-- Name: COLUMN printnode_scenario.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario.active IS 'Active';


--
-- Name: COLUMN printnode_scenario.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario.description IS 'Description';


--
-- Name: COLUMN printnode_scenario.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario.domain IS 'Domain';


--
-- Name: COLUMN printnode_scenario.number_of_copies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario.number_of_copies IS 'Number of Copies';


--
-- Name: COLUMN printnode_scenario.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario.report_id IS 'Report';


--
-- Name: COLUMN printnode_scenario.printer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario.printer_id IS 'Printer';


--
-- Name: COLUMN printnode_scenario.printer_bin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario.printer_bin IS 'Printer Bin';


--
-- Name: COLUMN printnode_scenario.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_scenario.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario.create_date IS 'Created on';


--
-- Name: COLUMN printnode_scenario.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_scenario.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario.write_date IS 'Last Updated on';


--
-- Name: printnode_scenario_action; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_scenario_action (
    id integer NOT NULL,
    name character varying(64) NOT NULL,
    code character varying(64) NOT NULL,
    model_id integer NOT NULL,
    reports_model_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_scenario_action OWNER TO runbot;

--
-- Name: TABLE printnode_scenario_action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_scenario_action IS 'PrintNode Scenario Action';


--
-- Name: COLUMN printnode_scenario_action.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario_action.name IS 'Name';


--
-- Name: COLUMN printnode_scenario_action.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario_action.code IS 'Code';


--
-- Name: COLUMN printnode_scenario_action.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario_action.model_id IS 'Model';


--
-- Name: COLUMN printnode_scenario_action.reports_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario_action.reports_model_id IS 'Model For Reports';


--
-- Name: COLUMN printnode_scenario_action.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario_action.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_scenario_action.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario_action.create_date IS 'Created on';


--
-- Name: COLUMN printnode_scenario_action.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario_action.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_scenario_action.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_scenario_action.write_date IS 'Last Updated on';


--
-- Name: printnode_scenario_action_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_scenario_action_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_scenario_action_id_seq OWNER TO runbot;

--
-- Name: printnode_scenario_action_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_scenario_action_id_seq OWNED BY public.printnode_scenario_action.id;


--
-- Name: printnode_scenario_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_scenario_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_scenario_id_seq OWNER TO runbot;

--
-- Name: printnode_scenario_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_scenario_id_seq OWNED BY public.printnode_scenario.id;


--
-- Name: printnode_workstation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.printnode_workstation (
    id integer NOT NULL,
    name character varying NOT NULL,
    printer_id integer,
    label_printer_id integer,
    scales_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.printnode_workstation OWNER TO runbot;

--
-- Name: TABLE printnode_workstation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.printnode_workstation IS 'Printnode Workstation';


--
-- Name: COLUMN printnode_workstation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_workstation.name IS 'Workstation Name';


--
-- Name: COLUMN printnode_workstation.printer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_workstation.printer_id IS 'Default Workstation Printer';


--
-- Name: COLUMN printnode_workstation.label_printer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_workstation.label_printer_id IS 'Default Workstation Shipping Label Printer';


--
-- Name: COLUMN printnode_workstation.scales_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_workstation.scales_id IS 'Default Workstation Scales';


--
-- Name: COLUMN printnode_workstation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_workstation.create_uid IS 'Created by';


--
-- Name: COLUMN printnode_workstation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_workstation.create_date IS 'Created on';


--
-- Name: COLUMN printnode_workstation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_workstation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN printnode_workstation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.printnode_workstation.write_date IS 'Last Updated on';


--
-- Name: printnode_workstation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.printnode_workstation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.printnode_workstation_id_seq OWNER TO runbot;

--
-- Name: printnode_workstation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.printnode_workstation_id_seq OWNED BY public.printnode_workstation.id;


--
-- Name: procurement_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.procurement_group (
    id integer NOT NULL,
    partner_id integer,
    name character varying NOT NULL,
    move_type character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    sale_id integer
);


ALTER TABLE public.procurement_group OWNER TO runbot;

--
-- Name: TABLE procurement_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.procurement_group IS 'Procurement Group';


--
-- Name: COLUMN procurement_group.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.procurement_group.partner_id IS 'Partner';


--
-- Name: COLUMN procurement_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.procurement_group.name IS 'Reference';


--
-- Name: COLUMN procurement_group.move_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.procurement_group.move_type IS 'Delivery Type';


--
-- Name: COLUMN procurement_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.procurement_group.create_uid IS 'Created by';


--
-- Name: COLUMN procurement_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.procurement_group.create_date IS 'Created on';


--
-- Name: COLUMN procurement_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.procurement_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN procurement_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.procurement_group.write_date IS 'Last Updated on';


--
-- Name: COLUMN procurement_group.sale_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.procurement_group.sale_id IS 'Sale Order';


--
-- Name: procurement_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.procurement_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.procurement_group_id_seq OWNER TO runbot;

--
-- Name: procurement_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.procurement_group_id_seq OWNED BY public.procurement_group.id;


--
-- Name: product_attr_exclusion_value_ids_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attr_exclusion_value_ids_rel (
    product_template_attribute_exclusion_id integer NOT NULL,
    product_template_attribute_value_id integer NOT NULL
);


ALTER TABLE public.product_attr_exclusion_value_ids_rel OWNER TO runbot;

--
-- Name: TABLE product_attr_exclusion_value_ids_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attr_exclusion_value_ids_rel IS 'RELATION BETWEEN product_template_attribute_exclusion AND product_template_attribute_value';


--
-- Name: product_attribute; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute (
    id integer NOT NULL,
    name character varying NOT NULL,
    sequence integer,
    create_variant character varying NOT NULL,
    display_type character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.product_attribute OWNER TO runbot;

--
-- Name: TABLE product_attribute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute IS 'Product Attribute';


--
-- Name: COLUMN product_attribute.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.name IS 'Attribute';


--
-- Name: COLUMN product_attribute.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.sequence IS 'Sequence';


--
-- Name: COLUMN product_attribute.create_variant; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.create_variant IS 'Variants Creation Mode';


--
-- Name: COLUMN product_attribute.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.display_type IS 'Display Type';


--
-- Name: COLUMN product_attribute.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.write_date IS 'Last Updated on';


--
-- Name: product_attribute_custom_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute_custom_value (
    id integer NOT NULL,
    custom_product_template_attribute_value_id integer NOT NULL,
    custom_value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    sale_order_line_id integer NOT NULL
);


ALTER TABLE public.product_attribute_custom_value OWNER TO runbot;

--
-- Name: TABLE product_attribute_custom_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute_custom_value IS 'Product Attribute Custom Value';


--
-- Name: COLUMN product_attribute_custom_value.custom_product_template_attribute_value_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.custom_product_template_attribute_value_id IS 'Attribute Value';


--
-- Name: COLUMN product_attribute_custom_value.custom_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.custom_value IS 'Custom Value';


--
-- Name: COLUMN product_attribute_custom_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute_custom_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute_custom_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute_custom_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_attribute_custom_value.sale_order_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.sale_order_line_id IS 'Sales Order Line';


--
-- Name: product_attribute_custom_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_attribute_custom_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_attribute_custom_value_id_seq OWNER TO runbot;

--
-- Name: product_attribute_custom_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_attribute_custom_value_id_seq OWNED BY public.product_attribute_custom_value.id;


--
-- Name: product_attribute_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_attribute_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_attribute_id_seq OWNER TO runbot;

--
-- Name: product_attribute_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_attribute_id_seq OWNED BY public.product_attribute.id;


--
-- Name: product_attribute_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute_product_template_rel (
    product_attribute_id integer NOT NULL,
    product_template_id integer NOT NULL
);


ALTER TABLE public.product_attribute_product_template_rel OWNER TO runbot;

--
-- Name: TABLE product_attribute_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute_product_template_rel IS 'RELATION BETWEEN product_attribute AND product_template';


--
-- Name: product_attribute_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute_value (
    id integer NOT NULL,
    name character varying NOT NULL,
    sequence integer,
    attribute_id integer NOT NULL,
    is_custom boolean,
    html_color character varying,
    color integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.product_attribute_value OWNER TO runbot;

--
-- Name: TABLE product_attribute_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute_value IS 'Attribute Value';


--
-- Name: COLUMN product_attribute_value.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.name IS 'Value';


--
-- Name: COLUMN product_attribute_value.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.sequence IS 'Sequence';


--
-- Name: COLUMN product_attribute_value.attribute_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.attribute_id IS 'Attribute';


--
-- Name: COLUMN product_attribute_value.is_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.is_custom IS 'Is custom value';


--
-- Name: COLUMN product_attribute_value.html_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.html_color IS 'Color';


--
-- Name: COLUMN product_attribute_value.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.color IS 'Color Index';


--
-- Name: COLUMN product_attribute_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.write_date IS 'Last Updated on';


--
-- Name: product_attribute_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_attribute_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_attribute_value_id_seq OWNER TO runbot;

--
-- Name: product_attribute_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_attribute_value_id_seq OWNED BY public.product_attribute_value.id;


--
-- Name: product_attribute_value_product_template_attribute_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute_value_product_template_attribute_line_rel (
    product_attribute_value_id integer NOT NULL,
    product_template_attribute_line_id integer NOT NULL
);


ALTER TABLE public.product_attribute_value_product_template_attribute_line_rel OWNER TO runbot;

--
-- Name: TABLE product_attribute_value_product_template_attribute_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute_value_product_template_attribute_line_rel IS 'RELATION BETWEEN product_attribute_value AND product_template_attribute_line';


--
-- Name: product_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_category (
    id integer NOT NULL,
    name character varying NOT NULL,
    complete_name character varying,
    parent_id integer,
    parent_path character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    hs_code_id integer,
    removal_strategy_id integer,
    packaging_reserve_method character varying
);


ALTER TABLE public.product_category OWNER TO runbot;

--
-- Name: TABLE product_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_category IS 'Product Category';


--
-- Name: COLUMN product_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.name IS 'Name';


--
-- Name: COLUMN product_category.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.complete_name IS 'Complete Name';


--
-- Name: COLUMN product_category.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.parent_id IS 'Parent Category';


--
-- Name: COLUMN product_category.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.parent_path IS 'Parent Path';


--
-- Name: COLUMN product_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.create_uid IS 'Created by';


--
-- Name: COLUMN product_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.create_date IS 'Created on';


--
-- Name: COLUMN product_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_category.hs_code_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.hs_code_id IS 'H.S. Code';


--
-- Name: COLUMN product_category.removal_strategy_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.removal_strategy_id IS 'Force Removal Strategy';


--
-- Name: COLUMN product_category.packaging_reserve_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.packaging_reserve_method IS 'Reserve Packagings';


--
-- Name: product_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_category_id_seq OWNER TO runbot;

--
-- Name: product_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_category_id_seq OWNED BY public.product_category.id;


--
-- Name: product_label_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_label_layout (
    id integer NOT NULL,
    print_format character varying NOT NULL,
    custom_quantity integer NOT NULL,
    extra_html text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    picking_quantity character varying NOT NULL,
    printer_id integer,
    printer_bin integer,
    active_model character varying,
    is_dpc_enabled boolean
);


ALTER TABLE public.product_label_layout OWNER TO runbot;

--
-- Name: TABLE product_label_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_label_layout IS 'Choose the sheet layout to print the labels';


--
-- Name: COLUMN product_label_layout.print_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.print_format IS 'Format';


--
-- Name: COLUMN product_label_layout.custom_quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.custom_quantity IS 'Quantity';


--
-- Name: COLUMN product_label_layout.extra_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.extra_html IS 'Extra Content';


--
-- Name: COLUMN product_label_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.create_uid IS 'Created by';


--
-- Name: COLUMN product_label_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.create_date IS 'Created on';


--
-- Name: COLUMN product_label_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_label_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_label_layout.picking_quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.picking_quantity IS 'Quantity to print';


--
-- Name: COLUMN product_label_layout.printer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.printer_id IS 'Printer';


--
-- Name: COLUMN product_label_layout.printer_bin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.printer_bin IS 'Printer Bin';


--
-- Name: COLUMN product_label_layout.active_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.active_model IS 'Active Model';


--
-- Name: COLUMN product_label_layout.is_dpc_enabled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.is_dpc_enabled IS 'Is Dpc Enabled';


--
-- Name: product_label_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_label_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_label_layout_id_seq OWNER TO runbot;

--
-- Name: product_label_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_label_layout_id_seq OWNED BY public.product_label_layout.id;


--
-- Name: product_label_layout_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_label_layout_line (
    id integer NOT NULL,
    product_tmpl_id integer,
    product_id integer,
    quantity integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.product_label_layout_line OWNER TO runbot;

--
-- Name: TABLE product_label_layout_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_label_layout_line IS 'Choose the sheet layout to print the labels / Line';


--
-- Name: COLUMN product_label_layout_line.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout_line.product_tmpl_id IS 'Product (Template)';


--
-- Name: COLUMN product_label_layout_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout_line.product_id IS 'Product';


--
-- Name: COLUMN product_label_layout_line.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout_line.quantity IS 'Quantity';


--
-- Name: COLUMN product_label_layout_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN product_label_layout_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout_line.create_uid IS 'Created by';


--
-- Name: COLUMN product_label_layout_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout_line.create_date IS 'Created on';


--
-- Name: COLUMN product_label_layout_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_label_layout_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout_line.write_date IS 'Last Updated on';


--
-- Name: product_label_layout_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_label_layout_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_label_layout_line_id_seq OWNER TO runbot;

--
-- Name: product_label_layout_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_label_layout_line_id_seq OWNED BY public.product_label_layout_line.id;


--
-- Name: product_label_layout_product_product_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_label_layout_product_product_rel (
    product_label_layout_id integer NOT NULL,
    product_product_id integer NOT NULL
);


ALTER TABLE public.product_label_layout_product_product_rel OWNER TO runbot;

--
-- Name: TABLE product_label_layout_product_product_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_label_layout_product_product_rel IS 'RELATION BETWEEN product_label_layout AND product_product';


--
-- Name: product_label_layout_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_label_layout_product_template_rel (
    product_label_layout_id integer NOT NULL,
    product_template_id integer NOT NULL
);


ALTER TABLE public.product_label_layout_product_template_rel OWNER TO runbot;

--
-- Name: TABLE product_label_layout_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_label_layout_product_template_rel IS 'RELATION BETWEEN product_label_layout AND product_template';


--
-- Name: product_label_layout_stock_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_label_layout_stock_move_line_rel (
    product_label_layout_id integer NOT NULL,
    stock_move_line_id integer NOT NULL
);


ALTER TABLE public.product_label_layout_stock_move_line_rel OWNER TO runbot;

--
-- Name: TABLE product_label_layout_stock_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_label_layout_stock_move_line_rel IS 'RELATION BETWEEN product_label_layout AND stock_move_line';


--
-- Name: product_packaging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_packaging (
    id integer NOT NULL,
    name character varying NOT NULL,
    sequence integer,
    product_id integer,
    qty numeric,
    barcode character varying,
    company_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    package_type_id integer,
    purchase boolean,
    sales boolean,
    CONSTRAINT product_packaging_positive_qty CHECK ((qty > (0)::numeric))
);


ALTER TABLE public.product_packaging OWNER TO runbot;

--
-- Name: TABLE product_packaging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_packaging IS 'Product Packaging';


--
-- Name: COLUMN product_packaging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.name IS 'Product Packaging';


--
-- Name: COLUMN product_packaging.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.sequence IS 'Sequence';


--
-- Name: COLUMN product_packaging.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.product_id IS 'Product';


--
-- Name: COLUMN product_packaging.qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.qty IS 'Contained Quantity';


--
-- Name: COLUMN product_packaging.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.barcode IS 'Barcode';


--
-- Name: COLUMN product_packaging.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.company_id IS 'Company';


--
-- Name: COLUMN product_packaging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.create_uid IS 'Created by';


--
-- Name: COLUMN product_packaging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.create_date IS 'Created on';


--
-- Name: COLUMN product_packaging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_packaging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_packaging.package_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.package_type_id IS 'Package Type';


--
-- Name: COLUMN product_packaging.purchase; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.purchase IS 'Purchase';


--
-- Name: COLUMN product_packaging.sales; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.sales IS 'Sales';


--
-- Name: CONSTRAINT product_packaging_positive_qty ON product_packaging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT product_packaging_positive_qty ON public.product_packaging IS 'CHECK(qty > 0)';


--
-- Name: product_packaging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_packaging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_packaging_id_seq OWNER TO runbot;

--
-- Name: product_packaging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_packaging_id_seq OWNED BY public.product_packaging.id;


--
-- Name: product_pricelist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_pricelist (
    id integer NOT NULL,
    name character varying NOT NULL,
    active boolean,
    currency_id integer NOT NULL,
    company_id integer,
    sequence integer,
    discount_policy character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.product_pricelist OWNER TO runbot;

--
-- Name: TABLE product_pricelist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_pricelist IS 'Pricelist';


--
-- Name: COLUMN product_pricelist.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.name IS 'Pricelist Name';


--
-- Name: COLUMN product_pricelist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.active IS 'Active';


--
-- Name: COLUMN product_pricelist.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.currency_id IS 'Currency';


--
-- Name: COLUMN product_pricelist.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.company_id IS 'Company';


--
-- Name: COLUMN product_pricelist.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.sequence IS 'Sequence';


--
-- Name: COLUMN product_pricelist.discount_policy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.discount_policy IS 'Discount Policy';


--
-- Name: COLUMN product_pricelist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.create_uid IS 'Created by';


--
-- Name: COLUMN product_pricelist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.create_date IS 'Created on';


--
-- Name: COLUMN product_pricelist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_pricelist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.write_date IS 'Last Updated on';


--
-- Name: product_pricelist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_pricelist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_pricelist_id_seq OWNER TO runbot;

--
-- Name: product_pricelist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_pricelist_id_seq OWNED BY public.product_pricelist.id;


--
-- Name: product_pricelist_item; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_pricelist_item (
    id integer NOT NULL,
    product_tmpl_id integer,
    product_id integer,
    categ_id integer,
    min_quantity numeric,
    applied_on character varying NOT NULL,
    base character varying NOT NULL,
    base_pricelist_id integer,
    pricelist_id integer NOT NULL,
    price_surcharge numeric,
    price_discount numeric,
    price_round numeric,
    price_min_margin numeric,
    price_max_margin numeric,
    company_id integer,
    currency_id integer,
    active boolean,
    date_start timestamp without time zone,
    date_end timestamp without time zone,
    compute_price character varying NOT NULL,
    fixed_price numeric,
    percent_price double precision,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.product_pricelist_item OWNER TO runbot;

--
-- Name: TABLE product_pricelist_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_pricelist_item IS 'Pricelist Rule';


--
-- Name: COLUMN product_pricelist_item.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.product_tmpl_id IS 'Product';


--
-- Name: COLUMN product_pricelist_item.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.product_id IS 'Product Variant';


--
-- Name: COLUMN product_pricelist_item.categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.categ_id IS 'Product Category';


--
-- Name: COLUMN product_pricelist_item.min_quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.min_quantity IS 'Min. Quantity';


--
-- Name: COLUMN product_pricelist_item.applied_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.applied_on IS 'Apply On';


--
-- Name: COLUMN product_pricelist_item.base; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.base IS 'Based on';


--
-- Name: COLUMN product_pricelist_item.base_pricelist_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.base_pricelist_id IS 'Other Pricelist';


--
-- Name: COLUMN product_pricelist_item.pricelist_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.pricelist_id IS 'Pricelist';


--
-- Name: COLUMN product_pricelist_item.price_surcharge; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.price_surcharge IS 'Price Surcharge';


--
-- Name: COLUMN product_pricelist_item.price_discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.price_discount IS 'Price Discount';


--
-- Name: COLUMN product_pricelist_item.price_round; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.price_round IS 'Price Rounding';


--
-- Name: COLUMN product_pricelist_item.price_min_margin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.price_min_margin IS 'Min. Price Margin';


--
-- Name: COLUMN product_pricelist_item.price_max_margin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.price_max_margin IS 'Max. Price Margin';


--
-- Name: COLUMN product_pricelist_item.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.company_id IS 'Company';


--
-- Name: COLUMN product_pricelist_item.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.currency_id IS 'Currency';


--
-- Name: COLUMN product_pricelist_item.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.active IS 'Active';


--
-- Name: COLUMN product_pricelist_item.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.date_start IS 'Start Date';


--
-- Name: COLUMN product_pricelist_item.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.date_end IS 'End Date';


--
-- Name: COLUMN product_pricelist_item.compute_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.compute_price IS 'Compute Price';


--
-- Name: COLUMN product_pricelist_item.fixed_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.fixed_price IS 'Fixed Price';


--
-- Name: COLUMN product_pricelist_item.percent_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.percent_price IS 'Percentage Price';


--
-- Name: COLUMN product_pricelist_item.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.create_uid IS 'Created by';


--
-- Name: COLUMN product_pricelist_item.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.create_date IS 'Created on';


--
-- Name: COLUMN product_pricelist_item.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_pricelist_item.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.write_date IS 'Last Updated on';


--
-- Name: product_pricelist_item_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_pricelist_item_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_pricelist_item_id_seq OWNER TO runbot;

--
-- Name: product_pricelist_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_pricelist_item_id_seq OWNED BY public.product_pricelist_item.id;


--
-- Name: product_product; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_product (
    id integer NOT NULL,
    message_main_attachment_id integer,
    default_code character varying,
    active boolean,
    product_tmpl_id integer NOT NULL,
    barcode character varying,
    combination_indices character varying,
    volume numeric,
    weight numeric,
    can_image_variant_1024_be_zoomed boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.product_product OWNER TO runbot;

--
-- Name: TABLE product_product; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_product IS 'Product';


--
-- Name: COLUMN product_product.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN product_product.default_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.default_code IS 'Internal Reference';


--
-- Name: COLUMN product_product.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.active IS 'Active';


--
-- Name: COLUMN product_product.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_product.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.barcode IS 'Barcode';


--
-- Name: COLUMN product_product.combination_indices; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.combination_indices IS 'Combination Indices';


--
-- Name: COLUMN product_product.volume; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.volume IS 'Volume';


--
-- Name: COLUMN product_product.weight; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.weight IS 'Weight';


--
-- Name: COLUMN product_product.can_image_variant_1024_be_zoomed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.can_image_variant_1024_be_zoomed IS 'Can Variant Image 1024 be zoomed';


--
-- Name: COLUMN product_product.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.create_uid IS 'Created by';


--
-- Name: COLUMN product_product.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.create_date IS 'Created on';


--
-- Name: COLUMN product_product.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_product.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.write_date IS 'Last Updated on';


--
-- Name: product_product_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_product_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_product_id_seq OWNER TO runbot;

--
-- Name: product_product_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_product_id_seq OWNED BY public.product_product.id;


--
-- Name: product_product_stock_inventory_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_product_stock_inventory_rel (
    stock_inventory_id integer NOT NULL,
    product_product_id integer NOT NULL
);


ALTER TABLE public.product_product_stock_inventory_rel OWNER TO runbot;

--
-- Name: TABLE product_product_stock_inventory_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_product_stock_inventory_rel IS 'RELATION BETWEEN stock_inventory AND product_product';


--
-- Name: product_product_stock_track_confirmation_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_product_stock_track_confirmation_rel (
    stock_track_confirmation_id integer NOT NULL,
    product_product_id integer NOT NULL
);


ALTER TABLE public.product_product_stock_track_confirmation_rel OWNER TO runbot;

--
-- Name: TABLE product_product_stock_track_confirmation_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_product_stock_track_confirmation_rel IS 'RELATION BETWEEN stock_track_confirmation AND product_product';


--
-- Name: product_removal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_removal (
    id integer NOT NULL,
    name character varying NOT NULL,
    method character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.product_removal OWNER TO runbot;

--
-- Name: TABLE product_removal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_removal IS 'Removal Strategy';


--
-- Name: COLUMN product_removal.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_removal.name IS 'Name';


--
-- Name: COLUMN product_removal.method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_removal.method IS 'Method';


--
-- Name: COLUMN product_removal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_removal.create_uid IS 'Created by';


--
-- Name: COLUMN product_removal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_removal.create_date IS 'Created on';


--
-- Name: COLUMN product_removal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_removal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_removal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_removal.write_date IS 'Last Updated on';


--
-- Name: product_removal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_removal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_removal_id_seq OWNER TO runbot;

--
-- Name: product_removal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_removal_id_seq OWNED BY public.product_removal.id;


--
-- Name: product_replenish; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_replenish (
    id integer NOT NULL,
    product_id integer NOT NULL,
    product_tmpl_id integer NOT NULL,
    product_has_variants boolean NOT NULL,
    product_uom_id integer NOT NULL,
    quantity double precision NOT NULL,
    date_planned timestamp without time zone NOT NULL,
    warehouse_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.product_replenish OWNER TO runbot;

--
-- Name: TABLE product_replenish; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_replenish IS 'Product Replenish';


--
-- Name: COLUMN product_replenish.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.product_id IS 'Product';


--
-- Name: COLUMN product_replenish.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_replenish.product_has_variants; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.product_has_variants IS 'Has variants';


--
-- Name: COLUMN product_replenish.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.product_uom_id IS 'Unit of measure';


--
-- Name: COLUMN product_replenish.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.quantity IS 'Quantity';


--
-- Name: COLUMN product_replenish.date_planned; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.date_planned IS 'Scheduled Date';


--
-- Name: COLUMN product_replenish.warehouse_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.warehouse_id IS 'Warehouse';


--
-- Name: COLUMN product_replenish.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.company_id IS 'Company';


--
-- Name: COLUMN product_replenish.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.create_uid IS 'Created by';


--
-- Name: COLUMN product_replenish.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.create_date IS 'Created on';


--
-- Name: COLUMN product_replenish.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_replenish.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.write_date IS 'Last Updated on';


--
-- Name: product_replenish_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_replenish_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_replenish_id_seq OWNER TO runbot;

--
-- Name: product_replenish_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_replenish_id_seq OWNED BY public.product_replenish.id;


--
-- Name: product_replenish_stock_location_route_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_replenish_stock_location_route_rel (
    product_replenish_id integer NOT NULL,
    stock_location_route_id integer NOT NULL
);


ALTER TABLE public.product_replenish_stock_location_route_rel OWNER TO runbot;

--
-- Name: TABLE product_replenish_stock_location_route_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_replenish_stock_location_route_rel IS 'RELATION BETWEEN product_replenish AND stock_location_route';


--
-- Name: product_supplier_taxes_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_supplier_taxes_rel (
    prod_id integer NOT NULL,
    tax_id integer NOT NULL
);


ALTER TABLE public.product_supplier_taxes_rel OWNER TO runbot;

--
-- Name: TABLE product_supplier_taxes_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_supplier_taxes_rel IS 'RELATION BETWEEN product_template AND account_tax';


--
-- Name: product_supplierinfo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_supplierinfo (
    id integer NOT NULL,
    name integer NOT NULL,
    product_name character varying,
    product_code character varying,
    sequence integer,
    min_qty numeric NOT NULL,
    price numeric NOT NULL,
    company_id integer,
    currency_id integer NOT NULL,
    date_start date,
    date_end date,
    product_id integer,
    product_tmpl_id integer,
    delay integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.product_supplierinfo OWNER TO runbot;

--
-- Name: TABLE product_supplierinfo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_supplierinfo IS 'Supplier Pricelist';


--
-- Name: COLUMN product_supplierinfo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.name IS 'Vendor';


--
-- Name: COLUMN product_supplierinfo.product_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.product_name IS 'Vendor Product Name';


--
-- Name: COLUMN product_supplierinfo.product_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.product_code IS 'Vendor Product Code';


--
-- Name: COLUMN product_supplierinfo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.sequence IS 'Sequence';


--
-- Name: COLUMN product_supplierinfo.min_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.min_qty IS 'Quantity';


--
-- Name: COLUMN product_supplierinfo.price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.price IS 'Price';


--
-- Name: COLUMN product_supplierinfo.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.company_id IS 'Company';


--
-- Name: COLUMN product_supplierinfo.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.currency_id IS 'Currency';


--
-- Name: COLUMN product_supplierinfo.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.date_start IS 'Start Date';


--
-- Name: COLUMN product_supplierinfo.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.date_end IS 'End Date';


--
-- Name: COLUMN product_supplierinfo.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.product_id IS 'Product Variant';


--
-- Name: COLUMN product_supplierinfo.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_supplierinfo.delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.delay IS 'Delivery Lead Time';


--
-- Name: COLUMN product_supplierinfo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.create_uid IS 'Created by';


--
-- Name: COLUMN product_supplierinfo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.create_date IS 'Created on';


--
-- Name: COLUMN product_supplierinfo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_supplierinfo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.write_date IS 'Last Updated on';


--
-- Name: product_supplierinfo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_supplierinfo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_supplierinfo_id_seq OWNER TO runbot;

--
-- Name: product_supplierinfo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_supplierinfo_id_seq OWNED BY public.product_supplierinfo.id;


--
-- Name: product_supplierinfo_stock_replenishment_info_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_supplierinfo_stock_replenishment_info_rel (
    stock_replenishment_info_id integer NOT NULL,
    product_supplierinfo_id integer NOT NULL
);


ALTER TABLE public.product_supplierinfo_stock_replenishment_info_rel OWNER TO runbot;

--
-- Name: TABLE product_supplierinfo_stock_replenishment_info_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_supplierinfo_stock_replenishment_info_rel IS 'RELATION BETWEEN stock_replenishment_info AND product_supplierinfo';


--
-- Name: product_taxes_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_taxes_rel (
    prod_id integer NOT NULL,
    tax_id integer NOT NULL
);


ALTER TABLE public.product_taxes_rel OWNER TO runbot;

--
-- Name: TABLE product_taxes_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_taxes_rel IS 'RELATION BETWEEN product_template AND account_tax';


--
-- Name: product_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_template (
    id integer NOT NULL,
    message_main_attachment_id integer,
    name character varying NOT NULL,
    sequence integer,
    description text,
    description_purchase text,
    description_sale text,
    detailed_type character varying NOT NULL,
    type character varying,
    categ_id integer NOT NULL,
    list_price numeric,
    volume numeric,
    weight numeric,
    sale_ok boolean,
    purchase_ok boolean,
    uom_id integer NOT NULL,
    uom_po_id integer NOT NULL,
    company_id integer,
    active boolean,
    color integer,
    default_code character varying,
    can_image_1024_be_zoomed boolean,
    has_configurable_attributes boolean,
    priority character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    hs_code_id integer,
    origin_country_id integer,
    origin_state_id integer,
    sale_delay double precision,
    tracking character varying NOT NULL,
    description_picking text,
    description_pickingout text,
    description_pickingin text,
    purchase_method character varying,
    purchase_line_warn character varying NOT NULL,
    purchase_line_warn_msg text,
    is_accessory_cost boolean,
    service_type character varying,
    sale_line_warn character varying NOT NULL,
    sale_line_warn_msg text,
    expense_policy character varying,
    invoice_policy character varying,
    service_to_purchase boolean,
    hs_code character varying,
    CONSTRAINT product_template_service_to_purchase CHECK (((((type)::text <> 'service'::text) AND (service_to_purchase <> true)) OR ((type)::text = 'service'::text)))
);


ALTER TABLE public.product_template OWNER TO runbot;

--
-- Name: TABLE product_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_template IS 'Product Template';


--
-- Name: COLUMN product_template.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN product_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.name IS 'Name';


--
-- Name: COLUMN product_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.sequence IS 'Sequence';


--
-- Name: COLUMN product_template.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.description IS 'Description';


--
-- Name: COLUMN product_template.description_purchase; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.description_purchase IS 'Purchase Description';


--
-- Name: COLUMN product_template.description_sale; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.description_sale IS 'Sales Description';


--
-- Name: COLUMN product_template.detailed_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.detailed_type IS 'Product Type';


--
-- Name: COLUMN product_template.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.type IS 'Type';


--
-- Name: COLUMN product_template.categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.categ_id IS 'Product Category';


--
-- Name: COLUMN product_template.list_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.list_price IS 'Sales Price';


--
-- Name: COLUMN product_template.volume; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.volume IS 'Volume';


--
-- Name: COLUMN product_template.weight; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.weight IS 'Weight';


--
-- Name: COLUMN product_template.sale_ok; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.sale_ok IS 'Can be Sold';


--
-- Name: COLUMN product_template.purchase_ok; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.purchase_ok IS 'Can be Purchased';


--
-- Name: COLUMN product_template.uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.uom_id IS 'Unit of Measure';


--
-- Name: COLUMN product_template.uom_po_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.uom_po_id IS 'Purchase UoM';


--
-- Name: COLUMN product_template.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.company_id IS 'Company';


--
-- Name: COLUMN product_template.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.active IS 'Active';


--
-- Name: COLUMN product_template.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.color IS 'Color Index';


--
-- Name: COLUMN product_template.default_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.default_code IS 'Internal Reference';


--
-- Name: COLUMN product_template.can_image_1024_be_zoomed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.can_image_1024_be_zoomed IS 'Can Image 1024 be zoomed';


--
-- Name: COLUMN product_template.has_configurable_attributes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.has_configurable_attributes IS 'Is a configurable product';


--
-- Name: COLUMN product_template.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.priority IS 'Favorite';


--
-- Name: COLUMN product_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.create_uid IS 'Created by';


--
-- Name: COLUMN product_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.create_date IS 'Created on';


--
-- Name: COLUMN product_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_template.hs_code_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.hs_code_id IS 'H.S. Code';


--
-- Name: COLUMN product_template.origin_country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.origin_country_id IS 'Country of Origin';


--
-- Name: COLUMN product_template.origin_state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.origin_state_id IS 'Country State of Origin';


--
-- Name: COLUMN product_template.sale_delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.sale_delay IS 'Customer Lead Time';


--
-- Name: COLUMN product_template.tracking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.tracking IS 'Tracking';


--
-- Name: COLUMN product_template.description_picking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.description_picking IS 'Description on Picking';


--
-- Name: COLUMN product_template.description_pickingout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.description_pickingout IS 'Description on Delivery Orders';


--
-- Name: COLUMN product_template.description_pickingin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.description_pickingin IS 'Description on Receptions';


--
-- Name: COLUMN product_template.purchase_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.purchase_method IS 'Control Policy';


--
-- Name: COLUMN product_template.purchase_line_warn; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.purchase_line_warn IS 'Purchase Order Line Warning';


--
-- Name: COLUMN product_template.purchase_line_warn_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.purchase_line_warn_msg IS 'Message for Purchase Order Line';


--
-- Name: COLUMN product_template.is_accessory_cost; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.is_accessory_cost IS 'Is Accessory Cost';


--
-- Name: COLUMN product_template.service_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.service_type IS 'Track Service';


--
-- Name: COLUMN product_template.sale_line_warn; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.sale_line_warn IS 'Sales Order Line';


--
-- Name: COLUMN product_template.sale_line_warn_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.sale_line_warn_msg IS 'Message for Sales Order Line';


--
-- Name: COLUMN product_template.expense_policy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.expense_policy IS 'Re-Invoice Expenses';


--
-- Name: COLUMN product_template.invoice_policy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.invoice_policy IS 'Invoicing Policy';


--
-- Name: COLUMN product_template.service_to_purchase; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.service_to_purchase IS 'Subcontract Service';


--
-- Name: COLUMN product_template.hs_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.hs_code IS 'HS Code';


--
-- Name: CONSTRAINT product_template_service_to_purchase ON product_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT product_template_service_to_purchase ON public.product_template IS 'CHECK((type != ''service'' AND service_to_purchase != true) or (type = ''service''))';


--
-- Name: product_template_attribute_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_template_attribute_exclusion (
    id integer NOT NULL,
    product_template_attribute_value_id integer,
    product_tmpl_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.product_template_attribute_exclusion OWNER TO runbot;

--
-- Name: TABLE product_template_attribute_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_template_attribute_exclusion IS 'Product Template Attribute Exclusion';


--
-- Name: COLUMN product_template_attribute_exclusion.product_template_attribute_value_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.product_template_attribute_value_id IS 'Attribute Value';


--
-- Name: COLUMN product_template_attribute_exclusion.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_template_attribute_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN product_template_attribute_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN product_template_attribute_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_template_attribute_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.write_date IS 'Last Updated on';


--
-- Name: product_template_attribute_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_template_attribute_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_template_attribute_exclusion_id_seq OWNER TO runbot;

--
-- Name: product_template_attribute_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_template_attribute_exclusion_id_seq OWNED BY public.product_template_attribute_exclusion.id;


--
-- Name: product_template_attribute_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_template_attribute_line (
    id integer NOT NULL,
    active boolean,
    product_tmpl_id integer NOT NULL,
    attribute_id integer NOT NULL,
    value_count integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.product_template_attribute_line OWNER TO runbot;

--
-- Name: TABLE product_template_attribute_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_template_attribute_line IS 'Product Template Attribute Line';


--
-- Name: COLUMN product_template_attribute_line.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.active IS 'Active';


--
-- Name: COLUMN product_template_attribute_line.product_tmpl_id;